/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity;

import com.azure.cosmos.implementation.Configs;
import com.azure.cosmos.implementation.ConnectionPolicy;
import com.azure.cosmos.implementation.DiagnosticsClientContext;
import com.azure.cosmos.implementation.GlobalEndpointManager;
import com.azure.cosmos.implementation.LifeCycleUtils;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.UserAgentContainer;
import com.azure.cosmos.implementation.clienttelemetry.ClientTelemetry;
import com.azure.cosmos.implementation.directconnectivity.HttpTransportClient;
import com.azure.cosmos.implementation.directconnectivity.IAddressResolver;
import com.azure.cosmos.implementation.directconnectivity.Protocol;
import com.azure.cosmos.implementation.directconnectivity.RntbdTransportClient;
import com.azure.cosmos.implementation.directconnectivity.StoreResponse;
import com.azure.cosmos.implementation.directconnectivity.TransportClient;
import com.azure.cosmos.implementation.directconnectivity.Uri;
import com.azure.cosmos.implementation.directconnectivity.rntbd.ProactiveOpenConnectionsProcessor;
import com.azure.cosmos.implementation.faultinjection.IFaultInjectorProvider;
import com.azure.cosmos.models.CosmosContainerIdentity;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class SharedTransportClient
extends TransportClient {
    private static final Logger logger = LoggerFactory.getLogger(SharedTransportClient.class);
    private static final AtomicInteger counter = new AtomicInteger(0);
    private static SharedTransportClient sharedTransportClient;
    private final RntbdTransportClient.Options rntbdOptions;
    private final TransportClient transportClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TransportClient getOrCreateInstance(Protocol protocol, Configs configs, ConnectionPolicy connectionPolicy, UserAgentContainer userAgent, DiagnosticsClientContext.DiagnosticsClientConfig diagnosticsClientConfig, IAddressResolver addressResolver, ClientTelemetry clientTelemetry, GlobalEndpointManager globalEndpointManager) {
        Class<SharedTransportClient> clazz = SharedTransportClient.class;
        synchronized (SharedTransportClient.class) {
            if (sharedTransportClient == null) {
                assert (counter.get() == 0);
                logger.info("creating a new shared RntbdTransportClient");
                sharedTransportClient = new SharedTransportClient(protocol, configs, connectionPolicy, userAgent, addressResolver, clientTelemetry, globalEndpointManager);
            } else {
                logger.info("Reusing an instance of RntbdTransportClient");
            }
            counter.incrementAndGet();
            if (SharedTransportClient.sharedTransportClient.rntbdOptions != null) {
                diagnosticsClientConfig.withRntbdOptions(SharedTransportClient.sharedTransportClient.rntbdOptions.toDiagnosticsString());
            }
            // ** MonitorExit[var8_8] (shouldn't be in output)
            return sharedTransportClient;
        }
    }

    private SharedTransportClient(Protocol protocol, Configs configs, ConnectionPolicy connectionPolicy, UserAgentContainer userAgent, IAddressResolver addressResolver, ClientTelemetry clientTelemetry, GlobalEndpointManager globalEndpointManager) {
        if (protocol == Protocol.TCP) {
            this.rntbdOptions = new RntbdTransportClient.Options.Builder(connectionPolicy).userAgent(userAgent).build();
            this.transportClient = new RntbdTransportClient(this.rntbdOptions, configs.getSslContext(connectionPolicy.isServerCertValidationDisabled()), addressResolver, clientTelemetry, globalEndpointManager);
        } else if (protocol == Protocol.HTTPS) {
            this.rntbdOptions = null;
            this.transportClient = new HttpTransportClient(configs, connectionPolicy, userAgent, globalEndpointManager);
        } else {
            throw new IllegalArgumentException(String.format("protocol: %s", new Object[]{protocol}));
        }
    }

    @Override
    protected Mono<StoreResponse> invokeStoreAsync(Uri physicalAddress, RxDocumentServiceRequest request) {
        return this.transportClient.invokeStoreAsync(physicalAddress, request);
    }

    @Override
    public void configureFaultInjectorProvider(IFaultInjectorProvider injectorProvider) {
        this.transportClient.configureFaultInjectorProvider(injectorProvider);
    }

    public int getReferenceCounter() {
        return counter.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        Class<SharedTransportClient> clazz = SharedTransportClient.class;
        synchronized (SharedTransportClient.class) {
            int numberOfActiveTransportClients = counter.decrementAndGet();
            logger.info("closing one reference to the shared RntbdTransportClient, the number of remaining references is {}", (Object)numberOfActiveTransportClients);
            if (numberOfActiveTransportClients == 0) {
                logger.info("All references to shared RntbdTransportClient are closed. Closing the underlying RntbdTransportClient");
                LifeCycleUtils.closeQuietly(SharedTransportClient.sharedTransportClient.transportClient);
                sharedTransportClient = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    protected GlobalEndpointManager getGlobalEndpointManager() {
        return this.transportClient.getGlobalEndpointManager();
    }

    @Override
    public ProactiveOpenConnectionsProcessor getProactiveOpenConnectionsProcessor() {
        return this.transportClient.getProactiveOpenConnectionsProcessor();
    }

    @Override
    public void recordOpenConnectionsAndInitCachesCompleted(List<CosmosContainerIdentity> cosmosContainerIdentities) {
        this.transportClient.recordOpenConnectionsAndInitCachesCompleted(cosmosContainerIdentities);
    }

    @Override
    public void recordOpenConnectionsAndInitCachesStarted(List<CosmosContainerIdentity> cosmosContainerIdentities) {
        this.transportClient.recordOpenConnectionsAndInitCachesStarted(cosmosContainerIdentities);
    }
}

