/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.changefeed.common;

import com.azure.cosmos.CosmosItemSerializer;
import com.azure.cosmos.implementation.RxDocumentServiceRequest;
import com.azure.cosmos.implementation.changefeed.common.ChangeFeedMode;
import com.azure.cosmos.implementation.changefeed.common.ChangeFeedStartFromETagAndFeedRangeImpl;
import com.azure.cosmos.implementation.changefeed.common.ChangeFeedStartFromInternal;
import com.azure.cosmos.implementation.changefeed.common.ChangeFeedState;
import com.azure.cosmos.implementation.feedranges.FeedRangeContinuation;
import com.azure.cosmos.implementation.feedranges.FeedRangeEpkImpl;
import com.azure.cosmos.implementation.feedranges.FeedRangeInternal;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import com.azure.cosmos.implementation.query.CompositeContinuationToken;
import java.util.Objects;

public class ChangeFeedStateV1
extends ChangeFeedState {
    private final String containerRid;
    private final FeedRangeInternal feedRange;
    private final ChangeFeedMode mode;
    private final ChangeFeedStartFromInternal startFromSettings;
    private FeedRangeContinuation continuation;

    public ChangeFeedStateV1(String containerRid, FeedRangeInternal feedRange, ChangeFeedMode mode, ChangeFeedStartFromInternal startFromSettings, FeedRangeContinuation continuation) {
        this.containerRid = containerRid;
        this.feedRange = feedRange;
        this.startFromSettings = startFromSettings;
        this.continuation = continuation;
        this.mode = mode;
    }

    @Override
    public FeedRangeContinuation getContinuation() {
        return this.continuation;
    }

    @Override
    public ChangeFeedState setContinuation(FeedRangeContinuation continuation) {
        Preconditions.checkNotNull(continuation, "Argument 'continuation' must not be null.");
        continuation.validateContainer(this.containerRid);
        this.continuation = continuation;
        return this;
    }

    @Override
    public FeedRangeInternal getFeedRange() {
        return this.feedRange;
    }

    @Override
    public ChangeFeedMode getMode() {
        return this.mode;
    }

    @Override
    public ChangeFeedStartFromInternal getStartFromSettings() {
        return this.startFromSettings;
    }

    @Override
    public String applyServerResponseContinuation(String serverContinuationToken, RxDocumentServiceRequest request, boolean shouldMoveToNextTokenOnETagReplace) {
        Preconditions.checkNotNull(serverContinuationToken, "Argument 'serverContinuationToken' must not be null");
        Preconditions.checkNotNull(request, "Argument 'request' must not be null");
        if (this.continuation == null) {
            this.continuation = FeedRangeContinuation.create(this.containerRid, request.getFeedRange() != null ? request.getFeedRange() : new FeedRangeEpkImpl(request.getEffectiveRange()), request.getEffectiveRange());
        }
        this.continuation.replaceContinuation(serverContinuationToken, shouldMoveToNextTokenOnETagReplace);
        return this.toString();
    }

    @Override
    public String getContainerRid() {
        return this.containerRid;
    }

    private void populateEffectiveRangeAndStartFromSettingsToRequest(RxDocumentServiceRequest request) {
        CompositeContinuationToken continuationToken;
        if (this.continuation != null) {
            continuationToken = this.continuation.getCurrentContinuationToken();
            request.applyFeedRangeFilter(this.continuation.getFeedRange());
        } else {
            continuationToken = null;
            request.applyFeedRangeFilter(this.feedRange);
        }
        ChangeFeedStartFromInternal effectiveStartFrom = continuationToken == null || continuationToken.getToken() == null ? this.startFromSettings : new ChangeFeedStartFromETagAndFeedRangeImpl(continuationToken.getToken(), new FeedRangeEpkImpl(continuationToken.getRange()));
        this.populateStartFrom(this.startFromSettings, effectiveStartFrom, request);
    }

    private void populateStartFrom(ChangeFeedStartFromInternal initialStartFrom, ChangeFeedStartFromInternal effectiveStartFrom, RxDocumentServiceRequest request) {
        Preconditions.checkNotNull(initialStartFrom, "Argument 'initialStartFrom' should not be null");
        Preconditions.checkNotNull(effectiveStartFrom, "Argument 'effectiveStartFromSettings' should not be null");
        Preconditions.checkNotNull(request, "Argument 'request' should not be null");
        initialStartFrom.populateRequest(request, this.mode);
        effectiveStartFrom.populateRequest(request, this.mode);
    }

    @Override
    public void populatePropertyBag() {
        super.populatePropertyBag();
        this.set("V", 1, CosmosItemSerializer.DEFAULT_SERIALIZER);
        this.set("Rid", this.containerRid, CosmosItemSerializer.DEFAULT_SERIALIZER);
        this.set("Mode", this.mode, CosmosItemSerializer.DEFAULT_SERIALIZER);
        this.set("StartFrom", this.startFromSettings, CosmosItemSerializer.DEFAULT_SERIALIZER);
        if (this.continuation != null) {
            this.continuation.populatePropertyBag();
            this.set("Continuation", this.continuation, CosmosItemSerializer.DEFAULT_SERIALIZER);
            this.feedRange.removeProperties(this);
        } else {
            this.feedRange.setProperties(this, true);
        }
    }

    @Override
    public void populateRequest(RxDocumentServiceRequest request, int maxItemCount) {
        request.getHeaders().put("x-ms-max-item-count", String.valueOf(maxItemCount));
        request.getHeaders().put("x-ms-documentdb-populatequerymetrics", String.valueOf(true));
        switch (this.mode) {
            case INCREMENTAL: {
                request.getHeaders().put("A-IM", "Incremental Feed");
                break;
            }
            case FULL_FIDELITY: {
                request.getHeaders().put("A-IM", "Full-Fidelity Feed");
                request.useGatewayMode = true;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported change feed mode");
            }
        }
        this.populateEffectiveRangeAndStartFromSettingsToRequest(request);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ChangeFeedStateV1)) {
            return false;
        }
        ChangeFeedStateV1 other = (ChangeFeedStateV1)o;
        return Objects.equals(this.feedRange, other.feedRange) && Objects.equals(this.containerRid, other.containerRid) && Objects.equals(this.startFromSettings, other.startFromSettings) && Objects.equals((Object)this.mode, (Object)other.mode) && Objects.equals(this.continuation, other.continuation);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.feedRange, this.containerRid, this.startFromSettings, this.mode, this.continuation});
    }
}

