/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.models;

import com.azure.cosmos.implementation.DocumentCollection;
import com.azure.cosmos.implementation.ImplementationBridgeHelpers;
import com.azure.cosmos.implementation.Resource;
import com.azure.cosmos.implementation.apachecommons.lang.StringUtils;
import com.azure.cosmos.models.ChangeFeedPolicy;
import com.azure.cosmos.models.ClientEncryptionPolicy;
import com.azure.cosmos.models.ConflictResolutionPolicy;
import com.azure.cosmos.models.IndexingPolicy;
import com.azure.cosmos.models.PartitionKeyDefinition;
import com.azure.cosmos.models.UniqueKeyPolicy;
import com.azure.cosmos.util.Beta;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public final class CosmosContainerProperties {
    private final DocumentCollection documentCollection;
    private static final String PARTITION_KEY_TOKEN_DELIMETER = "/";

    public CosmosContainerProperties(String id, String partitionKeyPath) {
        this.documentCollection = new DocumentCollection();
        this.documentCollection.setId(id);
        PartitionKeyDefinition partitionKeyDef = new PartitionKeyDefinition();
        ArrayList<String> paths = new ArrayList<String>();
        paths.add(partitionKeyPath);
        partitionKeyDef.setPaths(paths);
        this.documentCollection.setPartitionKey(partitionKeyDef);
    }

    public CosmosContainerProperties(String id, PartitionKeyDefinition partitionKeyDefinition) {
        this.documentCollection = new DocumentCollection();
        this.documentCollection.setId(id);
        this.documentCollection.setPartitionKey(partitionKeyDefinition);
    }

    CosmosContainerProperties(String json) {
        this.documentCollection = new DocumentCollection(json);
    }

    CosmosContainerProperties(DocumentCollection collection) {
        this.documentCollection = new DocumentCollection(collection.toJson());
    }

    static List<CosmosContainerProperties> getFromV2Results(List<DocumentCollection> results) {
        return results.stream().map(CosmosContainerProperties::new).collect(Collectors.toList());
    }

    public IndexingPolicy getIndexingPolicy() {
        return this.documentCollection.getIndexingPolicy();
    }

    public CosmosContainerProperties setIndexingPolicy(IndexingPolicy indexingPolicy) {
        this.documentCollection.setIndexingPolicy(indexingPolicy);
        return this;
    }

    public UniqueKeyPolicy getUniqueKeyPolicy() {
        return this.documentCollection.getUniqueKeyPolicy();
    }

    public CosmosContainerProperties setUniqueKeyPolicy(UniqueKeyPolicy uniqueKeyPolicy) {
        this.documentCollection.setUniqueKeyPolicy(uniqueKeyPolicy);
        return this;
    }

    public PartitionKeyDefinition getPartitionKeyDefinition() {
        return this.documentCollection.getPartitionKey();
    }

    public CosmosContainerProperties setPartitionKeyDefinition(PartitionKeyDefinition partitionKeyDefinition) {
        this.documentCollection.setPartitionKey(partitionKeyDefinition);
        if (this.getClientEncryptionPolicy() != null) {
            this.getClientEncryptionPolicy().validatePartitionKeyPathsAreNotEncrypted(this.getPartitionKeyPathTokensList());
        }
        return this;
    }

    public ConflictResolutionPolicy getConflictResolutionPolicy() {
        return this.documentCollection.getConflictResolutionPolicy();
    }

    public CosmosContainerProperties setConflictResolutionPolicy(ConflictResolutionPolicy value) {
        this.documentCollection.setConflictResolutionPolicy(value);
        return this;
    }

    @Beta(value=Beta.SinceVersion.V4_12_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public ChangeFeedPolicy getChangeFeedPolicy() {
        return this.documentCollection.getChangeFeedPolicy();
    }

    @Beta(value=Beta.SinceVersion.V4_12_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public CosmosContainerProperties setChangeFeedPolicy(ChangeFeedPolicy value) {
        this.documentCollection.setChangeFeedPolicy(value);
        return this;
    }

    public Integer getDefaultTimeToLiveInSeconds() {
        return this.documentCollection.getDefaultTimeToLive();
    }

    public CosmosContainerProperties setDefaultTimeToLiveInSeconds(Integer timeToLive) {
        this.documentCollection.setDefaultTimeToLive(timeToLive);
        return this;
    }

    public CosmosContainerProperties setAnalyticalStoreTimeToLiveInSeconds(Integer timeToLive) {
        this.documentCollection.setAnalyticalStoreTimeToLiveInSeconds(timeToLive);
        return this;
    }

    public Integer getAnalyticalStoreTimeToLiveInSeconds() {
        return this.documentCollection.getAnalyticalStoreTimeToLiveInSeconds();
    }

    public String getId() {
        return this.documentCollection.getId();
    }

    public CosmosContainerProperties setId(String id) {
        this.documentCollection.setId(id);
        return this;
    }

    public String getResourceId() {
        return this.documentCollection.getResourceId();
    }

    public Instant getTimestamp() {
        return this.documentCollection.getTimestamp();
    }

    public String getETag() {
        return this.documentCollection.getETag();
    }

    @Beta(value=Beta.SinceVersion.V4_14_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public ClientEncryptionPolicy getClientEncryptionPolicy() {
        return this.documentCollection.getClientEncryptionPolicy();
    }

    @Beta(value=Beta.SinceVersion.V4_14_0, warningText="Preview API - subject to change in non-backwards compatible way")
    public CosmosContainerProperties setClientEncryptionPolicy(ClientEncryptionPolicy value) {
        if (value != null) {
            value.validatePartitionKeyPathsAreNotEncrypted(this.getPartitionKeyPathTokensList());
        }
        this.documentCollection.setClientEncryptionPolicy(value);
        return this;
    }

    Resource getResource() {
        return this.documentCollection;
    }

    String getSelfLink() {
        return this.documentCollection.getSelfLink();
    }

    DocumentCollection getV2Collection() {
        DocumentCollection collection = new DocumentCollection(this.documentCollection.toJson());
        collection.setPartitionKey(this.getPartitionKeyDefinition());
        collection.setIndexingPolicy(this.getIndexingPolicy());
        return collection;
    }

    List<List<String>> getPartitionKeyPathTokensList() {
        if (this.getPartitionKeyDefinition() == null) {
            throw new IllegalStateException("Container partition key is empty");
        }
        ArrayList<List<String>> partitionKeyPathTokensList = new ArrayList<List<String>>();
        for (String path : this.getPartitionKeyDefinition().getPaths()) {
            String[] splitPaths = path.split(PARTITION_KEY_TOKEN_DELIMETER);
            ArrayList<String> splitPathsList = new ArrayList<String>();
            for (int i = 0; i < splitPaths.length; ++i) {
                if (!StringUtils.isNotEmpty(splitPaths[i])) continue;
                splitPathsList.add(splitPaths[i]);
            }
            partitionKeyPathTokensList.add(splitPathsList);
        }
        return partitionKeyPathTokensList;
    }

    static void initialize() {
        ImplementationBridgeHelpers.CosmosContainerPropertiesHelper.setCosmosContainerPropertiesAccessor(new ImplementationBridgeHelpers.CosmosContainerPropertiesHelper.CosmosContainerPropertiesAccessor(){

            @Override
            public String getSelfLink(CosmosContainerProperties cosmosContainerProperties) {
                return cosmosContainerProperties.getSelfLink();
            }

            @Override
            public void setSelfLink(CosmosContainerProperties cosmosContainerProperties, String selfLink) {
                cosmosContainerProperties.documentCollection.setSelfLink(selfLink);
            }
        });
    }

    static {
        CosmosContainerProperties.initialize();
    }
}

