/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.directconnectivity.rntbd;

import com.azure.cosmos.implementation.DiagnosticsInstantSerializer;
import com.azure.cosmos.implementation.directconnectivity.RntbdConnectionStateListenerMetricsDiagnostics;
import com.azure.cosmos.implementation.directconnectivity.rntbd.RntbdConnectionStateListenerMetrics;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.io.Serializable;
import java.time.Instant;

@JsonSerialize(using=RntbdEndpointStatsJsonSerializer.class)
public class RntbdEndpointStatistics
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int availableChannels;
    private int acquiredChannels;
    private int executorTaskQueueSize;
    private int inflightRequests;
    private boolean closed;
    private long lastSuccessfulRequestNanoTime;
    private long lastRequestNanoTime;
    private Instant createdTime;
    private RntbdConnectionStateListenerMetricsDiagnostics connectionStateListenerMetrics;
    private static final Instant referenceInstant = Instant.now();
    private static final long referenceNanoTime = System.nanoTime();

    RntbdEndpointStatistics availableChannels(int availableChannels) {
        this.availableChannels = availableChannels;
        return this;
    }

    RntbdEndpointStatistics acquiredChannels(int acquiredChannels) {
        this.acquiredChannels = acquiredChannels;
        return this;
    }

    RntbdEndpointStatistics executorTaskQueueSize(int executorTaskQueueSize) {
        this.executorTaskQueueSize = executorTaskQueueSize;
        return this;
    }

    RntbdEndpointStatistics inflightRequests(int inflightRequests) {
        this.inflightRequests = inflightRequests;
        return this;
    }

    RntbdEndpointStatistics lastSuccessfulRequestNanoTime(long lastSuccessfulRequestNanoTime) {
        this.lastSuccessfulRequestNanoTime = lastSuccessfulRequestNanoTime;
        return this;
    }

    RntbdEndpointStatistics lastRequestNanoTime(long lastRequestNanoTime) {
        this.lastRequestNanoTime = lastRequestNanoTime;
        return this;
    }

    RntbdEndpointStatistics createdTime(Instant createdTime) {
        this.createdTime = createdTime;
        return this;
    }

    RntbdEndpointStatistics closed(boolean closed) {
        this.closed = closed;
        return this;
    }

    RntbdEndpointStatistics connectionStateListenerMetrics(RntbdConnectionStateListenerMetrics metrics) {
        this.connectionStateListenerMetrics = new RntbdConnectionStateListenerMetricsDiagnostics(metrics.getLastCallTimestamp(), metrics.getLastActionableContext());
        return this;
    }

    public static class RntbdEndpointStatsJsonSerializer
    extends JsonSerializer<RntbdEndpointStatistics> {
        public void serialize(RntbdEndpointStatistics stats, JsonGenerator writer, SerializerProvider serializerProvider) throws IOException {
            writer.writeStartObject();
            writer.writeNumberField("availableChannels", stats.availableChannels);
            writer.writeNumberField("acquiredChannels", stats.acquiredChannels);
            writer.writeNumberField("executorTaskQueueSize", stats.executorTaskQueueSize);
            writer.writeNumberField("inflightRequests", stats.inflightRequests);
            writer.writeStringField("lastSuccessfulRequestTime", this.toInstantString(stats.lastSuccessfulRequestNanoTime));
            writer.writeStringField("lastRequestTime", this.toInstantString(stats.lastRequestNanoTime));
            writer.writeStringField("createdTime", this.toInstantString(stats.createdTime));
            writer.writeBooleanField("isClosed", stats.closed);
            if (stats.connectionStateListenerMetrics != null) {
                writer.writeObjectField("cerMetrics", (Object)stats.connectionStateListenerMetrics);
            }
            writer.writeEndObject();
        }

        private String toInstantString(Instant instant) {
            return DiagnosticsInstantSerializer.fromInstant(instant);
        }

        private String toInstantString(long nanoTime) {
            Instant time = Instant.ofEpochMilli(referenceInstant.plusNanos(nanoTime - referenceNanoTime).toEpochMilli());
            return DiagnosticsInstantSerializer.fromInstant(time);
        }
    }
}

