/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.cpu;

import com.azure.cosmos.implementation.cpu.CpuLoad;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public class CpuLoadHistory {
    private static final String EMPTY = "empty";
    final List<CpuLoad> cpuLoad;
    final Duration monitoringInterval;
    final AtomicReference<Boolean> cpuOverload = new AtomicReference();
    private String cachedToString;

    public CpuLoadHistory(List<CpuLoad> cpuLoad, Duration monitoringInterval) {
        Preconditions.checkNotNull(cpuLoad, "cpuLoad");
        this.cpuLoad = cpuLoad;
        Preconditions.checkArgument(!monitoringInterval.isZero(), "monitoringInterval is zero");
        this.monitoringInterval = monitoringInterval;
    }

    public boolean isCpuOverloaded() {
        if (this.cpuOverload.get() == null) {
            this.cpuOverload.set(this.isCpuOverloadInternal());
        }
        return this.cpuOverload.get();
    }

    public String toString() {
        if (this.cachedToString == null) {
            this.cachedToString = this.toStringInternal();
        }
        return this.cachedToString;
    }

    private String toStringInternal() {
        if (this.cpuLoad == null || this.cpuLoad.isEmpty()) {
            return EMPTY;
        }
        return String.join((CharSequence)", ", this.cpuLoad.stream().map(c -> c.toString()).collect(Collectors.toList()));
    }

    Instant getLastTimestamp() {
        return this.cpuLoad.get((int)(this.cpuLoad.size() - 1)).timestamp;
    }

    private boolean isCpuOverloadInternal() {
        int index;
        for (index = 0; index < this.cpuLoad.size(); ++index) {
            if (!((double)this.cpuLoad.get((int)index).value > 90.0)) continue;
            return true;
        }
        for (index = 0; index < this.cpuLoad.size() - 1; ++index) {
            long totalMilliseconds = this.cpuLoad.get((int)(index + 1)).timestamp.toEpochMilli() - this.cpuLoad.get((int)index).timestamp.toEpochMilli();
            if (!((double)totalMilliseconds > 1.5 * (double)this.monitoringInterval.toMillis())) continue;
            return true;
        }
        return false;
    }
}

