/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.changefeed.fullfidelity;

import com.azure.cosmos.implementation.changefeed.Lease;
import com.azure.cosmos.implementation.changefeed.PartitionSupervisor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

class WorkerTask
extends Thread {
    private final Logger logger = LoggerFactory.getLogger(WorkerTask.class);
    private final AtomicBoolean done;
    private Mono<Void> job;
    private final Lease lease;
    private final PartitionSupervisor partitionSupervisor;

    WorkerTask(Lease lease, PartitionSupervisor partitionSupervisor, Mono<Void> job) {
        this.lease = lease;
        this.job = job;
        this.partitionSupervisor = partitionSupervisor;
        this.done = new AtomicBoolean(false);
    }

    @Override
    public void run() {
        this.job.doOnSuccess(avoid -> this.logger.info("Partition controller worker task {} has finished running.", (Object)this.lease.getLeaseToken())).doOnTerminate(() -> {
            this.logger.info("Partition controller worker task {} has exited.", (Object)this.lease.getLeaseToken());
            this.job = null;
            this.done.set(true);
        }).subscribe();
    }

    public void cancelJob() {
        this.partitionSupervisor.shutdown();
        this.interrupt();
    }

    public Lease lease() {
        return this.lease;
    }

    public boolean isRunning() {
        return !this.done.get();
    }
}

