/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation.changefeed.fullfidelity;

import com.azure.cosmos.implementation.changefeed.CancellationToken;
import com.azure.cosmos.implementation.changefeed.Lease;
import com.azure.cosmos.implementation.changefeed.LeaseCheckpointer;
import com.azure.cosmos.implementation.changefeed.PartitionCheckpointer;
import com.azure.cosmos.implementation.changefeed.common.ChangeFeedState;
import com.azure.cosmos.implementation.changefeed.exceptions.TaskCancelledException;
import com.azure.cosmos.implementation.guava25.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

class PartitionCheckpointerImpl
implements PartitionCheckpointer {
    private final Logger logger = LoggerFactory.getLogger(PartitionCheckpointerImpl.class);
    private final LeaseCheckpointer leaseCheckpointer;
    private Lease lease;
    private CancellationToken cancellationToken;

    public PartitionCheckpointerImpl(LeaseCheckpointer leaseCheckpointer, Lease lease) {
        this.leaseCheckpointer = leaseCheckpointer;
        this.lease = lease;
    }

    @Override
    public Mono<Lease> checkpointPartition(ChangeFeedState continuationState) {
        Preconditions.checkNotNull(continuationState, "Argument 'continuationState' must not be null.");
        Preconditions.checkArgument(continuationState.getContinuation().getContinuationTokenCount() == 1, "For ChangeFeedProcessor the continuation state should always have one range/continuation");
        if (this.cancellationToken.isCancellationRequested()) {
            return Mono.error((Throwable)new TaskCancelledException());
        }
        return this.leaseCheckpointer.checkpoint(this.lease, continuationState.toString(), this.cancellationToken).map(lease1 -> {
            this.lease = lease1;
            this.logger.info("Checkpoint: partition {}, new continuation {}", (Object)this.lease.getLeaseToken(), (Object)this.lease.getReadableContinuationToken());
            return lease1;
        });
    }

    @Override
    public PartitionCheckpointer setCancellationToken(CancellationToken cancellationToken) {
        this.cancellationToken = cancellationToken;
        return this;
    }
}

