/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.implementation.Utils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

public interface ItemDeserializer {
    public <T> T parseFrom(Class<T> var1, byte[] var2);

    public <T> T convert(Class<T> var1, JsonNode var2);

    public static class JsonDeserializer
    implements ItemDeserializer {
        @Override
        public <T> T parseFrom(Class<T> classType, byte[] bytes) {
            if (bytes == null) {
                return null;
            }
            return Utils.parse(bytes, classType);
        }

        @Override
        public <T> T convert(Class<T> classType, JsonNode jsonNode) {
            if (classType == ObjectNode.class) {
                return (T)jsonNode;
            }
            return (T)Utils.getSimpleObjectMapper().convertValue((Object)jsonNode, classType);
        }
    }
}

