/*
 * Decompiled with CFR 0.152.
 */
package com.azure.cosmos.implementation;

import com.azure.cosmos.implementation.Document;
import com.azure.cosmos.implementation.Resource;
import com.azure.cosmos.implementation.Utils;
import com.azure.cosmos.models.ModelBridgeInternal;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.stream.Collectors;

public class InternalObjectNode
extends Resource {
    private static final ObjectMapper MAPPER = Utils.getSimpleObjectMapper();

    public InternalObjectNode() {
    }

    public InternalObjectNode(byte[] bytes) {
        super(bytes);
    }

    public InternalObjectNode(ByteBuffer byteBuffer) {
        super(byteBuffer);
    }

    @Override
    public InternalObjectNode setId(String id) {
        super.setId(id);
        return this;
    }

    public InternalObjectNode(String jsonString) {
        super(jsonString);
    }

    public InternalObjectNode(ObjectNode propertyBag) {
        super(propertyBag);
    }

    public static InternalObjectNode fromObjectToInternalObjectNode(Object cosmosItem) {
        if (cosmosItem instanceof InternalObjectNode) {
            return (InternalObjectNode)cosmosItem;
        }
        if (cosmosItem instanceof byte[]) {
            return new InternalObjectNode((byte[])cosmosItem);
        }
        if (cosmosItem instanceof ObjectNode) {
            return new InternalObjectNode((ObjectNode)cosmosItem);
        }
        try {
            return new InternalObjectNode(MAPPER.writeValueAsString(cosmosItem));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can't serialize the object into the json string", e);
        }
    }

    public static Document fromObject(Object cosmosItem) {
        if (cosmosItem instanceof InternalObjectNode) {
            return new Document(((InternalObjectNode)cosmosItem).toJson());
        }
        if (cosmosItem instanceof byte[]) {
            return new Document((byte[])cosmosItem);
        }
        if (cosmosItem instanceof ObjectNode) {
            return new Document(new InternalObjectNode((ObjectNode)cosmosItem).toJson());
        }
        try {
            return new Document(MAPPER.writeValueAsString(cosmosItem));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can't serialize the object into the json string", e);
        }
    }

    public static ByteBuffer serializeJsonToByteBuffer(Object cosmosItem, ObjectMapper objectMapper) {
        if (cosmosItem instanceof InternalObjectNode) {
            return ((InternalObjectNode)cosmosItem).serializeJsonToByteBuffer();
        }
        if (cosmosItem instanceof Document) {
            return ModelBridgeInternal.serializeJsonToByteBuffer((Document)cosmosItem);
        }
        if (cosmosItem instanceof ObjectNode) {
            return new InternalObjectNode((ObjectNode)cosmosItem).serializeJsonToByteBuffer();
        }
        if (cosmosItem instanceof byte[]) {
            return ByteBuffer.wrap((byte[])cosmosItem);
        }
        return Utils.serializeJsonToByteBuffer(objectMapper, cosmosItem);
    }

    static <T> List<T> getTypedResultsFromV2Results(List<Document> results, Class<T> klass) {
        return results.stream().map(document -> ModelBridgeInternal.toObjectFromJsonSerializable(document, klass)).collect(Collectors.toList());
    }

    public <T> T getObject(Class<T> klass) throws IOException {
        if (klass == ObjectNode.class) {
            return (T)this.getPropertyBag();
        }
        return (T)MAPPER.treeToValue((TreeNode)this.getPropertyBag(), klass);
    }
}

