/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation;

import com.azure.core.amqp.AmqpRetryOptions;
import com.azure.core.amqp.AmqpTransportType;
import com.azure.core.amqp.ProxyOptions;
import com.azure.core.amqp.models.CbsAuthorizationType;
import com.azure.core.credential.TokenCredential;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.logging.ClientLogger;
import java.util.Objects;
import org.apache.qpid.proton.engine.SslDomain;
import reactor.core.scheduler.Scheduler;

public class ConnectionOptions {
    private final TokenCredential tokenCredential;
    private final AmqpTransportType transport;
    private final AmqpRetryOptions retryOptions;
    private final ProxyOptions proxyOptions;
    private final Scheduler scheduler;
    private final String fullyQualifiedNamespace;
    private final CbsAuthorizationType authorizationType;
    private final String authorizationScope;
    private final ClientOptions clientOptions;
    private final String product;
    private final String clientVersion;
    private final SslDomain.VerifyMode verifyMode;
    private final String hostname;
    private final int port;

    public ConnectionOptions(String fullyQualifiedNamespace, TokenCredential tokenCredential, CbsAuthorizationType authorizationType, String authorizationScope, AmqpTransportType transport, AmqpRetryOptions retryOptions, ProxyOptions proxyOptions, Scheduler scheduler, ClientOptions clientOptions, SslDomain.VerifyMode verifyMode, String product, String clientVersion) {
        this(fullyQualifiedNamespace, tokenCredential, authorizationType, authorizationScope, transport, retryOptions, proxyOptions, scheduler, clientOptions, verifyMode, product, clientVersion, fullyQualifiedNamespace, ConnectionOptions.getPort(transport));
    }

    public ConnectionOptions(String fullyQualifiedNamespace, TokenCredential tokenCredential, CbsAuthorizationType authorizationType, String authorizationScope, AmqpTransportType transport, AmqpRetryOptions retryOptions, ProxyOptions proxyOptions, Scheduler scheduler, ClientOptions clientOptions, SslDomain.VerifyMode verifyMode, String product, String clientVersion, String hostname, int port) {
        this.fullyQualifiedNamespace = Objects.requireNonNull(fullyQualifiedNamespace, "'fullyQualifiedNamespace' is required.");
        this.tokenCredential = Objects.requireNonNull(tokenCredential, "'tokenCredential' is required.");
        this.authorizationType = Objects.requireNonNull(authorizationType, "'authorizationType' is required.");
        this.authorizationScope = Objects.requireNonNull(authorizationScope, "'authorizationScope' is required.");
        this.transport = Objects.requireNonNull(transport, "'transport' is required.");
        this.retryOptions = Objects.requireNonNull(retryOptions, "'retryOptions' is required.");
        this.scheduler = Objects.requireNonNull(scheduler, "'scheduler' is required.");
        this.clientOptions = Objects.requireNonNull(clientOptions, "'clientOptions' is required.");
        this.verifyMode = Objects.requireNonNull(verifyMode, "'verifyMode' is required.");
        this.hostname = Objects.requireNonNull(hostname, "'hostname' cannot be null.");
        this.port = port != -1 ? port : ConnectionOptions.getPort(transport);
        this.proxyOptions = proxyOptions;
        this.product = Objects.requireNonNull(product, "'product' cannot be null.");
        this.clientVersion = Objects.requireNonNull(clientVersion, "'clientVersion' cannot be null.");
    }

    public String getAuthorizationScope() {
        return this.authorizationScope;
    }

    public CbsAuthorizationType getAuthorizationType() {
        return this.authorizationType;
    }

    public ClientOptions getClientOptions() {
        return this.clientOptions;
    }

    public String getProduct() {
        return this.product;
    }

    public String getClientVersion() {
        return this.clientVersion;
    }

    public String getFullyQualifiedNamespace() {
        return this.fullyQualifiedNamespace;
    }

    public AmqpRetryOptions getRetry() {
        return this.retryOptions;
    }

    public ProxyOptions getProxyOptions() {
        return this.proxyOptions;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public SslDomain.VerifyMode getSslVerifyMode() {
        return this.verifyMode;
    }

    public TokenCredential getTokenCredential() {
        return this.tokenCredential;
    }

    public AmqpTransportType getTransportType() {
        return this.transport;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    private static int getPort(AmqpTransportType transport) {
        switch (transport) {
            case AMQP: {
                return 5671;
            }
            case AMQP_WEB_SOCKETS: {
                return 443;
            }
        }
        throw (IllegalArgumentException)new ClientLogger(ConnectionOptions.class).logThrowableAsError((Throwable)new IllegalArgumentException("Transport Type is not supported: " + (Object)((Object)transport)));
    }
}

