/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.phonenumbers.siprouting;

import com.azure.communication.phonenumbers.siprouting.SipRoutingClientBuilder;
import com.azure.communication.phonenumbers.siprouting.implementation.SipRoutingAdminClientImpl;
import com.azure.communication.phonenumbers.siprouting.implementation.converters.SipTrunkConverter;
import com.azure.communication.phonenumbers.siprouting.implementation.converters.SipTrunkRouteConverter;
import com.azure.communication.phonenumbers.siprouting.implementation.models.CommunicationErrorResponseException;
import com.azure.communication.phonenumbers.siprouting.implementation.models.SipConfiguration;
import com.azure.communication.phonenumbers.siprouting.models.SipTrunk;
import com.azure.communication.phonenumbers.siprouting.models.SipTrunkRoute;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@ServiceClient(builder=SipRoutingClientBuilder.class)
public final class SipRoutingClient {
    private final SipRoutingAdminClientImpl client;

    SipRoutingClient(SipRoutingAdminClientImpl client) {
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SipTrunk getTrunk(String fqdn) {
        return SipTrunkConverter.convertFromApi(this.getSipConfiguration().getTrunks()).stream().filter(sipTrunk -> fqdn.equals(sipTrunk.getFqdn())).findAny().orElse(null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SipTrunk> getTrunkWithResponse(String fqdn, Context context) {
        return (Response)this.client.getSipRoutings().getWithResponseAsync(context).onErrorMap(CommunicationErrorResponseException.class, this::translateException).map(result -> new SimpleResponse(result, (Object)SipTrunkConverter.convertFromApi(((SipConfiguration)result.getValue()).getTrunks()).stream().filter(sipTrunk -> fqdn.equals(sipTrunk.getFqdn())).findAny().orElse(null))).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedIterable<SipTrunk> listTrunks() {
        return new PagedIterable(() -> this.getOnePageTrunk());
    }

    private PagedResponse<SipTrunk> getOnePageTrunk() {
        return (PagedResponse)this.client.getSipRoutings().getWithResponseAsync().onErrorMap(CommunicationErrorResponseException.class, this::translateException).map(result -> new PagedResponseBase(result.getRequest(), result.getStatusCode(), result.getHeaders(), SipTrunkConverter.convertFromApi(((SipConfiguration)result.getValue()).getTrunks()), null, null)).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedIterable<SipTrunkRoute> listRoutes() {
        return new PagedIterable(() -> this.getOnePageRoute());
    }

    private PagedResponse<SipTrunkRoute> getOnePageRoute() {
        return (PagedResponse)this.client.getSipRoutings().getWithResponseAsync().onErrorMap(CommunicationErrorResponseException.class, this::translateException).map(result -> new PagedResponseBase(result.getRequest(), result.getStatusCode(), result.getHeaders(), SipTrunkRouteConverter.convertFromApi(((SipConfiguration)result.getValue()).getRoutes()), null, null)).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setTrunk(SipTrunk trunk) {
        HashMap<String, com.azure.communication.phonenumbers.siprouting.implementation.models.SipTrunk> trunks = new HashMap<String, com.azure.communication.phonenumbers.siprouting.implementation.models.SipTrunk>();
        trunks.put(trunk.getFqdn(), SipTrunkConverter.convertToApi(trunk));
        this.client.getSipRoutings().updateWithResponseAsync(new SipConfiguration().setTrunks(trunks)).onErrorMap(CommunicationErrorResponseException.class, this::translateException).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setTrunks(List<SipTrunk> trunks) {
        SipConfiguration update = new SipConfiguration().setTrunks(SipTrunkConverter.convertToApi(trunks));
        List storedFqdns = this.listTrunks().stream().map(SipTrunk::getFqdn).collect(Collectors.toList());
        Set updatedFqdns = trunks.stream().map(SipTrunk::getFqdn).collect(Collectors.toSet());
        for (String storedFqdn : storedFqdns) {
            if (updatedFqdns.contains(storedFqdn)) continue;
            update.getTrunks().put(storedFqdn, null);
        }
        if (!update.getTrunks().isEmpty()) {
            this.setSipConfiguration(update);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setTrunksWithResponse(List<SipTrunk> trunks, Context context) {
        SipConfiguration update = new SipConfiguration().setTrunks(SipTrunkConverter.convertToApi(trunks));
        List storedFqdns = this.listTrunks().stream().map(SipTrunk::getFqdn).collect(Collectors.toList());
        Set updatedFqdns = trunks.stream().map(SipTrunk::getFqdn).collect(Collectors.toSet());
        for (String storedFqdn : storedFqdns) {
            if (updatedFqdns.contains(storedFqdn)) continue;
            update.getTrunks().put(storedFqdn, null);
        }
        if (!update.getTrunks().isEmpty()) {
            return (Response)this.client.getSipRoutings().updateWithResponseAsync(update, context).onErrorMap(CommunicationErrorResponseException.class, this::translateException).map(result -> new SimpleResponse(result, null)).block();
        }
        return new SimpleResponse(null, 200, null, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setRoutes(List<SipTrunkRoute> routes) {
        this.setSipConfiguration(new SipConfiguration().setRoutes(SipTrunkRouteConverter.convertToApi(routes)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> setRoutesWithResponse(List<SipTrunkRoute> routes, Context context) {
        return (Response)this.client.getSipRoutings().updateWithResponseAsync(new SipConfiguration().setRoutes(SipTrunkRouteConverter.convertToApi(routes)), context).onErrorMap(CommunicationErrorResponseException.class, this::translateException).map(result -> new SimpleResponse(result, null)).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteTrunk(String fqdn) {
        PagedIterable<SipTrunk> trunks = this.listTrunks();
        List deletedTrunks = trunks.stream().filter(trunk -> fqdn.equals(trunk.getFqdn())).collect(Collectors.toList());
        if (!deletedTrunks.isEmpty()) {
            HashMap<String, com.azure.communication.phonenumbers.siprouting.implementation.models.SipTrunk> trunksUpdate = new HashMap<String, com.azure.communication.phonenumbers.siprouting.implementation.models.SipTrunk>();
            trunksUpdate.put(fqdn, null);
            this.client.getSipRoutings().updateWithResponseAsync(new SipConfiguration().setTrunks(trunksUpdate)).onErrorMap(CommunicationErrorResponseException.class, this::translateException).block();
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteTrunkWithResponse(String fqdn, Context context) {
        PagedIterable<SipTrunk> trunks = this.listTrunks();
        List deletedTrunks = trunks.stream().filter(trunk -> fqdn.equals(trunk.getFqdn())).collect(Collectors.toList());
        if (!deletedTrunks.isEmpty()) {
            HashMap<String, com.azure.communication.phonenumbers.siprouting.implementation.models.SipTrunk> trunksUpdate = new HashMap<String, com.azure.communication.phonenumbers.siprouting.implementation.models.SipTrunk>();
            trunksUpdate.put(fqdn, null);
            return (Response)this.client.getSipRoutings().updateWithResponseAsync(new SipConfiguration().setTrunks(trunksUpdate), context).onErrorMap(CommunicationErrorResponseException.class, this::translateException).map(result -> new SimpleResponse(result, null)).block();
        }
        return new SimpleResponse(null, 200, null, null);
    }

    private SipConfiguration getSipConfiguration() {
        return (SipConfiguration)this.client.getSipRoutings().getAsync().onErrorMap(CommunicationErrorResponseException.class, this::translateException).block();
    }

    private SipConfiguration setSipConfiguration(SipConfiguration update) {
        return (SipConfiguration)this.client.getSipRoutings().updateAsync(update).onErrorMap(CommunicationErrorResponseException.class, this::translateException).block();
    }

    private HttpResponseException translateException(CommunicationErrorResponseException exception) {
        return new HttpResponseException(exception.getMessage(), exception.getResponse());
    }
}

