/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.phonenumbers.implementation.models;

import com.azure.communication.phonenumbers.models.PhoneNumberAssignmentType;
import com.azure.communication.phonenumbers.models.PhoneNumberCapabilities;
import com.azure.communication.phonenumbers.models.PhoneNumberType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class PhoneNumberSearchRequest
implements JsonSerializable<PhoneNumberSearchRequest> {
    private PhoneNumberType phoneNumberType;
    private PhoneNumberAssignmentType assignmentType;
    private PhoneNumberCapabilities capabilities;
    private String areaCode;
    private Integer quantity;

    public PhoneNumberType getPhoneNumberType() {
        return this.phoneNumberType;
    }

    public PhoneNumberSearchRequest setPhoneNumberType(PhoneNumberType phoneNumberType) {
        this.phoneNumberType = phoneNumberType;
        return this;
    }

    public PhoneNumberAssignmentType getAssignmentType() {
        return this.assignmentType;
    }

    public PhoneNumberSearchRequest setAssignmentType(PhoneNumberAssignmentType assignmentType) {
        this.assignmentType = assignmentType;
        return this;
    }

    public PhoneNumberCapabilities getCapabilities() {
        return this.capabilities;
    }

    public PhoneNumberSearchRequest setCapabilities(PhoneNumberCapabilities capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    public String getAreaCode() {
        return this.areaCode;
    }

    public PhoneNumberSearchRequest setAreaCode(String areaCode) {
        this.areaCode = areaCode;
        return this;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public PhoneNumberSearchRequest setQuantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("phoneNumberType", this.phoneNumberType == null ? null : this.phoneNumberType.toString());
        jsonWriter.writeStringField("assignmentType", this.assignmentType == null ? null : this.assignmentType.toString());
        jsonWriter.writeJsonField("capabilities", (JsonSerializable)this.capabilities);
        jsonWriter.writeStringField("areaCode", this.areaCode);
        jsonWriter.writeNumberField("quantity", (Number)this.quantity);
        return jsonWriter.writeEndObject();
    }

    public static PhoneNumberSearchRequest fromJson(JsonReader jsonReader) throws IOException {
        return (PhoneNumberSearchRequest)jsonReader.readObject(reader -> {
            PhoneNumberSearchRequest deserializedPhoneNumberSearchRequest = new PhoneNumberSearchRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("phoneNumberType".equals(fieldName)) {
                    deserializedPhoneNumberSearchRequest.phoneNumberType = PhoneNumberType.fromString(reader.getString());
                    continue;
                }
                if ("assignmentType".equals(fieldName)) {
                    deserializedPhoneNumberSearchRequest.assignmentType = PhoneNumberAssignmentType.fromString(reader.getString());
                    continue;
                }
                if ("capabilities".equals(fieldName)) {
                    deserializedPhoneNumberSearchRequest.capabilities = PhoneNumberCapabilities.fromJson(reader);
                    continue;
                }
                if ("areaCode".equals(fieldName)) {
                    deserializedPhoneNumberSearchRequest.areaCode = reader.getString();
                    continue;
                }
                if ("quantity".equals(fieldName)) {
                    deserializedPhoneNumberSearchRequest.quantity = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPhoneNumberSearchRequest;
        });
    }
}

