/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.email.models;

import com.azure.communication.email.models.EmailSendStatus;
import com.azure.core.models.ResponseError;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class EmailSendResult
implements JsonSerializable<EmailSendResult> {
    private String id;
    private EmailSendStatus status;
    private ResponseError error;

    public EmailSendResult(String id, EmailSendStatus status, ResponseError error) {
        this.id = id;
        this.status = status;
        this.error = error;
    }

    public String getId() {
        return this.id;
    }

    public EmailSendStatus getStatus() {
        return this.status;
    }

    public ResponseError getError() {
        return this.error;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("status", this.status != null ? this.status.toString() : null);
        jsonWriter.writeJsonField("error", (JsonSerializable)this.error);
        return jsonWriter.writeEndObject();
    }

    public static EmailSendResult fromJson(JsonReader jsonReader) throws IOException {
        return (EmailSendResult)jsonReader.readObject(reader -> {
            String id = null;
            EmailSendStatus status = null;
            ResponseError error = null;
            while (jsonReader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    status = EmailSendStatus.fromString(reader.getString());
                    continue;
                }
                if ("error".equals(fieldName)) {
                    error = ResponseError.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return new EmailSendResult(id, status, error);
        });
    }
}

