/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.email.implementation;

import com.azure.communication.email.implementation.AzureCommunicationEmailServiceImpl;
import com.azure.communication.email.implementation.models.EmailMessage;
import com.azure.communication.email.implementation.models.EmailSendResult;
import com.azure.communication.email.implementation.models.EmailsGetSendResultResponse;
import com.azure.communication.email.implementation.models.EmailsSendResponse;
import com.azure.communication.email.implementation.models.ErrorResponseException;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.DefaultPollingStrategy;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.PollingStrategy;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.TypeReference;
import java.time.Duration;
import java.util.UUID;
import reactor.core.publisher.Mono;

public final class EmailsImpl {
    private final EmailsService service;
    private final AzureCommunicationEmailServiceImpl client;

    EmailsImpl(AzureCommunicationEmailServiceImpl client) {
        this.service = (EmailsService)RestProxy.create(EmailsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<EmailsGetSendResultResponse> getSendResultWithResponseAsync(String operationId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getSendResult(this.client.getEndpoint(), operationId, this.client.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<EmailsGetSendResultResponse> getSendResultWithResponseAsync(String operationId, Context context) {
        String accept = "application/json";
        return this.service.getSendResult(this.client.getEndpoint(), operationId, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<EmailSendResult> getSendResultAsync(String operationId) {
        return this.getSendResultWithResponseAsync(operationId).flatMap(res -> Mono.justOrEmpty((Object)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<EmailSendResult> getSendResultAsync(String operationId, Context context) {
        return this.getSendResultWithResponseAsync(operationId, context).flatMap(res -> Mono.justOrEmpty((Object)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<EmailsSendResponse> sendWithResponseAsync(EmailMessage message, UUID operationId, UUID clientRequestId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.send(this.client.getEndpoint(), operationId, clientRequestId, this.client.getApiVersion(), message, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<EmailsSendResponse> sendWithResponseAsync(EmailMessage message, UUID operationId, UUID clientRequestId, Context context) {
        String accept = "application/json";
        return this.service.send(this.client.getEndpoint(), operationId, clientRequestId, this.client.getApiVersion(), message, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<EmailSendResult, EmailSendResult> beginSendAsync(EmailMessage message, UUID operationId, UUID clientRequestId) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.sendWithResponseAsync(message, operationId, clientRequestId), (PollingStrategy)new DefaultPollingStrategy(this.client.getHttpPipeline(), "{endpoint}".replace("{endpoint}", this.client.getEndpoint()), null, Context.NONE), (TypeReference)TypeReference.createInstance(EmailSendResult.class), (TypeReference)TypeReference.createInstance(EmailSendResult.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<EmailSendResult, EmailSendResult> beginSendAsync(EmailMessage message, UUID operationId, UUID clientRequestId, Context context) {
        return PollerFlux.create((Duration)Duration.ofSeconds(1L), () -> this.sendWithResponseAsync(message, operationId, clientRequestId, context), (PollingStrategy)new DefaultPollingStrategy(this.client.getHttpPipeline(), "{endpoint}".replace("{endpoint}", this.client.getEndpoint()), null, context), (TypeReference)TypeReference.createInstance(EmailSendResult.class), (TypeReference)TypeReference.createInstance(EmailSendResult.class));
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="AzureCommunicationEm")
    public static interface EmailsService {
        @Get(value="/emails/operations/{operationId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<EmailsGetSendResultResponse> getSendResult(@HostParam(value="endpoint") String var1, @PathParam(value="operationId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/emails:send")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<EmailsSendResponse> send(@HostParam(value="endpoint") String var1, @HeaderParam(value="Operation-Id") UUID var2, @HeaderParam(value="x-ms-client-request-id") UUID var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") EmailMessage var5, @HeaderParam(value="Accept") String var6, Context var7);
    }
}

