/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.chat;

import com.azure.communication.chat.ChatAsyncClient;
import com.azure.communication.chat.ChatClientBuilder;
import com.azure.communication.chat.ChatThreadAsyncClient;
import com.azure.communication.chat.ChatThreadClient;
import com.azure.communication.chat.models.ChatThreadItem;
import com.azure.communication.chat.models.CreateChatThreadOptions;
import com.azure.communication.chat.models.CreateChatThreadResult;
import com.azure.communication.chat.models.ListChatThreadsOptions;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;

@ServiceClient(builder=ChatClientBuilder.class, isAsync=false)
public final class ChatClient {
    private final ClientLogger logger = new ClientLogger(ChatClient.class);
    private final ChatAsyncClient client;

    ChatClient(ChatAsyncClient client) {
        this.client = client;
    }

    public ChatThreadClient getChatThreadClient(String chatThreadId) {
        ChatThreadAsyncClient chatThreadAsyncClient = this.client.getChatThreadClient(chatThreadId);
        return new ChatThreadClient(chatThreadAsyncClient);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CreateChatThreadResult createChatThread(CreateChatThreadOptions options) {
        return (CreateChatThreadResult)this.client.createChatThread(options).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CreateChatThreadResult> createChatThreadWithResponse(CreateChatThreadOptions options, Context context) {
        return (Response)this.client.createChatThread(options, context).map(result -> new SimpleResponse(result, (Object)((CreateChatThreadResult)result.getValue()))).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteChatThread(String chatThreadId) {
        this.client.deleteChatThread(chatThreadId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteChatThreadWithResponse(String chatThreadId, Context context) {
        return (Response)this.client.deleteChatThread(chatThreadId, context).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ChatThreadItem> listChatThreads() {
        return new PagedIterable(this.client.listChatThreads());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ChatThreadItem> listChatThreads(ListChatThreadsOptions listThreadsOptions, Context context) {
        return new PagedIterable(this.client.listChatThreads(listThreadsOptions, context));
    }
}

