/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.models.events;

import com.azure.communication.callautomation.models.RecordingKind;
import com.azure.communication.callautomation.models.RecordingState;
import com.azure.communication.callautomation.models.events.CallAutomationEventBase;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class RecordingStateChanged
extends CallAutomationEventBase {
    private String recordingId;
    private RecordingState recordingState;
    private RecordingKind recordingKind;
    private OffsetDateTime startDateTime;

    private RecordingStateChanged() {
    }

    public String getRecordingId() {
        return this.recordingId;
    }

    public RecordingState getRecordingState() {
        return this.recordingState;
    }

    public RecordingKind getRecordingKind() {
        return this.recordingKind;
    }

    public OffsetDateTime getStartDateTime() {
        return this.startDateTime;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("startDateTime", this.startDateTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
        jsonWriter.writeStringField("recordingId", this.recordingId);
        jsonWriter.writeStringField("state", this.recordingState != null ? this.recordingState.toString() : null);
        super.writeFields(jsonWriter);
        return jsonWriter.writeEndObject();
    }

    public static RecordingStateChanged fromJson(JsonReader jsonReader) throws IOException {
        return (RecordingStateChanged)jsonReader.readObject(reader -> {
            RecordingStateChanged event = new RecordingStateChanged();
            while (jsonReader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("startDateTime".equals(fieldName)) {
                    event.startDateTime = OffsetDateTime.parse(reader.getString(), DateTimeFormatter.ISO_OFFSET_DATE_TIME);
                    continue;
                }
                if ("recordingId".equals(fieldName)) {
                    event.recordingId = reader.getString();
                    continue;
                }
                if ("state".equals(fieldName)) {
                    event.recordingState = RecordingState.fromString(reader.getString());
                    continue;
                }
                if (event.readField(fieldName, (JsonReader)reader)) continue;
                reader.skipChildren();
            }
            return event;
        });
    }
}

