/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.models.events;

import com.azure.communication.callautomation.models.CallMediaRecognitionType;
import com.azure.communication.callautomation.models.ChoiceResult;
import com.azure.communication.callautomation.models.DtmfResult;
import com.azure.communication.callautomation.models.RecognizeResult;
import com.azure.communication.callautomation.models.SpeechResult;
import com.azure.communication.callautomation.models.events.CallAutomationEventBaseWithReasonCode;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Optional;

public final class RecognizeCompleted
extends CallAutomationEventBaseWithReasonCode {
    private CallMediaRecognitionType recognitionType;
    private DtmfResult dtmfResult;
    private SpeechResult speechResult;
    private ChoiceResult collectChoiceResult;

    public Optional<RecognizeResult> getRecognizeResult() {
        if (this.recognitionType == CallMediaRecognitionType.DTMF) {
            return Optional.ofNullable(this.dtmfResult);
        }
        if (this.recognitionType == CallMediaRecognitionType.CHOICES) {
            return Optional.ofNullable(this.collectChoiceResult);
        }
        if (this.recognitionType == CallMediaRecognitionType.SPEECH) {
            return Optional.ofNullable(this.speechResult);
        }
        return Optional.empty();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("recognitionType", this.recognitionType != null ? this.recognitionType.toString() : null);
        jsonWriter.writeJsonField("dtmfResult", (JsonSerializable)this.dtmfResult);
        jsonWriter.writeJsonField("speechResult", (JsonSerializable)this.speechResult);
        jsonWriter.writeJsonField("choiceResult", (JsonSerializable)this.collectChoiceResult);
        super.writeFields(jsonWriter);
        return jsonWriter.writeEndObject();
    }

    public static RecognizeCompleted fromJson(JsonReader jsonReader) throws IOException {
        return (RecognizeCompleted)jsonReader.readObject(reader -> {
            RecognizeCompleted event = new RecognizeCompleted();
            while (jsonReader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("recognitionType".equals(fieldName)) {
                    event.recognitionType = CallMediaRecognitionType.fromString(reader.getString());
                    continue;
                }
                if ("dtmfResult".equals(fieldName)) {
                    event.dtmfResult = DtmfResult.fromJson(reader);
                    continue;
                }
                if ("speechResult".equals(fieldName)) {
                    event.speechResult = SpeechResult.fromJson(reader);
                    continue;
                }
                if ("choiceResult".equals(fieldName)) {
                    event.collectChoiceResult = ChoiceResult.fromJson(reader);
                    continue;
                }
                if (event.readField(fieldName, (JsonReader)reader)) continue;
                reader.skipChildren();
            }
            return event;
        });
    }
}

