/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.models;

import com.azure.communication.callautomation.implementation.accesshelpers.MediaStreamingSubscriptionConstructorProxy;
import com.azure.communication.callautomation.implementation.models.MediaStreamingSubscriptionInternal;
import com.azure.communication.callautomation.models.MediaStreamingContentType;
import com.azure.communication.callautomation.models.MediaStreamingSubscriptionState;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;

public final class MediaStreamingSubscription
implements JsonSerializable<MediaStreamingSubscription> {
    private String id;
    private MediaStreamingSubscriptionState state;
    private List<MediaStreamingContentType> subscribedContentTypes;

    MediaStreamingSubscription() {
        this.id = null;
        this.state = null;
        this.subscribedContentTypes = null;
    }

    MediaStreamingSubscription(MediaStreamingSubscriptionInternal mediaStreamingSubscriptionInternal) {
        this.id = mediaStreamingSubscriptionInternal.getId() != null ? mediaStreamingSubscriptionInternal.getId() : null;
        this.state = mediaStreamingSubscriptionInternal.getState() != null ? MediaStreamingSubscriptionState.fromString(mediaStreamingSubscriptionInternal.getState().toString()) : null;
        this.subscribedContentTypes = mediaStreamingSubscriptionInternal.getSubscribedContentTypes() != null ? mediaStreamingSubscriptionInternal.getSubscribedContentTypes().stream().map(contentType -> MediaStreamingContentType.fromString(contentType.toString())).collect(Collectors.toList()) : null;
    }

    public String getId() {
        return this.id;
    }

    public MediaStreamingSubscriptionState getState() {
        return this.state;
    }

    public List<MediaStreamingContentType> getSubscribedContentTypes() {
        return this.subscribedContentTypes;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeArrayField("subscribedContentTypes", this.subscribedContentTypes, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        return jsonWriter.writeEndObject();
    }

    public static MediaStreamingSubscription fromJson(JsonReader jsonReader) throws IOException {
        return (MediaStreamingSubscription)jsonReader.readObject(reader -> {
            MediaStreamingSubscription deserializedMediaStreamingSubscription = new MediaStreamingSubscription();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMediaStreamingSubscription.id = reader.getString();
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedMediaStreamingSubscription.state = MediaStreamingSubscriptionState.fromString(reader.getString());
                    continue;
                }
                if ("subscribedContentTypes".equals(fieldName)) {
                    List subscribedContentTypes;
                    deserializedMediaStreamingSubscription.subscribedContentTypes = subscribedContentTypes = reader.readArray(reader1 -> MediaStreamingContentType.fromString(reader1.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMediaStreamingSubscription;
        });
    }

    static {
        MediaStreamingSubscriptionConstructorProxy.setAccessor(new MediaStreamingSubscriptionConstructorProxy.MediaStreamingSubscriptionConstructorAccessor(){

            @Override
            public MediaStreamingSubscription create(MediaStreamingSubscriptionInternal internalHeaders) {
                return new MediaStreamingSubscription(internalHeaders);
            }
        });
    }
}

