/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.models;

import com.azure.communication.callautomation.implementation.converters.CommunicationIdentifierConverter;
import com.azure.communication.callautomation.implementation.models.CommunicationIdentifierModel;
import com.azure.communication.callautomation.models.CallMediaRecognizeOptions;
import com.azure.communication.callautomation.models.DtmfTone;
import com.azure.communication.callautomation.models.RecognizeInputType;
import com.azure.communication.common.CommunicationIdentifier;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;
import java.util.List;

public class CallMediaRecognizeSpeechOrDtmfOptions
extends CallMediaRecognizeOptions {
    private Duration endSilenceTimeout;
    private String speechLanguage;
    private String speechRecognitionModelEndpointId;
    private Duration interToneTimeout;
    private Integer maxTonesToCollect;
    private List<DtmfTone> stopDtmfTones;

    public Duration getInterToneTimeout() {
        return this.interToneTimeout;
    }

    public CallMediaRecognizeSpeechOrDtmfOptions setInterToneTimeout(Duration interToneTimeout) {
        this.interToneTimeout = interToneTimeout;
        return this;
    }

    public int getMaxTonesToCollect() {
        return this.maxTonesToCollect;
    }

    public List<DtmfTone> getStopTones() {
        return this.stopDtmfTones;
    }

    public CallMediaRecognizeSpeechOrDtmfOptions setStopTones(List<DtmfTone> stopDtmfTones) {
        this.stopDtmfTones = stopDtmfTones;
        return this;
    }

    public Duration getEndSilenceTimeout() {
        return this.endSilenceTimeout;
    }

    public CallMediaRecognizeSpeechOrDtmfOptions setSpeechLanguage(String speechLanguage) {
        this.speechLanguage = speechLanguage;
        return this;
    }

    public String getSpeechLanguage() {
        return this.speechLanguage;
    }

    public String getSpeechRecognitionModelEndpointId() {
        return this.speechRecognitionModelEndpointId;
    }

    public CallMediaRecognizeSpeechOrDtmfOptions setSpeechRecognitionModelEndpointId(String speechRecognitionModelEndpointId) {
        this.speechRecognitionModelEndpointId = speechRecognitionModelEndpointId;
        return this;
    }

    public CallMediaRecognizeSpeechOrDtmfOptions(CommunicationIdentifier targetParticipant, int maxTonesToCollect, Duration endSilenceTimeout) {
        super(RecognizeInputType.SPEECH_OR_DTMF, targetParticipant);
        this.endSilenceTimeout = endSilenceTimeout;
        this.interToneTimeout = Duration.ofSeconds(2L);
        this.maxTonesToCollect = maxTonesToCollect;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("recognizeInputType", "speechordtmf");
        jsonWriter.writeJsonField("playPrompt", (JsonSerializable)this.getPlayPrompt());
        jsonWriter.writeArrayField("playPrompts", this.getPlayPrompts(), (writer, playPrompt) -> playPrompt.toJson(writer));
        jsonWriter.writeBooleanField("interruptCallMediaOperation", this.isInterruptCallMediaOperation());
        jsonWriter.writeBooleanField("stopCurrentOperations", this.isStopCurrentOperations());
        jsonWriter.writeStringField("operationContext", this.getOperationContext());
        jsonWriter.writeBooleanField("interruptPrompt", this.isInterruptPrompt());
        jsonWriter.writeStringField("initialSilenceTimeout", CoreUtils.durationToStringWithDays((Duration)this.getInitialSilenceTimeout()));
        jsonWriter.writeStringField("speechModelEndpointId", this.getSpeechRecognitionModelEndpointId());
        CommunicationIdentifierModel participant = CommunicationIdentifierConverter.convert(this.getTargetParticipant());
        jsonWriter.writeJsonField("targetParticipant", (JsonSerializable)participant);
        jsonWriter.writeStringField("operationCallbackUrl", this.getOperationCallbackUrl());
        jsonWriter.writeStringField("endSilenceTimeout", CoreUtils.durationToStringWithDays((Duration)this.endSilenceTimeout));
        jsonWriter.writeStringField("speechLanguage", this.speechLanguage);
        jsonWriter.writeStringField("speechRecognitionModelEndpointId", this.speechRecognitionModelEndpointId);
        jsonWriter.writeStringField("interToneTimeout", CoreUtils.durationToStringWithDays((Duration)this.interToneTimeout));
        if (this.maxTonesToCollect != null) {
            jsonWriter.writeNumberField("maxTonesToCollect", (Number)this.maxTonesToCollect);
        }
        jsonWriter.writeArrayField("stopTones", this.stopDtmfTones, (writer, element) -> writer.writeString(element.toString()));
        return jsonWriter.writeEndObject();
    }

    public static CallMediaRecognizeSpeechOrDtmfOptions fromJson(JsonReader jsonReader) throws IOException {
        return (CallMediaRecognizeSpeechOrDtmfOptions)jsonReader.readObject(reader -> {
            Duration endSilenceTimeout = null;
            String speechLanguage = null;
            String speechRecognitionModelEndpointId = null;
            Duration interToneTimeout = null;
            int maxTonesToCollect = 0;
            List stopDtmfTones = null;
            String recognizeInputType = null;
            Boolean interruptCallMediaOperation = null;
            Boolean stopCurrentOperations = null;
            String operationContext = null;
            Boolean interruptPrompt = null;
            Duration initialSilenceTimeout = null;
            String speechModelEndpointId = null;
            String operationCallbackUrl = null;
            CommunicationIdentifier targetParticipant = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                Object value;
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("endSilenceTimeout".equals(fieldName)) {
                    endSilenceTimeout = Duration.parse(reader.getString());
                    continue;
                }
                if ("speechLanguage".equals(fieldName)) {
                    speechLanguage = reader.getString();
                    continue;
                }
                if ("speechRecognitionModelEndpointId".equals(fieldName)) {
                    speechRecognitionModelEndpointId = reader.getString();
                    continue;
                }
                if ("interToneTimeout".equals(fieldName)) {
                    value = reader.getString();
                    interToneTimeout = value != null ? Duration.parse((CharSequence)value) : null;
                    continue;
                }
                if ("maxTonesToCollect".equals(fieldName)) {
                    value = (Integer)reader.getNullable(JsonReader::getInt);
                    maxTonesToCollect = value != null ? (Integer)value : 0;
                    continue;
                }
                if ("stopTones".equals(fieldName)) {
                    stopDtmfTones = reader.readArray(r -> DtmfTone.fromString(r.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            CallMediaRecognizeSpeechOrDtmfOptions options = new CallMediaRecognizeSpeechOrDtmfOptions(targetParticipant, maxTonesToCollect, endSilenceTimeout);
            options.speechLanguage = speechLanguage;
            options.speechRecognitionModelEndpointId = speechRecognitionModelEndpointId;
            options.interToneTimeout = interToneTimeout;
            options.stopDtmfTones = stopDtmfTones;
            options.setRecognizeInputType(RecognizeInputType.fromString(recognizeInputType));
            options.setInterruptCallMediaOperation(interruptCallMediaOperation);
            options.setStopCurrentOperations(stopCurrentOperations);
            options.setOperationContext(operationContext);
            options.setInterruptPrompt(interruptPrompt);
            options.setInitialSilenceTimeout(initialSilenceTimeout);
            options.setSpeechRecognitionModelEndpointId(speechModelEndpointId);
            options.setOperationCallbackUrl(operationCallbackUrl);
            return options;
        });
    }
}

