/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.models;

import com.azure.communication.callautomation.models.CallMediaRecognizeChoiceOptions;
import com.azure.communication.callautomation.models.CallMediaRecognizeDtmfOptions;
import com.azure.communication.callautomation.models.CallMediaRecognizeSpeechOptions;
import com.azure.communication.callautomation.models.CallMediaRecognizeSpeechOrDtmfOptions;
import com.azure.communication.callautomation.models.PlaySource;
import com.azure.communication.callautomation.models.RecognizeInputType;
import com.azure.communication.common.CommunicationIdentifier;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import java.io.IOException;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;

public abstract class CallMediaRecognizeOptions
implements JsonSerializable<CallMediaRecognizeOptions> {
    private RecognizeInputType recognizeInputType;
    private PlaySource playPrompt;
    private List<PlaySource> playPrompts;
    private Boolean interruptCallMediaOperation;
    private Boolean stopCurrentOperations;
    private String operationContext;
    private Boolean interruptPrompt;
    private Duration initialSilenceTimeout;
    private String speechModelEndpointId;
    private CommunicationIdentifier targetParticipant;
    private String operationCallbackUrl;

    public CallMediaRecognizeOptions(RecognizeInputType recognizeInputType, CommunicationIdentifier targetParticipant) {
        this.recognizeInputType = recognizeInputType;
        this.targetParticipant = targetParticipant;
        this.initialSilenceTimeout = Duration.ofSeconds(5L);
    }

    public RecognizeInputType getRecognizeInputType() {
        return this.recognizeInputType;
    }

    public CallMediaRecognizeOptions setRecognizeInputType(RecognizeInputType recognizeInputType) {
        this.recognizeInputType = recognizeInputType;
        return this;
    }

    @Deprecated
    public PlaySource getPlayPrompt() {
        return this.playPrompt;
    }

    @Deprecated
    public CallMediaRecognizeOptions setPlayPrompt(PlaySource playPrompt) {
        this.playPrompt = playPrompt;
        return this;
    }

    public List<PlaySource> getPlayPrompts() {
        return this.playPrompts;
    }

    public CallMediaRecognizeOptions setPlayPrompts(List<PlaySource> playPrompts) {
        this.playPrompts = playPrompts;
        return this;
    }

    public CallMediaRecognizeOptions setPlayPrompts(PlaySource ... playPrompts) {
        if (playPrompts != null) {
            this.playPrompts = Arrays.asList(playPrompts);
        }
        return this;
    }

    public Boolean isInterruptCallMediaOperation() {
        return this.interruptCallMediaOperation;
    }

    public CallMediaRecognizeOptions setInterruptCallMediaOperation(Boolean interruptCallMediaOperation) {
        this.interruptCallMediaOperation = interruptCallMediaOperation;
        return this;
    }

    public Boolean isStopCurrentOperations() {
        return this.stopCurrentOperations;
    }

    public CallMediaRecognizeOptions setStopCurrentOperations(Boolean stopCurrentOperations) {
        this.stopCurrentOperations = stopCurrentOperations;
        return this;
    }

    public String getOperationContext() {
        return this.operationContext;
    }

    public CallMediaRecognizeOptions setOperationContext(String operationContext) {
        this.operationContext = operationContext;
        return this;
    }

    public Boolean isInterruptPrompt() {
        return this.interruptPrompt;
    }

    public CallMediaRecognizeOptions setInterruptPrompt(Boolean interruptPrompt) {
        this.interruptPrompt = interruptPrompt;
        return this;
    }

    public Duration getInitialSilenceTimeout() {
        return this.initialSilenceTimeout;
    }

    public CallMediaRecognizeOptions setInitialSilenceTimeout(Duration initialSilenceTimeout) {
        this.initialSilenceTimeout = initialSilenceTimeout;
        return this;
    }

    public CommunicationIdentifier getTargetParticipant() {
        return this.targetParticipant;
    }

    public String getOperationCallbackUrl() {
        return this.operationCallbackUrl;
    }

    public CallMediaRecognizeOptions setOperationCallbackUrl(String operationCallbackUrl) {
        this.operationCallbackUrl = operationCallbackUrl;
        return this;
    }

    public static CallMediaRecognizeOptions fromJson(JsonReader jsonReader) throws IOException {
        return (CallMediaRecognizeOptions)jsonReader.readObject(reader -> {
            String recognizeInputType = null;
            JsonReader reader1 = reader.bufferObject();
            reader1.nextToken();
            while (reader1.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader1.getFieldName();
                reader1.nextToken();
                if ("recognizeInputType".equals(fieldName)) {
                    recognizeInputType = reader1.getString();
                    continue;
                }
                reader1.skipChildren();
            }
            CallMediaRecognizeOptions options = null;
            if ("dtmf".equals(recognizeInputType)) {
                options = CallMediaRecognizeDtmfOptions.fromJson(reader1.reset());
            } else if ("choices".equals(recognizeInputType)) {
                options = CallMediaRecognizeChoiceOptions.fromJson(reader1.reset());
            } else if ("speech".equals(recognizeInputType)) {
                options = CallMediaRecognizeSpeechOptions.fromJson(reader1.reset());
            } else if ("speechordtmf".equals(recognizeInputType)) {
                options = CallMediaRecognizeSpeechOrDtmfOptions.fromJson(reader1.reset());
            }
            return options;
        });
    }
}

