/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.models;

import com.azure.communication.callautomation.implementation.converters.CommunicationIdentifierConverter;
import com.azure.communication.callautomation.implementation.models.CommunicationIdentifierModel;
import com.azure.communication.callautomation.models.CallMediaRecognizeOptions;
import com.azure.communication.callautomation.models.DtmfTone;
import com.azure.communication.callautomation.models.PlaySource;
import com.azure.communication.callautomation.models.RecognizeInputType;
import com.azure.communication.common.CommunicationIdentifier;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;
import java.util.List;

public final class CallMediaRecognizeDtmfOptions
extends CallMediaRecognizeOptions {
    private Duration interToneTimeout = Duration.ofSeconds(2L);
    private Integer maxTonesToCollect;
    private List<DtmfTone> stopDtmfTones;

    public Duration getInterToneTimeout() {
        return this.interToneTimeout;
    }

    public CallMediaRecognizeDtmfOptions setInterToneTimeout(Duration interToneTimeout) {
        this.interToneTimeout = interToneTimeout;
        return this;
    }

    public Integer getMaxTonesToCollect() {
        return this.maxTonesToCollect;
    }

    public List<DtmfTone> getStopTones() {
        return this.stopDtmfTones;
    }

    public CallMediaRecognizeDtmfOptions setStopTones(List<DtmfTone> stopDtmfTones) {
        this.stopDtmfTones = stopDtmfTones;
        return this;
    }

    @Override
    public CallMediaRecognizeDtmfOptions setRecognizeInputType(RecognizeInputType recognizeInputType) {
        super.setRecognizeInputType(recognizeInputType);
        return this;
    }

    @Override
    public CallMediaRecognizeDtmfOptions setPlayPrompt(PlaySource playPrompt) {
        super.setPlayPrompt(playPrompt);
        return this;
    }

    @Override
    public CallMediaRecognizeDtmfOptions setInterruptCallMediaOperation(Boolean interruptCallMediaOperation) {
        super.setInterruptCallMediaOperation(interruptCallMediaOperation);
        return this;
    }

    @Override
    public CallMediaRecognizeDtmfOptions setStopCurrentOperations(Boolean stopCurrentOperations) {
        super.setStopCurrentOperations(stopCurrentOperations);
        return this;
    }

    @Override
    public CallMediaRecognizeDtmfOptions setOperationContext(String operationContext) {
        super.setOperationContext(operationContext);
        return this;
    }

    @Override
    public CallMediaRecognizeDtmfOptions setInterruptPrompt(Boolean interruptPrompt) {
        super.setInterruptPrompt(interruptPrompt);
        return this;
    }

    @Override
    public CallMediaRecognizeDtmfOptions setInitialSilenceTimeout(Duration initialSilenceTimeout) {
        super.setInitialSilenceTimeout(initialSilenceTimeout);
        return this;
    }

    public CallMediaRecognizeDtmfOptions(CommunicationIdentifier targetParticipant, int maxTonesToCollect) {
        super(RecognizeInputType.DTMF, targetParticipant);
        this.maxTonesToCollect = maxTonesToCollect;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("recognizeInputType", "dtmf");
        jsonWriter.writeJsonField("playPrompt", (JsonSerializable)this.getPlayPrompt());
        jsonWriter.writeArrayField("playPrompts", this.getPlayPrompts(), (writer, playPrompt) -> playPrompt.toJson(writer));
        jsonWriter.writeBooleanField("interruptCallMediaOperation", this.isInterruptCallMediaOperation());
        jsonWriter.writeBooleanField("stopCurrentOperations", this.isStopCurrentOperations());
        jsonWriter.writeStringField("operationContext", this.getOperationContext());
        jsonWriter.writeBooleanField("interruptPrompt", this.isInterruptPrompt());
        jsonWriter.writeStringField("initialSilenceTimeout", CoreUtils.durationToStringWithDays((Duration)this.getInitialSilenceTimeout()));
        CommunicationIdentifierModel participant = CommunicationIdentifierConverter.convert(this.getTargetParticipant());
        jsonWriter.writeJsonField("targetParticipant", (JsonSerializable)participant);
        jsonWriter.writeStringField("operationCallbackUrl", this.getOperationCallbackUrl());
        jsonWriter.writeStringField("interToneTimeout", CoreUtils.durationToStringWithDays((Duration)this.interToneTimeout));
        if (this.maxTonesToCollect != null) {
            jsonWriter.writeNumberField("maxTonesToCollect", (Number)this.maxTonesToCollect);
        }
        jsonWriter.writeArrayField("stopTones", this.stopDtmfTones, (writer, element) -> writer.writeString(element.toString()));
        return jsonWriter.writeEndObject();
    }

    public static CallMediaRecognizeDtmfOptions fromJson(JsonReader jsonReader) throws IOException {
        return (CallMediaRecognizeDtmfOptions)jsonReader.readObject(reader -> {
            Duration interToneTimeout = null;
            int maxTonesToCollect = 0;
            List stopDtmfTones = null;
            String recognizeInputType = null;
            Boolean interruptCallMediaOperation = null;
            Boolean stopCurrentOperations = null;
            String operationContext = null;
            Boolean interruptPrompt = null;
            Duration initialSilenceTimeout = null;
            String operationCallbackUrl = null;
            CommunicationIdentifier targetParticipant = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                Object value;
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("interToneTimeout".equals(fieldName)) {
                    value = reader.getString();
                    interToneTimeout = value != null ? Duration.parse((CharSequence)value) : null;
                    continue;
                }
                if ("maxTonesToCollect".equals(fieldName)) {
                    value = (Integer)reader.getNullable(JsonReader::getInt);
                    maxTonesToCollect = value != null ? (Integer)value : 0;
                    continue;
                }
                if ("stopTones".equals(fieldName)) {
                    stopDtmfTones = reader.readArray(r -> DtmfTone.fromString(r.getString()));
                    continue;
                }
                if ("recognizeInputType".equals(fieldName)) {
                    recognizeInputType = reader.getString();
                    continue;
                }
                if ("interruptCallMediaOperation".equals(fieldName)) {
                    interruptCallMediaOperation = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("stopCurrentOperations".equals(fieldName)) {
                    stopCurrentOperations = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("operationContext".equals(fieldName)) {
                    operationContext = reader.getString();
                    continue;
                }
                if ("interruptPrompt".equals(fieldName)) {
                    interruptPrompt = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("initialSilenceTimeout".equals(fieldName)) {
                    value = reader.getString();
                    initialSilenceTimeout = value != null ? Duration.parse((CharSequence)value) : null;
                    continue;
                }
                if ("operationCallbackUrl".equals(fieldName)) {
                    operationCallbackUrl = reader.getString();
                    continue;
                }
                if ("targetParticipant".equals(fieldName)) {
                    CommunicationIdentifierModel inner = CommunicationIdentifierModel.fromJson(reader);
                    targetParticipant = CommunicationIdentifierConverter.convert(inner);
                    continue;
                }
                reader.skipChildren();
            }
            CallMediaRecognizeDtmfOptions options = new CallMediaRecognizeDtmfOptions(targetParticipant, maxTonesToCollect);
            options.interToneTimeout = interToneTimeout;
            options.stopDtmfTones = stopDtmfTones;
            options.setRecognizeInputType(RecognizeInputType.fromString(recognizeInputType));
            options.setInterruptCallMediaOperation(interruptCallMediaOperation);
            options.setStopCurrentOperations(stopCurrentOperations);
            options.setOperationContext(operationContext);
            options.setInterruptPrompt(interruptPrompt);
            options.setInitialSilenceTimeout(initialSilenceTimeout);
            options.setOperationCallbackUrl(operationCallbackUrl);
            return options;
        });
    }
}

