/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.implementation.models;

import com.azure.communication.callautomation.implementation.models.AudioFormatInternal;
import com.azure.communication.callautomation.implementation.models.MediaStreamingAudioChannelTypeInternal;
import com.azure.communication.callautomation.implementation.models.MediaStreamingContentTypeInternal;
import com.azure.communication.callautomation.implementation.models.MediaStreamingOptionsInternal;
import com.azure.communication.callautomation.implementation.models.StreamingTransportTypeInternal;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class WebSocketMediaStreamingOptionsInternal
extends MediaStreamingOptionsInternal {
    private StreamingTransportTypeInternal transportType = StreamingTransportTypeInternal.WEBSOCKET;
    private String transportUrl;
    private MediaStreamingContentTypeInternal contentType;
    private Boolean startMediaStreaming;
    private Boolean enableBidirectional;
    private AudioFormatInternal audioFormat;
    private Boolean enableDtmfTones;

    @Override
    public StreamingTransportTypeInternal getTransportType() {
        return this.transportType;
    }

    public String getTransportUrl() {
        return this.transportUrl;
    }

    public WebSocketMediaStreamingOptionsInternal setTransportUrl(String transportUrl) {
        this.transportUrl = transportUrl;
        return this;
    }

    public MediaStreamingContentTypeInternal getContentType() {
        return this.contentType;
    }

    public WebSocketMediaStreamingOptionsInternal setContentType(MediaStreamingContentTypeInternal contentType) {
        this.contentType = contentType;
        return this;
    }

    public Boolean isStartMediaStreaming() {
        return this.startMediaStreaming;
    }

    public WebSocketMediaStreamingOptionsInternal setStartMediaStreaming(Boolean startMediaStreaming) {
        this.startMediaStreaming = startMediaStreaming;
        return this;
    }

    public Boolean isEnableBidirectional() {
        return this.enableBidirectional;
    }

    public WebSocketMediaStreamingOptionsInternal setEnableBidirectional(Boolean enableBidirectional) {
        this.enableBidirectional = enableBidirectional;
        return this;
    }

    public AudioFormatInternal getAudioFormat() {
        return this.audioFormat;
    }

    public WebSocketMediaStreamingOptionsInternal setAudioFormat(AudioFormatInternal audioFormat) {
        this.audioFormat = audioFormat;
        return this;
    }

    public Boolean isEnableDtmfTones() {
        return this.enableDtmfTones;
    }

    public WebSocketMediaStreamingOptionsInternal setEnableDtmfTones(Boolean enableDtmfTones) {
        this.enableDtmfTones = enableDtmfTones;
        return this;
    }

    @Override
    public WebSocketMediaStreamingOptionsInternal setAudioChannelType(MediaStreamingAudioChannelTypeInternal audioChannelType) {
        super.setAudioChannelType(audioChannelType);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("audioChannelType", this.getAudioChannelType() == null ? null : this.getAudioChannelType().toString());
        jsonWriter.writeStringField("transportType", this.transportType == null ? null : this.transportType.toString());
        jsonWriter.writeStringField("transportUrl", this.transportUrl);
        jsonWriter.writeStringField("contentType", this.contentType == null ? null : this.contentType.toString());
        jsonWriter.writeBooleanField("startMediaStreaming", this.startMediaStreaming);
        jsonWriter.writeBooleanField("enableBidirectional", this.enableBidirectional);
        jsonWriter.writeStringField("audioFormat", this.audioFormat == null ? null : this.audioFormat.toString());
        jsonWriter.writeBooleanField("enableDtmfTones", this.enableDtmfTones);
        return jsonWriter.writeEndObject();
    }

    public static WebSocketMediaStreamingOptionsInternal fromJson(JsonReader jsonReader) throws IOException {
        return (WebSocketMediaStreamingOptionsInternal)jsonReader.readObject(reader -> {
            WebSocketMediaStreamingOptionsInternal deserializedWebSocketMediaStreamingOptionsInternal = new WebSocketMediaStreamingOptionsInternal();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("audioChannelType".equals(fieldName)) {
                    deserializedWebSocketMediaStreamingOptionsInternal.setAudioChannelType(MediaStreamingAudioChannelTypeInternal.fromString(reader.getString()));
                    continue;
                }
                if ("transportType".equals(fieldName)) {
                    deserializedWebSocketMediaStreamingOptionsInternal.transportType = StreamingTransportTypeInternal.fromString(reader.getString());
                    continue;
                }
                if ("transportUrl".equals(fieldName)) {
                    deserializedWebSocketMediaStreamingOptionsInternal.transportUrl = reader.getString();
                    continue;
                }
                if ("contentType".equals(fieldName)) {
                    deserializedWebSocketMediaStreamingOptionsInternal.contentType = MediaStreamingContentTypeInternal.fromString(reader.getString());
                    continue;
                }
                if ("startMediaStreaming".equals(fieldName)) {
                    deserializedWebSocketMediaStreamingOptionsInternal.startMediaStreaming = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enableBidirectional".equals(fieldName)) {
                    deserializedWebSocketMediaStreamingOptionsInternal.enableBidirectional = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("audioFormat".equals(fieldName)) {
                    deserializedWebSocketMediaStreamingOptionsInternal.audioFormat = AudioFormatInternal.fromString(reader.getString());
                    continue;
                }
                if ("enableDtmfTones".equals(fieldName)) {
                    deserializedWebSocketMediaStreamingOptionsInternal.enableDtmfTones = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWebSocketMediaStreamingOptionsInternal;
        });
    }
}

