/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.implementation.models;

import com.azure.communication.callautomation.implementation.models.CommunicationIdentifierModel;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class UnholdRequest
implements JsonSerializable<UnholdRequest> {
    private CommunicationIdentifierModel targetParticipant;
    private String operationContext;
    private String operationCallbackUri;

    public CommunicationIdentifierModel getTargetParticipant() {
        return this.targetParticipant;
    }

    public UnholdRequest setTargetParticipant(CommunicationIdentifierModel targetParticipant) {
        this.targetParticipant = targetParticipant;
        return this;
    }

    public String getOperationContext() {
        return this.operationContext;
    }

    public UnholdRequest setOperationContext(String operationContext) {
        this.operationContext = operationContext;
        return this;
    }

    public String getOperationCallbackUri() {
        return this.operationCallbackUri;
    }

    public UnholdRequest setOperationCallbackUri(String operationCallbackUri) {
        this.operationCallbackUri = operationCallbackUri;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("targetParticipant", (JsonSerializable)this.targetParticipant);
        jsonWriter.writeStringField("operationContext", this.operationContext);
        jsonWriter.writeStringField("operationCallbackUri", this.operationCallbackUri);
        return jsonWriter.writeEndObject();
    }

    public static UnholdRequest fromJson(JsonReader jsonReader) throws IOException {
        return (UnholdRequest)jsonReader.readObject(reader -> {
            UnholdRequest deserializedUnholdRequest = new UnholdRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("targetParticipant".equals(fieldName)) {
                    deserializedUnholdRequest.targetParticipant = CommunicationIdentifierModel.fromJson(reader);
                    continue;
                }
                if ("operationContext".equals(fieldName)) {
                    deserializedUnholdRequest.operationContext = reader.getString();
                    continue;
                }
                if ("operationCallbackUri".equals(fieldName)) {
                    deserializedUnholdRequest.operationCallbackUri = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUnholdRequest;
        });
    }
}

