/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.implementation.models;

import com.azure.communication.callautomation.implementation.models.CallSessionEndReason;
import com.azure.communication.callautomation.implementation.models.Error;
import com.azure.communication.callautomation.implementation.models.RecordingStorageInfo;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class RecordingResultResponse
implements JsonSerializable<RecordingResultResponse> {
    private String recordingId;
    private RecordingStorageInfo recordingStorageInfo;
    private List<Error> errors;
    private OffsetDateTime recordingStartTime;
    private Long recordingDurationMs;
    private CallSessionEndReason sessionEndReason;
    private OffsetDateTime recordingExpirationTime;

    public String getRecordingId() {
        return this.recordingId;
    }

    public RecordingStorageInfo getRecordingStorageInfo() {
        return this.recordingStorageInfo;
    }

    public List<Error> getErrors() {
        return this.errors;
    }

    public OffsetDateTime getRecordingStartTime() {
        return this.recordingStartTime;
    }

    public Long getRecordingDurationMs() {
        return this.recordingDurationMs;
    }

    public CallSessionEndReason getSessionEndReason() {
        return this.sessionEndReason;
    }

    public OffsetDateTime getRecordingExpirationTime() {
        return this.recordingExpirationTime;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static RecordingResultResponse fromJson(JsonReader jsonReader) throws IOException {
        return (RecordingResultResponse)jsonReader.readObject(reader -> {
            RecordingResultResponse deserializedRecordingResultResponse = new RecordingResultResponse();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("recordingId".equals(fieldName)) {
                    deserializedRecordingResultResponse.recordingId = reader.getString();
                    continue;
                }
                if ("recordingStorageInfo".equals(fieldName)) {
                    deserializedRecordingResultResponse.recordingStorageInfo = RecordingStorageInfo.fromJson(reader);
                    continue;
                }
                if ("errors".equals(fieldName)) {
                    List errors;
                    deserializedRecordingResultResponse.errors = errors = reader.readArray(reader1 -> Error.fromJson(reader1));
                    continue;
                }
                if ("recordingStartTime".equals(fieldName)) {
                    deserializedRecordingResultResponse.recordingStartTime = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    continue;
                }
                if ("recordingDurationMs".equals(fieldName)) {
                    deserializedRecordingResultResponse.recordingDurationMs = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("sessionEndReason".equals(fieldName)) {
                    deserializedRecordingResultResponse.sessionEndReason = CallSessionEndReason.fromString(reader.getString());
                    continue;
                }
                if ("recordingExpirationTime".equals(fieldName)) {
                    deserializedRecordingResultResponse.recordingExpirationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRecordingResultResponse;
        });
    }
}

