/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.implementation.models;

import com.azure.communication.callautomation.implementation.models.ChunkEndReason;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class RecordingChunkStorageInfo
implements JsonSerializable<RecordingChunkStorageInfo> {
    private String documentId;
    private Integer index;
    private ChunkEndReason endReason;
    private String contentLocation;
    private String metadataLocation;
    private String deleteLocation;

    public String getDocumentId() {
        return this.documentId;
    }

    public RecordingChunkStorageInfo setDocumentId(String documentId) {
        this.documentId = documentId;
        return this;
    }

    public Integer getIndex() {
        return this.index;
    }

    public RecordingChunkStorageInfo setIndex(Integer index) {
        this.index = index;
        return this;
    }

    public ChunkEndReason getEndReason() {
        return this.endReason;
    }

    public RecordingChunkStorageInfo setEndReason(ChunkEndReason endReason) {
        this.endReason = endReason;
        return this;
    }

    public String getContentLocation() {
        return this.contentLocation;
    }

    public RecordingChunkStorageInfo setContentLocation(String contentLocation) {
        this.contentLocation = contentLocation;
        return this;
    }

    public String getMetadataLocation() {
        return this.metadataLocation;
    }

    public RecordingChunkStorageInfo setMetadataLocation(String metadataLocation) {
        this.metadataLocation = metadataLocation;
        return this;
    }

    public String getDeleteLocation() {
        return this.deleteLocation;
    }

    public RecordingChunkStorageInfo setDeleteLocation(String deleteLocation) {
        this.deleteLocation = deleteLocation;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("documentId", this.documentId);
        jsonWriter.writeNumberField("index", (Number)this.index);
        jsonWriter.writeStringField("endReason", this.endReason == null ? null : this.endReason.toString());
        jsonWriter.writeStringField("contentLocation", this.contentLocation);
        jsonWriter.writeStringField("metadataLocation", this.metadataLocation);
        jsonWriter.writeStringField("deleteLocation", this.deleteLocation);
        return jsonWriter.writeEndObject();
    }

    public static RecordingChunkStorageInfo fromJson(JsonReader jsonReader) throws IOException {
        return (RecordingChunkStorageInfo)jsonReader.readObject(reader -> {
            RecordingChunkStorageInfo deserializedRecordingChunkStorageInfo = new RecordingChunkStorageInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("documentId".equals(fieldName)) {
                    deserializedRecordingChunkStorageInfo.documentId = reader.getString();
                    continue;
                }
                if ("index".equals(fieldName)) {
                    deserializedRecordingChunkStorageInfo.index = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("endReason".equals(fieldName)) {
                    deserializedRecordingChunkStorageInfo.endReason = ChunkEndReason.fromString(reader.getString());
                    continue;
                }
                if ("contentLocation".equals(fieldName)) {
                    deserializedRecordingChunkStorageInfo.contentLocation = reader.getString();
                    continue;
                }
                if ("metadataLocation".equals(fieldName)) {
                    deserializedRecordingChunkStorageInfo.metadataLocation = reader.getString();
                    continue;
                }
                if ("deleteLocation".equals(fieldName)) {
                    deserializedRecordingChunkStorageInfo.deleteLocation = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRecordingChunkStorageInfo;
        });
    }
}

