/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.implementation.models;

import com.azure.communication.callautomation.implementation.models.MediaStreamingStatus;
import com.azure.communication.callautomation.implementation.models.MediaStreamingStatusDetails;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class MediaStreamingUpdate
implements JsonSerializable<MediaStreamingUpdate> {
    private String contentType;
    private MediaStreamingStatus mediaStreamingStatus;
    private MediaStreamingStatusDetails mediaStreamingStatusDetails;

    public String getContentType() {
        return this.contentType;
    }

    public MediaStreamingUpdate setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public MediaStreamingStatus getMediaStreamingStatus() {
        return this.mediaStreamingStatus;
    }

    public MediaStreamingUpdate setMediaStreamingStatus(MediaStreamingStatus mediaStreamingStatus) {
        this.mediaStreamingStatus = mediaStreamingStatus;
        return this;
    }

    public MediaStreamingStatusDetails getMediaStreamingStatusDetails() {
        return this.mediaStreamingStatusDetails;
    }

    public MediaStreamingUpdate setMediaStreamingStatusDetails(MediaStreamingStatusDetails mediaStreamingStatusDetails) {
        this.mediaStreamingStatusDetails = mediaStreamingStatusDetails;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("contentType", this.contentType);
        jsonWriter.writeStringField("mediaStreamingStatus", this.mediaStreamingStatus == null ? null : this.mediaStreamingStatus.toString());
        jsonWriter.writeStringField("mediaStreamingStatusDetails", this.mediaStreamingStatusDetails == null ? null : this.mediaStreamingStatusDetails.toString());
        return jsonWriter.writeEndObject();
    }

    public static MediaStreamingUpdate fromJson(JsonReader jsonReader) throws IOException {
        return (MediaStreamingUpdate)jsonReader.readObject(reader -> {
            MediaStreamingUpdate deserializedMediaStreamingUpdate = new MediaStreamingUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("contentType".equals(fieldName)) {
                    deserializedMediaStreamingUpdate.contentType = reader.getString();
                    continue;
                }
                if ("mediaStreamingStatus".equals(fieldName)) {
                    deserializedMediaStreamingUpdate.mediaStreamingStatus = MediaStreamingStatus.fromString(reader.getString());
                    continue;
                }
                if ("mediaStreamingStatusDetails".equals(fieldName)) {
                    deserializedMediaStreamingUpdate.mediaStreamingStatusDetails = MediaStreamingStatusDetails.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMediaStreamingUpdate;
        });
    }
}

