/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.implementation.eventprocessor;

import com.azure.communication.callautomation.implementation.eventprocessor.EventWithBacklogId;
import com.azure.communication.callautomation.models.events.CallAutomationEventBase;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;

public final class EventBacklog {
    private static final long DEFAULT_BACKLOG_EVENT_TIMEOUT_SECONDS = 5L;
    private static final int MAXIMUM_EVENTBACKLOGS_AT_ONCE = 10000;
    private final long expiringTimeout;
    private final ConcurrentHashMap<String, CallAutomationEventBase> eventBacklog;

    public EventBacklog() {
        this(5L);
    }

    public EventBacklog(long expiringTimeout) {
        this.expiringTimeout = expiringTimeout;
        this.eventBacklog = new ConcurrentHashMap();
    }

    public EventWithBacklogId addEvent(final String backlogEventId, CallAutomationEventBase eventToBeSaved) {
        if (this.eventBacklog.size() >= 10000) {
            return null;
        }
        this.eventBacklog.put(backlogEventId, eventToBeSaved);
        new Timer().schedule(new TimerTask(this){
            final /* synthetic */ EventBacklog this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.eventBacklog.remove(backlogEventId);
            }
        }, this.expiringTimeout * 1000L);
        return new EventWithBacklogId(backlogEventId, eventToBeSaved);
    }

    public EventWithBacklogId tryGetAndRemoveMatchedEvent(Predicate<CallAutomationEventBase> predicate) {
        Map.Entry searchResult = this.eventBacklog.searchEntries(1L, entry -> predicate.test((CallAutomationEventBase)entry.getValue()) ? entry : null);
        if (searchResult != null && this.eventBacklog.remove(searchResult.getKey(), searchResult.getValue())) {
            return new EventWithBacklogId((String)searchResult.getKey(), (CallAutomationEventBase)searchResult.getValue());
        }
        return null;
    }

    public EventWithBacklogId removeEvent(String backlogEventId) {
        return backlogEventId != null ? new EventWithBacklogId(backlogEventId, this.eventBacklog.remove(backlogEventId)) : null;
    }
}

