/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.implementation;

import com.azure.communication.callautomation.implementation.AzureCommunicationCallAutomationServiceImpl;
import com.azure.communication.callautomation.implementation.models.CommunicationErrorResponseException;
import com.azure.communication.callautomation.implementation.models.ContinuousDtmfRecognitionRequestInternal;
import com.azure.communication.callautomation.implementation.models.HoldRequest;
import com.azure.communication.callautomation.implementation.models.PlayRequest;
import com.azure.communication.callautomation.implementation.models.RecognizeRequest;
import com.azure.communication.callautomation.implementation.models.SendDtmfTonesRequestInternal;
import com.azure.communication.callautomation.implementation.models.SendDtmfTonesResultInternal;
import com.azure.communication.callautomation.implementation.models.StartMediaStreamingRequest;
import com.azure.communication.callautomation.implementation.models.StartTranscriptionRequestInternal;
import com.azure.communication.callautomation.implementation.models.StopMediaStreamingRequest;
import com.azure.communication.callautomation.implementation.models.StopTranscriptionRequestInternal;
import com.azure.communication.callautomation.implementation.models.UnholdRequest;
import com.azure.communication.callautomation.implementation.models.UpdateTranscriptionRequestInternal;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import java.time.OffsetDateTime;
import reactor.core.publisher.Mono;

public final class CallMediasImpl {
    private final CallMediasService service;
    private final AzureCommunicationCallAutomationServiceImpl client;

    CallMediasImpl(AzureCommunicationCallAutomationServiceImpl client) {
        this.service = (CallMediasService)RestProxy.create(CallMediasService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> playWithResponseAsync(String callConnectionId, PlayRequest playRequest) {
        return FluxUtil.withContext(context -> this.playWithResponseAsync(callConnectionId, playRequest, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> playWithResponseAsync(String callConnectionId, PlayRequest playRequest, Context context) {
        String accept = "application/json";
        return this.service.play(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), playRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> playAsync(String callConnectionId, PlayRequest playRequest) {
        return this.playWithResponseAsync(callConnectionId, playRequest).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> playAsync(String callConnectionId, PlayRequest playRequest, Context context) {
        return this.playWithResponseAsync(callConnectionId, playRequest, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> playWithResponse(String callConnectionId, PlayRequest playRequest, Context context) {
        return (Response)this.playWithResponseAsync(callConnectionId, playRequest, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void play(String callConnectionId, PlayRequest playRequest) {
        this.playWithResponse(callConnectionId, playRequest, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> startTranscriptionWithResponseAsync(String callConnectionId, StartTranscriptionRequestInternal startTranscriptionRequest) {
        return FluxUtil.withContext(context -> this.startTranscriptionWithResponseAsync(callConnectionId, startTranscriptionRequest, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> startTranscriptionWithResponseAsync(String callConnectionId, StartTranscriptionRequestInternal startTranscriptionRequest, Context context) {
        String accept = "application/json";
        return this.service.startTranscription(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), startTranscriptionRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> startTranscriptionAsync(String callConnectionId, StartTranscriptionRequestInternal startTranscriptionRequest) {
        return this.startTranscriptionWithResponseAsync(callConnectionId, startTranscriptionRequest).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> startTranscriptionAsync(String callConnectionId, StartTranscriptionRequestInternal startTranscriptionRequest, Context context) {
        return this.startTranscriptionWithResponseAsync(callConnectionId, startTranscriptionRequest, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> startTranscriptionWithResponse(String callConnectionId, StartTranscriptionRequestInternal startTranscriptionRequest, Context context) {
        return (Response)this.startTranscriptionWithResponseAsync(callConnectionId, startTranscriptionRequest, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void startTranscription(String callConnectionId, StartTranscriptionRequestInternal startTranscriptionRequest) {
        this.startTranscriptionWithResponse(callConnectionId, startTranscriptionRequest, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> stopTranscriptionWithResponseAsync(String callConnectionId, StopTranscriptionRequestInternal stopTranscriptionRequest) {
        return FluxUtil.withContext(context -> this.stopTranscriptionWithResponseAsync(callConnectionId, stopTranscriptionRequest, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> stopTranscriptionWithResponseAsync(String callConnectionId, StopTranscriptionRequestInternal stopTranscriptionRequest, Context context) {
        String accept = "application/json";
        return this.service.stopTranscription(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), stopTranscriptionRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> stopTranscriptionAsync(String callConnectionId, StopTranscriptionRequestInternal stopTranscriptionRequest) {
        return this.stopTranscriptionWithResponseAsync(callConnectionId, stopTranscriptionRequest).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> stopTranscriptionAsync(String callConnectionId, StopTranscriptionRequestInternal stopTranscriptionRequest, Context context) {
        return this.stopTranscriptionWithResponseAsync(callConnectionId, stopTranscriptionRequest, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> stopTranscriptionWithResponse(String callConnectionId, StopTranscriptionRequestInternal stopTranscriptionRequest, Context context) {
        return (Response)this.stopTranscriptionWithResponseAsync(callConnectionId, stopTranscriptionRequest, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void stopTranscription(String callConnectionId, StopTranscriptionRequestInternal stopTranscriptionRequest) {
        this.stopTranscriptionWithResponse(callConnectionId, stopTranscriptionRequest, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> updateTranscriptionWithResponseAsync(String callConnectionId, UpdateTranscriptionRequestInternal updateTranscriptionRequest) {
        return FluxUtil.withContext(context -> this.updateTranscriptionWithResponseAsync(callConnectionId, updateTranscriptionRequest, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> updateTranscriptionWithResponseAsync(String callConnectionId, UpdateTranscriptionRequestInternal updateTranscriptionRequest, Context context) {
        String accept = "application/json";
        return this.service.updateTranscription(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), updateTranscriptionRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updateTranscriptionAsync(String callConnectionId, UpdateTranscriptionRequestInternal updateTranscriptionRequest) {
        return this.updateTranscriptionWithResponseAsync(callConnectionId, updateTranscriptionRequest).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updateTranscriptionAsync(String callConnectionId, UpdateTranscriptionRequestInternal updateTranscriptionRequest, Context context) {
        return this.updateTranscriptionWithResponseAsync(callConnectionId, updateTranscriptionRequest, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updateTranscriptionWithResponse(String callConnectionId, UpdateTranscriptionRequestInternal updateTranscriptionRequest, Context context) {
        return (Response)this.updateTranscriptionWithResponseAsync(callConnectionId, updateTranscriptionRequest, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updateTranscription(String callConnectionId, UpdateTranscriptionRequestInternal updateTranscriptionRequest) {
        this.updateTranscriptionWithResponse(callConnectionId, updateTranscriptionRequest, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> cancelAllMediaOperationsWithResponseAsync(String callConnectionId) {
        return FluxUtil.withContext(context -> this.cancelAllMediaOperationsWithResponseAsync(callConnectionId, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> cancelAllMediaOperationsWithResponseAsync(String callConnectionId, Context context) {
        String accept = "application/json";
        return this.service.cancelAllMediaOperations(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> cancelAllMediaOperationsAsync(String callConnectionId) {
        return this.cancelAllMediaOperationsWithResponseAsync(callConnectionId).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> cancelAllMediaOperationsAsync(String callConnectionId, Context context) {
        return this.cancelAllMediaOperationsWithResponseAsync(callConnectionId, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> cancelAllMediaOperationsWithResponse(String callConnectionId, Context context) {
        return (Response)this.cancelAllMediaOperationsWithResponseAsync(callConnectionId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void cancelAllMediaOperations(String callConnectionId) {
        this.cancelAllMediaOperationsWithResponse(callConnectionId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> recognizeWithResponseAsync(String callConnectionId, RecognizeRequest recognizeRequest) {
        return FluxUtil.withContext(context -> this.recognizeWithResponseAsync(callConnectionId, recognizeRequest, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> recognizeWithResponseAsync(String callConnectionId, RecognizeRequest recognizeRequest, Context context) {
        String accept = "application/json";
        return this.service.recognize(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), recognizeRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> recognizeAsync(String callConnectionId, RecognizeRequest recognizeRequest) {
        return this.recognizeWithResponseAsync(callConnectionId, recognizeRequest).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> recognizeAsync(String callConnectionId, RecognizeRequest recognizeRequest, Context context) {
        return this.recognizeWithResponseAsync(callConnectionId, recognizeRequest, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> recognizeWithResponse(String callConnectionId, RecognizeRequest recognizeRequest, Context context) {
        return (Response)this.recognizeWithResponseAsync(callConnectionId, recognizeRequest, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void recognize(String callConnectionId, RecognizeRequest recognizeRequest) {
        this.recognizeWithResponse(callConnectionId, recognizeRequest, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> startContinuousDtmfRecognitionWithResponseAsync(String callConnectionId, ContinuousDtmfRecognitionRequestInternal continuousDtmfRecognitionRequest) {
        return FluxUtil.withContext(context -> this.startContinuousDtmfRecognitionWithResponseAsync(callConnectionId, continuousDtmfRecognitionRequest, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> startContinuousDtmfRecognitionWithResponseAsync(String callConnectionId, ContinuousDtmfRecognitionRequestInternal continuousDtmfRecognitionRequest, Context context) {
        String accept = "application/json";
        return this.service.startContinuousDtmfRecognition(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), continuousDtmfRecognitionRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> startContinuousDtmfRecognitionAsync(String callConnectionId, ContinuousDtmfRecognitionRequestInternal continuousDtmfRecognitionRequest) {
        return this.startContinuousDtmfRecognitionWithResponseAsync(callConnectionId, continuousDtmfRecognitionRequest).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> startContinuousDtmfRecognitionAsync(String callConnectionId, ContinuousDtmfRecognitionRequestInternal continuousDtmfRecognitionRequest, Context context) {
        return this.startContinuousDtmfRecognitionWithResponseAsync(callConnectionId, continuousDtmfRecognitionRequest, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> startContinuousDtmfRecognitionWithResponse(String callConnectionId, ContinuousDtmfRecognitionRequestInternal continuousDtmfRecognitionRequest, Context context) {
        return (Response)this.startContinuousDtmfRecognitionWithResponseAsync(callConnectionId, continuousDtmfRecognitionRequest, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void startContinuousDtmfRecognition(String callConnectionId, ContinuousDtmfRecognitionRequestInternal continuousDtmfRecognitionRequest) {
        this.startContinuousDtmfRecognitionWithResponse(callConnectionId, continuousDtmfRecognitionRequest, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> stopContinuousDtmfRecognitionWithResponseAsync(String callConnectionId, ContinuousDtmfRecognitionRequestInternal continuousDtmfRecognitionRequest) {
        return FluxUtil.withContext(context -> this.stopContinuousDtmfRecognitionWithResponseAsync(callConnectionId, continuousDtmfRecognitionRequest, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> stopContinuousDtmfRecognitionWithResponseAsync(String callConnectionId, ContinuousDtmfRecognitionRequestInternal continuousDtmfRecognitionRequest, Context context) {
        String accept = "application/json";
        return this.service.stopContinuousDtmfRecognition(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), continuousDtmfRecognitionRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> stopContinuousDtmfRecognitionAsync(String callConnectionId, ContinuousDtmfRecognitionRequestInternal continuousDtmfRecognitionRequest) {
        return this.stopContinuousDtmfRecognitionWithResponseAsync(callConnectionId, continuousDtmfRecognitionRequest).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> stopContinuousDtmfRecognitionAsync(String callConnectionId, ContinuousDtmfRecognitionRequestInternal continuousDtmfRecognitionRequest, Context context) {
        return this.stopContinuousDtmfRecognitionWithResponseAsync(callConnectionId, continuousDtmfRecognitionRequest, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> stopContinuousDtmfRecognitionWithResponse(String callConnectionId, ContinuousDtmfRecognitionRequestInternal continuousDtmfRecognitionRequest, Context context) {
        return (Response)this.stopContinuousDtmfRecognitionWithResponseAsync(callConnectionId, continuousDtmfRecognitionRequest, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void stopContinuousDtmfRecognition(String callConnectionId, ContinuousDtmfRecognitionRequestInternal continuousDtmfRecognitionRequest) {
        this.stopContinuousDtmfRecognitionWithResponse(callConnectionId, continuousDtmfRecognitionRequest, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SendDtmfTonesResultInternal>> sendDtmfTonesWithResponseAsync(String callConnectionId, SendDtmfTonesRequestInternal sendDtmfTonesRequest) {
        return FluxUtil.withContext(context -> this.sendDtmfTonesWithResponseAsync(callConnectionId, sendDtmfTonesRequest, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SendDtmfTonesResultInternal>> sendDtmfTonesWithResponseAsync(String callConnectionId, SendDtmfTonesRequestInternal sendDtmfTonesRequest, Context context) {
        String accept = "application/json";
        return this.service.sendDtmfTones(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), sendDtmfTonesRequest, "application/json", CoreUtils.randomUuid().toString(), DateTimeRfc1123.toRfc1123String((OffsetDateTime)OffsetDateTime.now()), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SendDtmfTonesResultInternal> sendDtmfTonesAsync(String callConnectionId, SendDtmfTonesRequestInternal sendDtmfTonesRequest) {
        return this.sendDtmfTonesWithResponseAsync(callConnectionId, sendDtmfTonesRequest).flatMap(res -> Mono.justOrEmpty((Object)((SendDtmfTonesResultInternal)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SendDtmfTonesResultInternal> sendDtmfTonesAsync(String callConnectionId, SendDtmfTonesRequestInternal sendDtmfTonesRequest, Context context) {
        return this.sendDtmfTonesWithResponseAsync(callConnectionId, sendDtmfTonesRequest, context).flatMap(res -> Mono.justOrEmpty((Object)((SendDtmfTonesResultInternal)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SendDtmfTonesResultInternal> sendDtmfTonesWithResponse(String callConnectionId, SendDtmfTonesRequestInternal sendDtmfTonesRequest, Context context) {
        return (Response)this.sendDtmfTonesWithResponseAsync(callConnectionId, sendDtmfTonesRequest, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SendDtmfTonesResultInternal sendDtmfTones(String callConnectionId, SendDtmfTonesRequestInternal sendDtmfTonesRequest) {
        return (SendDtmfTonesResultInternal)this.sendDtmfTonesWithResponse(callConnectionId, sendDtmfTonesRequest, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> holdWithResponseAsync(String callConnectionId, HoldRequest holdRequest) {
        return FluxUtil.withContext(context -> this.holdWithResponseAsync(callConnectionId, holdRequest, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> holdWithResponseAsync(String callConnectionId, HoldRequest holdRequest, Context context) {
        String accept = "application/json";
        return this.service.hold(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), holdRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> holdAsync(String callConnectionId, HoldRequest holdRequest) {
        return this.holdWithResponseAsync(callConnectionId, holdRequest).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> holdAsync(String callConnectionId, HoldRequest holdRequest, Context context) {
        return this.holdWithResponseAsync(callConnectionId, holdRequest, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> holdWithResponse(String callConnectionId, HoldRequest holdRequest, Context context) {
        return (Response)this.holdWithResponseAsync(callConnectionId, holdRequest, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void hold(String callConnectionId, HoldRequest holdRequest) {
        this.holdWithResponse(callConnectionId, holdRequest, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> unholdWithResponseAsync(String callConnectionId, UnholdRequest unholdRequest) {
        return FluxUtil.withContext(context -> this.unholdWithResponseAsync(callConnectionId, unholdRequest, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> unholdWithResponseAsync(String callConnectionId, UnholdRequest unholdRequest, Context context) {
        String accept = "application/json";
        return this.service.unhold(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), unholdRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> unholdAsync(String callConnectionId, UnholdRequest unholdRequest) {
        return this.unholdWithResponseAsync(callConnectionId, unholdRequest).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> unholdAsync(String callConnectionId, UnholdRequest unholdRequest, Context context) {
        return this.unholdWithResponseAsync(callConnectionId, unholdRequest, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> unholdWithResponse(String callConnectionId, UnholdRequest unholdRequest, Context context) {
        return (Response)this.unholdWithResponseAsync(callConnectionId, unholdRequest, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void unhold(String callConnectionId, UnholdRequest unholdRequest) {
        this.unholdWithResponse(callConnectionId, unholdRequest, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> startMediaStreamingWithResponseAsync(String callConnectionId, StartMediaStreamingRequest startMediaStreamingRequest) {
        return FluxUtil.withContext(context -> this.startMediaStreamingWithResponseAsync(callConnectionId, startMediaStreamingRequest, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> startMediaStreamingWithResponseAsync(String callConnectionId, StartMediaStreamingRequest startMediaStreamingRequest, Context context) {
        String accept = "application/json";
        return this.service.startMediaStreaming(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), startMediaStreamingRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> startMediaStreamingAsync(String callConnectionId, StartMediaStreamingRequest startMediaStreamingRequest) {
        return this.startMediaStreamingWithResponseAsync(callConnectionId, startMediaStreamingRequest).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> startMediaStreamingAsync(String callConnectionId, StartMediaStreamingRequest startMediaStreamingRequest, Context context) {
        return this.startMediaStreamingWithResponseAsync(callConnectionId, startMediaStreamingRequest, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> startMediaStreamingWithResponse(String callConnectionId, StartMediaStreamingRequest startMediaStreamingRequest, Context context) {
        return (Response)this.startMediaStreamingWithResponseAsync(callConnectionId, startMediaStreamingRequest, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void startMediaStreaming(String callConnectionId, StartMediaStreamingRequest startMediaStreamingRequest) {
        this.startMediaStreamingWithResponse(callConnectionId, startMediaStreamingRequest, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> stopMediaStreamingWithResponseAsync(String callConnectionId, StopMediaStreamingRequest stopMediaStreamingRequest) {
        return FluxUtil.withContext(context -> this.stopMediaStreamingWithResponseAsync(callConnectionId, stopMediaStreamingRequest, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> stopMediaStreamingWithResponseAsync(String callConnectionId, StopMediaStreamingRequest stopMediaStreamingRequest, Context context) {
        String accept = "application/json";
        return this.service.stopMediaStreaming(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), stopMediaStreamingRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> stopMediaStreamingAsync(String callConnectionId, StopMediaStreamingRequest stopMediaStreamingRequest) {
        return this.stopMediaStreamingWithResponseAsync(callConnectionId, stopMediaStreamingRequest).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> stopMediaStreamingAsync(String callConnectionId, StopMediaStreamingRequest stopMediaStreamingRequest, Context context) {
        return this.stopMediaStreamingWithResponseAsync(callConnectionId, stopMediaStreamingRequest, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> stopMediaStreamingWithResponse(String callConnectionId, StopMediaStreamingRequest stopMediaStreamingRequest, Context context) {
        return (Response)this.stopMediaStreamingWithResponseAsync(callConnectionId, stopMediaStreamingRequest, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void stopMediaStreaming(String callConnectionId, StopMediaStreamingRequest stopMediaStreamingRequest) {
        this.stopMediaStreamingWithResponse(callConnectionId, stopMediaStreamingRequest, Context.NONE);
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="AzureCommunicationCallAutomationServiceCallMedias")
    public static interface CallMediasService {
        @Post(value="/calling/callConnections/{callConnectionId}:play")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<Void>> play(@HostParam(value="endpoint") String var1, @PathParam(value="callConnectionId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") PlayRequest var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/calling/callConnections/{callConnectionId}:startTranscription")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<Void>> startTranscription(@HostParam(value="endpoint") String var1, @PathParam(value="callConnectionId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") StartTranscriptionRequestInternal var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/calling/callConnections/{callConnectionId}:stopTranscription")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<Void>> stopTranscription(@HostParam(value="endpoint") String var1, @PathParam(value="callConnectionId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") StopTranscriptionRequestInternal var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/calling/callConnections/{callConnectionId}:updateTranscription")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<Void>> updateTranscription(@HostParam(value="endpoint") String var1, @PathParam(value="callConnectionId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") UpdateTranscriptionRequestInternal var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/calling/callConnections/{callConnectionId}:cancelAllMediaOperations")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<Void>> cancelAllMediaOperations(@HostParam(value="endpoint") String var1, @PathParam(value="callConnectionId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/calling/callConnections/{callConnectionId}:recognize")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<Void>> recognize(@HostParam(value="endpoint") String var1, @PathParam(value="callConnectionId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") RecognizeRequest var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/calling/callConnections/{callConnectionId}:startContinuousDtmfRecognition")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<Void>> startContinuousDtmfRecognition(@HostParam(value="endpoint") String var1, @PathParam(value="callConnectionId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") ContinuousDtmfRecognitionRequestInternal var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/calling/callConnections/{callConnectionId}:stopContinuousDtmfRecognition")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<Void>> stopContinuousDtmfRecognition(@HostParam(value="endpoint") String var1, @PathParam(value="callConnectionId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") ContinuousDtmfRecognitionRequestInternal var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/calling/callConnections/{callConnectionId}:sendDtmfTones")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<SendDtmfTonesResultInternal>> sendDtmfTones(@HostParam(value="endpoint") String var1, @PathParam(value="callConnectionId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") SendDtmfTonesRequestInternal var4, @HeaderParam(value="Accept") String var5, @HeaderParam(value="repeatability-request-id") String var6, @HeaderParam(value="repeatability-first-sent") String var7, Context var8);

        @Post(value="/calling/callConnections/{callConnectionId}:hold")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<Void>> hold(@HostParam(value="endpoint") String var1, @PathParam(value="callConnectionId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") HoldRequest var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/calling/callConnections/{callConnectionId}:unhold")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<Void>> unhold(@HostParam(value="endpoint") String var1, @PathParam(value="callConnectionId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") UnholdRequest var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/calling/callConnections/{callConnectionId}:startMediaStreaming")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<Void>> startMediaStreaming(@HostParam(value="endpoint") String var1, @PathParam(value="callConnectionId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") StartMediaStreamingRequest var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/calling/callConnections/{callConnectionId}:stopMediaStreaming")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<Void>> stopMediaStreaming(@HostParam(value="endpoint") String var1, @PathParam(value="callConnectionId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") StopMediaStreamingRequest var4, @HeaderParam(value="Accept") String var5, Context var6);
    }
}

