/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation;

import com.azure.communication.callautomation.CallRecordingAsync;
import com.azure.communication.callautomation.models.DownloadToFileOptions;
import com.azure.communication.callautomation.models.RecordingStateResult;
import com.azure.communication.callautomation.models.StartRecordingOptions;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpRange;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Objects;

public final class CallRecording {
    private final CallRecordingAsync callRecordingAsync;

    CallRecording(CallRecordingAsync callRecordingAsync) {
        this.callRecordingAsync = callRecordingAsync;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RecordingStateResult start(StartRecordingOptions options) {
        return (RecordingStateResult)this.callRecordingAsync.start(options).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RecordingStateResult> startWithResponse(StartRecordingOptions options, Context context) {
        return (Response)this.callRecordingAsync.startWithResponseInternal(options, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void stop(String recordingId) {
        this.callRecordingAsync.stop(recordingId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> stopWithResponse(String recordingId, Context context) {
        return (Response)this.callRecordingAsync.stopWithResponseInternal(recordingId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void pause(String recordingId) {
        this.callRecordingAsync.pause(recordingId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> pauseWithResponse(String recordingId, Context context) {
        return (Response)this.callRecordingAsync.pauseWithResponseInternal(recordingId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void resume(String recordingId) {
        this.callRecordingAsync.resume(recordingId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> resumeWithResponse(String recordingId, Context context) {
        return (Response)this.callRecordingAsync.resumeWithResponseInternal(recordingId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RecordingStateResult getState(String recordingId) {
        return (RecordingStateResult)this.callRecordingAsync.getState(recordingId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RecordingStateResult> getStateWithResponse(String recordingId, Context context) {
        return (Response)this.callRecordingAsync.getStateWithResponseInternal(recordingId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void downloadTo(String sourceUrl, OutputStream destinationStream) {
        this.downloadTo(sourceUrl, destinationStream, null, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void downloadTo(String sourceUrl, OutputStream destinationStream, HttpRange httpRange, Context context) {
        Objects.requireNonNull(sourceUrl, "'sourceUrl' cannot be null");
        Objects.requireNonNull(destinationStream, "'destinationStream' cannot be null");
        this.callRecordingAsync.downloadTo(sourceUrl, destinationStream, httpRange, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BinaryData downloadContent(String sourceUrl) {
        return (BinaryData)this.callRecordingAsync.downloadContent(sourceUrl).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> downloadContentWithResponse(String sourceUrl, HttpRange range, Context context) {
        return (Response)this.callRecordingAsync.downloadContentWithResponseInternal(sourceUrl, range, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void downloadTo(String sourceUrl, Path destinationPath) {
        DownloadToFileOptions options = new DownloadToFileOptions();
        this.downloadTo(sourceUrl, destinationPath, options, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void downloadTo(String sourceUrl, Path destinationPath, DownloadToFileOptions options, Context context) {
        Objects.requireNonNull(sourceUrl, "'sourceUrl' cannot be null");
        Objects.requireNonNull(destinationPath, "'destinationPath' cannot be null");
        this.callRecordingAsync.downloadToInternal(sourceUrl, destinationPath, options, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String deleteUrl) {
        this.deleteWithResponse(deleteUrl, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String deleteUrl, Context context) {
        return (Response)this.callRecordingAsync.deleteWithResponseInternal(deleteUrl, context).block();
    }
}

