/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation;

import com.azure.communication.callautomation.implementation.CallMediasImpl;
import com.azure.communication.callautomation.implementation.accesshelpers.SendDtmfTonesResponseConstructorProxy;
import com.azure.communication.callautomation.implementation.converters.CommunicationIdentifierConverter;
import com.azure.communication.callautomation.implementation.models.ContinuousDtmfRecognitionRequestInternal;
import com.azure.communication.callautomation.implementation.models.DtmfOptionsInternal;
import com.azure.communication.callautomation.implementation.models.DtmfToneInternal;
import com.azure.communication.callautomation.implementation.models.FileSourceInternal;
import com.azure.communication.callautomation.implementation.models.HoldRequest;
import com.azure.communication.callautomation.implementation.models.PlayOptionsInternal;
import com.azure.communication.callautomation.implementation.models.PlayRequest;
import com.azure.communication.callautomation.implementation.models.PlaySourceInternal;
import com.azure.communication.callautomation.implementation.models.PlaySourceTypeInternal;
import com.azure.communication.callautomation.implementation.models.RecognitionChoiceInternal;
import com.azure.communication.callautomation.implementation.models.RecognizeInputTypeInternal;
import com.azure.communication.callautomation.implementation.models.RecognizeOptionsInternal;
import com.azure.communication.callautomation.implementation.models.RecognizeRequest;
import com.azure.communication.callautomation.implementation.models.SendDtmfTonesRequestInternal;
import com.azure.communication.callautomation.implementation.models.SendDtmfTonesResultInternal;
import com.azure.communication.callautomation.implementation.models.SpeechOptionsInternal;
import com.azure.communication.callautomation.implementation.models.SsmlSourceInternal;
import com.azure.communication.callautomation.implementation.models.StartMediaStreamingRequest;
import com.azure.communication.callautomation.implementation.models.StartTranscriptionRequestInternal;
import com.azure.communication.callautomation.implementation.models.StopMediaStreamingRequest;
import com.azure.communication.callautomation.implementation.models.StopTranscriptionRequestInternal;
import com.azure.communication.callautomation.implementation.models.TextSourceInternal;
import com.azure.communication.callautomation.implementation.models.UnholdRequest;
import com.azure.communication.callautomation.implementation.models.UpdateTranscriptionRequestInternal;
import com.azure.communication.callautomation.implementation.models.VoiceKindInternal;
import com.azure.communication.callautomation.models.CallMediaRecognizeChoiceOptions;
import com.azure.communication.callautomation.models.CallMediaRecognizeDtmfOptions;
import com.azure.communication.callautomation.models.CallMediaRecognizeOptions;
import com.azure.communication.callautomation.models.CallMediaRecognizeSpeechOptions;
import com.azure.communication.callautomation.models.CallMediaRecognizeSpeechOrDtmfOptions;
import com.azure.communication.callautomation.models.ContinuousDtmfRecognitionOptions;
import com.azure.communication.callautomation.models.DtmfTone;
import com.azure.communication.callautomation.models.FileSource;
import com.azure.communication.callautomation.models.HoldOptions;
import com.azure.communication.callautomation.models.PlayOptions;
import com.azure.communication.callautomation.models.PlaySource;
import com.azure.communication.callautomation.models.PlayToAllOptions;
import com.azure.communication.callautomation.models.RecognitionChoice;
import com.azure.communication.callautomation.models.SendDtmfTonesOptions;
import com.azure.communication.callautomation.models.SendDtmfTonesResult;
import com.azure.communication.callautomation.models.SsmlSource;
import com.azure.communication.callautomation.models.StartMediaStreamingOptions;
import com.azure.communication.callautomation.models.StartTranscriptionOptions;
import com.azure.communication.callautomation.models.StopMediaStreamingOptions;
import com.azure.communication.callautomation.models.StopTranscriptionOptions;
import com.azure.communication.callautomation.models.TextSource;
import com.azure.communication.callautomation.models.UnholdOptions;
import com.azure.communication.callautomation.models.UpdateTranscriptionOptions;
import com.azure.communication.common.CommunicationIdentifier;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public final class CallMediaAsync {
    private final CallMediasImpl contentsInternal;
    private final String callConnectionId;
    private final ClientLogger logger;

    CallMediaAsync(String callConnectionId, CallMediasImpl contentsInternal) {
        this.callConnectionId = callConnectionId;
        this.contentsInternal = contentsInternal;
        this.logger = new ClientLogger(CallMediaAsync.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> play(List<PlaySource> playSources, List<CommunicationIdentifier> playTo) {
        PlayOptions options = new PlayOptions(playSources, playTo);
        return this.playWithResponse(options).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> play(PlaySource playSource, List<CommunicationIdentifier> playTo) {
        PlayOptions options = new PlayOptions(playSource, playTo);
        return this.playWithResponse(options).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> playToAll(List<PlaySource> playSources) {
        PlayToAllOptions options = new PlayToAllOptions(playSources);
        return this.playToAllWithResponse(options).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> playToAll(PlaySource playSource) {
        PlayToAllOptions options = new PlayToAllOptions(playSource);
        return this.playToAllWithResponse(options).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> playWithResponse(PlayOptions options) {
        return this.playWithResponseInternal(options, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> playToAllWithResponse(PlayToAllOptions options) {
        return this.playToAllWithResponseInternal(options, null);
    }

    public Mono<Void> startRecognizing(CallMediaRecognizeOptions recognizeOptions) {
        return this.startRecognizingWithResponse(recognizeOptions).then();
    }

    public Mono<Response<Void>> startRecognizingWithResponse(CallMediaRecognizeOptions recognizeOptions) {
        return FluxUtil.withContext(context -> this.recognizeWithResponseInternal(recognizeOptions, (Context)context));
    }

    Mono<Response<Void>> recognizeWithResponseInternal(CallMediaRecognizeOptions recognizeOptions, Context context) {
        try {
            Context context2 = context = context == null ? Context.NONE : context;
            if (recognizeOptions instanceof CallMediaRecognizeDtmfOptions) {
                RecognizeRequest recognizeRequest = this.getRecognizeRequestFromDtmfConfiguration(recognizeOptions);
                return this.contentsInternal.recognizeWithResponseAsync(this.callConnectionId, recognizeRequest, context);
            }
            if (recognizeOptions instanceof CallMediaRecognizeChoiceOptions) {
                RecognizeRequest recognizeRequest = this.getRecognizeRequestFromChoiceConfiguration(recognizeOptions);
                return this.contentsInternal.recognizeWithResponseAsync(this.callConnectionId, recognizeRequest, context);
            }
            if (recognizeOptions instanceof CallMediaRecognizeSpeechOptions) {
                RecognizeRequest recognizeRequest = this.getRecognizeRequestFromSpeechConfiguration(recognizeOptions);
                return this.contentsInternal.recognizeWithResponseAsync(this.callConnectionId, recognizeRequest, context);
            }
            if (recognizeOptions instanceof CallMediaRecognizeSpeechOrDtmfOptions) {
                RecognizeRequest recognizeRequest = this.getRecognizeRequestFromSpeechOrDtmfConfiguration(recognizeOptions);
                return this.contentsInternal.recognizeWithResponseAsync(this.callConnectionId, recognizeRequest, context);
            }
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new UnsupportedOperationException(recognizeOptions.getClass().getName()));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> cancelAllMediaOperations() {
        return this.cancelAllMediaOperationsWithResponse().then();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> cancelAllMediaOperationsWithResponse() {
        return this.cancelAllMediaOperationsWithResponseInternal(null);
    }

    Mono<Response<Void>> cancelAllMediaOperationsWithResponseInternal(Context context) {
        try {
            return FluxUtil.withContext(contextValue -> {
                contextValue = context == null ? contextValue : context;
                return this.contentsInternal.cancelAllMediaOperationsWithResponseAsync(this.callConnectionId, (Context)contextValue);
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> playWithResponseInternal(PlayOptions options, Context context) {
        try {
            return FluxUtil.withContext(contextValue -> {
                contextValue = context == null ? contextValue : context;
                PlayRequest request = this.getPlayRequest(options);
                return this.contentsInternal.playWithResponseAsync(this.callConnectionId, request, (Context)contextValue);
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> playToAllWithResponseInternal(PlayToAllOptions options, Context context) {
        try {
            PlayToAllOptions playOptions = new PlayToAllOptions(options.getPlaySources());
            playOptions.setLoop(options.isLoop());
            playOptions.setInterruptCallMediaOperation(options.isInterruptCallMediaOperation());
            playOptions.setOperationContext(options.getOperationContext());
            playOptions.setOperationCallbackUrl(options.getOperationCallbackUrl());
            return FluxUtil.withContext(contextValue -> {
                contextValue = context == null ? contextValue : context;
                PlayRequest request = this.getPlayToAllRequest(options);
                return this.contentsInternal.playWithResponseAsync(this.callConnectionId, request, (Context)contextValue);
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    PlayRequest getPlayRequest(PlayOptions options) {
        ArrayList<PlaySourceInternal> playSourcesInternal = new ArrayList<PlaySourceInternal>();
        for (PlaySource source : options.getPlaySources()) {
            PlaySourceInternal playSourceInternal = null;
            if (source instanceof FileSource) {
                playSourceInternal = this.getPlaySourceInternalFromFileSource((FileSource)source);
            } else if (source instanceof TextSource) {
                playSourceInternal = this.getPlaySourceInternalFromTextSource((TextSource)source);
            } else if (source instanceof SsmlSource) {
                playSourceInternal = this.getPlaySourceInternalFromSsmlSource((SsmlSource)source);
            }
            if (playSourceInternal != null && playSourceInternal.getKind() != null) {
                playSourcesInternal.add(playSourceInternal);
                continue;
            }
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(source.getClass().getCanonicalName()));
        }
        if (!playSourcesInternal.isEmpty()) {
            PlayRequest request = new PlayRequest().setPlaySources(playSourcesInternal).setPlayTo(options.getPlayTo().stream().map(CommunicationIdentifierConverter::convert).collect(Collectors.toList()));
            request.setPlayOptions(new PlayOptionsInternal().setLoop(options.isLoop()));
            request.setOperationContext(options.getOperationContext());
            request.setOperationCallbackUri(options.getOperationCallbackUrl());
            return request;
        }
        throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(options.getPlaySources().getClass().getCanonicalName()));
    }

    PlayRequest getPlayToAllRequest(PlayToAllOptions options) {
        ArrayList<PlaySourceInternal> playSourcesInternal = new ArrayList<PlaySourceInternal>();
        for (PlaySource source : options.getPlaySources()) {
            PlaySourceInternal playSourceInternal = null;
            if (source instanceof FileSource) {
                playSourceInternal = this.getPlaySourceInternalFromFileSource((FileSource)source);
            } else if (source instanceof TextSource) {
                playSourceInternal = this.getPlaySourceInternalFromTextSource((TextSource)source);
            } else if (source instanceof SsmlSource) {
                playSourceInternal = this.getPlaySourceInternalFromSsmlSource((SsmlSource)source);
            }
            if (playSourceInternal != null && playSourceInternal.getKind() != null) {
                playSourcesInternal.add(playSourceInternal);
                continue;
            }
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(source.getClass().getCanonicalName()));
        }
        if (!playSourcesInternal.isEmpty()) {
            PlayRequest request = new PlayRequest().setPlaySources(playSourcesInternal);
            request.setPlayOptions(new PlayOptionsInternal().setLoop(options.isLoop()));
            request.setInterruptCallMediaOperation(options.isInterruptCallMediaOperation());
            request.setOperationContext(options.getOperationContext());
            request.setOperationCallbackUri(options.getOperationCallbackUrl());
            return request;
        }
        throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(options.getPlaySources().getClass().getCanonicalName()));
    }

    private PlaySourceInternal getPlaySourceInternalFromFileSource(FileSource playSource) {
        FileSourceInternal fileSourceInternal = new FileSourceInternal().setUri(playSource.getUrl());
        return new PlaySourceInternal().setKind(PlaySourceTypeInternal.FILE).setFile(fileSourceInternal).setPlaySourceCacheId(playSource.getPlaySourceCacheId());
    }

    private PlaySourceInternal getPlaySourceInternalFromTextSource(TextSource playSource) {
        TextSourceInternal textSourceInternal = new TextSourceInternal().setText(playSource.getText());
        if (playSource.getVoiceKind() != null) {
            textSourceInternal.setVoiceKind(VoiceKindInternal.fromString(playSource.getVoiceKind().toString()));
        }
        if (playSource.getSourceLocale() != null) {
            textSourceInternal.setSourceLocale(playSource.getSourceLocale());
        }
        if (playSource.getVoiceName() != null) {
            textSourceInternal.setVoiceName(playSource.getVoiceName());
        }
        if (playSource.getCustomVoiceEndpointId() != null) {
            textSourceInternal.setCustomVoiceEndpointId(playSource.getCustomVoiceEndpointId());
        }
        return new PlaySourceInternal().setKind(PlaySourceTypeInternal.TEXT).setText(textSourceInternal).setPlaySourceCacheId(playSource.getPlaySourceCacheId());
    }

    private PlaySourceInternal getPlaySourceInternalFromSsmlSource(SsmlSource playSource) {
        SsmlSourceInternal ssmlSourceInternal = new SsmlSourceInternal().setSsmlText(playSource.getSsmlText());
        if (playSource.getCustomVoiceEndpointId() != null) {
            ssmlSourceInternal.setCustomVoiceEndpointId(playSource.getCustomVoiceEndpointId());
        }
        return new PlaySourceInternal().setKind(PlaySourceTypeInternal.SSML).setSsml(ssmlSourceInternal).setPlaySourceCacheId(playSource.getPlaySourceCacheId());
    }

    private PlaySourceInternal convertPlaySourceToPlaySourceInternal(PlaySource playSource) {
        PlaySourceInternal playSourceInternal = new PlaySourceInternal();
        if (playSource instanceof FileSource) {
            playSourceInternal = this.getPlaySourceInternalFromFileSource((FileSource)playSource);
        } else if (playSource instanceof TextSource) {
            playSourceInternal = this.getPlaySourceInternalFromTextSource((TextSource)playSource);
        } else if (playSource instanceof SsmlSource) {
            playSourceInternal = this.getPlaySourceInternalFromSsmlSource((SsmlSource)playSource);
        }
        return playSourceInternal;
    }

    private List<RecognitionChoiceInternal> convertListRecognitionChoiceInternal(List<RecognitionChoice> recognitionChoices) {
        return recognitionChoices.stream().map(this::convertRecognitionChoiceInternal).collect(Collectors.toList());
    }

    private RecognitionChoiceInternal convertRecognitionChoiceInternal(RecognitionChoice recognitionChoice) {
        RecognitionChoiceInternal internalRecognitionChoice = new RecognitionChoiceInternal();
        if (recognitionChoice.getLabel() != null) {
            internalRecognitionChoice.setLabel(recognitionChoice.getLabel());
        }
        if (recognitionChoice.getPhrases() != null) {
            internalRecognitionChoice.setPhrases(recognitionChoice.getPhrases());
        }
        if (recognitionChoice.getTone() != null) {
            internalRecognitionChoice.setTone(this.convertDtmfToneInternal(recognitionChoice.getTone()));
        }
        return internalRecognitionChoice;
    }

    private DtmfToneInternal convertDtmfToneInternal(DtmfTone dtmfTone) {
        return DtmfToneInternal.fromString(dtmfTone.toString());
    }

    private RecognizeRequest getRecognizeRequestFromDtmfConfiguration(CallMediaRecognizeOptions recognizeOptions) {
        CallMediaRecognizeDtmfOptions dtmfRecognizeOptions = (CallMediaRecognizeDtmfOptions)recognizeOptions;
        DtmfOptionsInternal dtmfOptionsInternal = this.getDtmfOptionsInternal(dtmfRecognizeOptions.getInterToneTimeout(), dtmfRecognizeOptions.getMaxTonesToCollect(), dtmfRecognizeOptions.getStopTones());
        RecognizeOptionsInternal recognizeOptionsInternal = new RecognizeOptionsInternal().setDtmfOptions(dtmfOptionsInternal).setInterruptPrompt(recognizeOptions.isInterruptPrompt()).setTargetParticipant(CommunicationIdentifierConverter.convert(recognizeOptions.getTargetParticipant()));
        recognizeOptionsInternal.setInitialSilenceTimeoutInSeconds((int)recognizeOptions.getInitialSilenceTimeout().getSeconds());
        PlaySourceInternal playSourceInternal = this.getPlaySourceInternalFromRecognizeOptions(recognizeOptions);
        List<PlaySourceInternal> playSourcesInternal = this.getListPlaySourceInternalFromRecognizeOptions(recognizeOptions);
        RecognizeRequest recognizeRequest = new RecognizeRequest().setRecognizeInputType(RecognizeInputTypeInternal.fromString(recognizeOptions.getRecognizeInputType().toString())).setInterruptCallMediaOperation(recognizeOptions.isInterruptCallMediaOperation()).setPlayPrompt(playSourceInternal).setPlayPrompts(playSourcesInternal).setRecognizeOptions(recognizeOptionsInternal).setOperationContext(recognizeOptions.getOperationContext()).setOperationCallbackUri(recognizeOptions.getOperationCallbackUrl());
        return recognizeRequest;
    }

    private RecognizeRequest getRecognizeRequestFromChoiceConfiguration(CallMediaRecognizeOptions recognizeOptions) {
        CallMediaRecognizeChoiceOptions choiceRecognizeOptions = (CallMediaRecognizeChoiceOptions)recognizeOptions;
        RecognizeOptionsInternal recognizeOptionsInternal = new RecognizeOptionsInternal().setChoices(this.convertListRecognitionChoiceInternal(choiceRecognizeOptions.getChoices())).setInterruptPrompt(choiceRecognizeOptions.isInterruptPrompt()).setTargetParticipant(CommunicationIdentifierConverter.convert(choiceRecognizeOptions.getTargetParticipant()));
        recognizeOptionsInternal.setInitialSilenceTimeoutInSeconds((int)choiceRecognizeOptions.getInitialSilenceTimeout().getSeconds());
        if (choiceRecognizeOptions.getSpeechLanguage() != null && !choiceRecognizeOptions.getSpeechLanguage().isEmpty()) {
            recognizeOptionsInternal.setSpeechLanguage(choiceRecognizeOptions.getSpeechLanguage());
        }
        if (choiceRecognizeOptions.getSpeechRecognitionModelEndpointId() != null && !choiceRecognizeOptions.getSpeechRecognitionModelEndpointId().isEmpty()) {
            recognizeOptionsInternal.setSpeechRecognitionModelEndpointId(choiceRecognizeOptions.getSpeechRecognitionModelEndpointId());
        }
        PlaySourceInternal playSourceInternal = this.getPlaySourceInternalFromRecognizeOptions(recognizeOptions);
        List<PlaySourceInternal> playSourcesInternal = this.getListPlaySourceInternalFromRecognizeOptions(recognizeOptions);
        RecognizeRequest recognizeRequest = new RecognizeRequest().setRecognizeInputType(RecognizeInputTypeInternal.fromString(choiceRecognizeOptions.getRecognizeInputType().toString())).setInterruptCallMediaOperation(choiceRecognizeOptions.isInterruptCallMediaOperation()).setPlayPrompt(playSourceInternal).setPlayPrompts(playSourcesInternal).setRecognizeOptions(recognizeOptionsInternal).setOperationContext(recognizeOptions.getOperationContext()).setOperationCallbackUri(recognizeOptions.getOperationCallbackUrl());
        return recognizeRequest;
    }

    private RecognizeRequest getRecognizeRequestFromSpeechConfiguration(CallMediaRecognizeOptions recognizeOptions) {
        CallMediaRecognizeSpeechOptions speechRecognizeOptions = (CallMediaRecognizeSpeechOptions)recognizeOptions;
        SpeechOptionsInternal speechOptionsInternal = new SpeechOptionsInternal().setEndSilenceTimeoutInMs(speechRecognizeOptions.getEndSilenceTimeout().toMillis());
        RecognizeOptionsInternal recognizeOptionsInternal = new RecognizeOptionsInternal().setSpeechOptions(speechOptionsInternal).setInterruptPrompt(speechRecognizeOptions.isInterruptPrompt()).setTargetParticipant(CommunicationIdentifierConverter.convert(speechRecognizeOptions.getTargetParticipant()));
        recognizeOptionsInternal.setInitialSilenceTimeoutInSeconds((int)speechRecognizeOptions.getInitialSilenceTimeout().getSeconds());
        if (speechRecognizeOptions.getSpeechLanguage() != null && !speechRecognizeOptions.getSpeechLanguage().isEmpty()) {
            recognizeOptionsInternal.setSpeechLanguage(speechRecognizeOptions.getSpeechLanguage());
        }
        if (speechRecognizeOptions.getSpeechRecognitionModelEndpointId() != null && !speechRecognizeOptions.getSpeechRecognitionModelEndpointId().isEmpty()) {
            recognizeOptionsInternal.setSpeechRecognitionModelEndpointId(speechRecognizeOptions.getSpeechRecognitionModelEndpointId());
        }
        PlaySourceInternal playSourceInternal = this.getPlaySourceInternalFromRecognizeOptions(recognizeOptions);
        List<PlaySourceInternal> playSourcesInternal = this.getListPlaySourceInternalFromRecognizeOptions(recognizeOptions);
        RecognizeRequest recognizeRequest = new RecognizeRequest().setRecognizeInputType(RecognizeInputTypeInternal.fromString(speechRecognizeOptions.getRecognizeInputType().toString())).setInterruptCallMediaOperation(speechRecognizeOptions.isInterruptCallMediaOperation()).setPlayPrompt(playSourceInternal).setPlayPrompts(playSourcesInternal).setRecognizeOptions(recognizeOptionsInternal).setOperationContext(recognizeOptions.getOperationContext()).setOperationCallbackUri(recognizeOptions.getOperationCallbackUrl());
        return recognizeRequest;
    }

    private RecognizeRequest getRecognizeRequestFromSpeechOrDtmfConfiguration(CallMediaRecognizeOptions recognizeOptions) {
        CallMediaRecognizeSpeechOrDtmfOptions speechOrDtmfRecognizeOptions = (CallMediaRecognizeSpeechOrDtmfOptions)recognizeOptions;
        DtmfOptionsInternal dtmfOptionsInternal = this.getDtmfOptionsInternal(speechOrDtmfRecognizeOptions.getInterToneTimeout(), speechOrDtmfRecognizeOptions.getMaxTonesToCollect(), speechOrDtmfRecognizeOptions.getStopTones());
        SpeechOptionsInternal speechOptionsInternal = new SpeechOptionsInternal().setEndSilenceTimeoutInMs(speechOrDtmfRecognizeOptions.getEndSilenceTimeout().toMillis());
        RecognizeOptionsInternal recognizeOptionsInternal = new RecognizeOptionsInternal().setSpeechOptions(speechOptionsInternal).setDtmfOptions(dtmfOptionsInternal).setInterruptPrompt(speechOrDtmfRecognizeOptions.isInterruptPrompt()).setTargetParticipant(CommunicationIdentifierConverter.convert(speechOrDtmfRecognizeOptions.getTargetParticipant()));
        recognizeOptionsInternal.setInitialSilenceTimeoutInSeconds((int)speechOrDtmfRecognizeOptions.getInitialSilenceTimeout().getSeconds());
        if (speechOrDtmfRecognizeOptions.getSpeechLanguage() != null && !speechOrDtmfRecognizeOptions.getSpeechLanguage().isEmpty()) {
            recognizeOptionsInternal.setSpeechLanguage(speechOrDtmfRecognizeOptions.getSpeechLanguage());
        }
        if (speechOrDtmfRecognizeOptions.getSpeechRecognitionModelEndpointId() != null && !speechOrDtmfRecognizeOptions.getSpeechRecognitionModelEndpointId().isEmpty()) {
            recognizeOptionsInternal.setSpeechRecognitionModelEndpointId(speechOrDtmfRecognizeOptions.getSpeechRecognitionModelEndpointId());
        }
        PlaySourceInternal playSourceInternal = this.getPlaySourceInternalFromRecognizeOptions(recognizeOptions);
        List<PlaySourceInternal> playSourcesInternal = this.getListPlaySourceInternalFromRecognizeOptions(recognizeOptions);
        RecognizeRequest recognizeRequest = new RecognizeRequest().setRecognizeInputType(RecognizeInputTypeInternal.fromString(speechOrDtmfRecognizeOptions.getRecognizeInputType().toString())).setInterruptCallMediaOperation(speechOrDtmfRecognizeOptions.isInterruptCallMediaOperation()).setPlayPrompt(playSourceInternal).setPlayPrompts(playSourcesInternal).setRecognizeOptions(recognizeOptionsInternal).setOperationContext(recognizeOptions.getOperationContext()).setOperationCallbackUri(recognizeOptions.getOperationCallbackUrl());
        return recognizeRequest;
    }

    private List<PlaySourceInternal> getListPlaySourceInternalFromRecognizeOptions(CallMediaRecognizeOptions recognizeOptions) {
        ArrayList<PlaySourceInternal> playSourcesInternal = new ArrayList<PlaySourceInternal>();
        if (recognizeOptions.getPlayPrompts() != null) {
            for (PlaySource playSource : recognizeOptions.getPlayPrompts()) {
                if (playSource == null) continue;
                playSourcesInternal.add(this.convertPlaySourceToPlaySourceInternal(playSource));
            }
        }
        return playSourcesInternal;
    }

    private DtmfOptionsInternal getDtmfOptionsInternal(Duration interToneTimeout, Integer maxTonesToCollect, List<DtmfTone> stopTones) {
        DtmfOptionsInternal dtmfOptionsInternal = new DtmfOptionsInternal();
        dtmfOptionsInternal.setInterToneTimeoutInSeconds((int)interToneTimeout.getSeconds());
        if (maxTonesToCollect != null) {
            dtmfOptionsInternal.setMaxTonesToCollect(maxTonesToCollect);
        }
        if (stopTones != null) {
            List<DtmfToneInternal> dtmfTones = stopTones.stream().map(this::convertDtmfToneInternal).collect(Collectors.toList());
            dtmfOptionsInternal.setStopTones(dtmfTones);
        }
        return dtmfOptionsInternal;
    }

    private PlaySourceInternal getPlaySourceInternalFromRecognizeOptions(CallMediaRecognizeOptions recognizeOptions) {
        PlaySourceInternal playSourceInternal = null;
        if (recognizeOptions.getPlayPrompt() != null) {
            PlaySource playSource = recognizeOptions.getPlayPrompt();
            playSourceInternal = this.convertPlaySourceToPlaySourceInternal(playSource);
        }
        return playSourceInternal;
    }

    public Mono<SendDtmfTonesResult> sendDtmfTones(List<DtmfTone> tones, CommunicationIdentifier targetParticipant) {
        return this.sendDtmfTonesWithResponse(new SendDtmfTonesOptions(tones, targetParticipant)).flatMap(FluxUtil::toMono);
    }

    public Mono<Response<SendDtmfTonesResult>> sendDtmfTonesWithResponse(SendDtmfTonesOptions options) {
        return FluxUtil.withContext(context -> this.sendDtmfTonesWithResponseInternal(options, (Context)context));
    }

    Mono<Response<SendDtmfTonesResult>> sendDtmfTonesWithResponseInternal(SendDtmfTonesOptions options, Context context) {
        try {
            context = context == null ? Context.NONE : context;
            SendDtmfTonesRequestInternal requestInternal = new SendDtmfTonesRequestInternal().setTargetParticipant(CommunicationIdentifierConverter.convert(options.getTargetParticipant())).setTones(options.getTones().stream().map(this::convertDtmfToneInternal).collect(Collectors.toList())).setOperationContext(options.getOperationContext()).setOperationCallbackUri(options.getOperationCallbackUrl());
            return this.contentsInternal.sendDtmfTonesWithResponseAsync(this.callConnectionId, requestInternal, context).map(response -> new SimpleResponse(response, (Object)SendDtmfTonesResponseConstructorProxy.create((SendDtmfTonesResultInternal)response.getValue())));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    public Mono<Void> startContinuousDtmfRecognition(CommunicationIdentifier targetParticipant) {
        return this.startContinuousDtmfRecognitionWithResponse(new ContinuousDtmfRecognitionOptions(targetParticipant)).then();
    }

    public Mono<Response<Void>> startContinuousDtmfRecognitionWithResponse(ContinuousDtmfRecognitionOptions options) {
        return FluxUtil.withContext(context -> this.startContinuousDtmfRecognitionWithResponseInternal(options, (Context)context));
    }

    Mono<Response<Void>> startContinuousDtmfRecognitionWithResponseInternal(ContinuousDtmfRecognitionOptions options, Context context) {
        try {
            context = context == null ? Context.NONE : context;
            ContinuousDtmfRecognitionRequestInternal requestInternal = new ContinuousDtmfRecognitionRequestInternal().setTargetParticipant(CommunicationIdentifierConverter.convert(options.getTargetParticipant())).setOperationContext(options.getOperationContext());
            return this.contentsInternal.startContinuousDtmfRecognitionWithResponseAsync(this.callConnectionId, requestInternal, context);
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    public Mono<Void> stopContinuousDtmfRecognition(CommunicationIdentifier targetParticipant) {
        return this.stopContinuousDtmfRecognitionWithResponse(new ContinuousDtmfRecognitionOptions(targetParticipant)).then();
    }

    public Mono<Response<Void>> stopContinuousDtmfRecognitionWithResponse(ContinuousDtmfRecognitionOptions options) {
        return FluxUtil.withContext(context -> this.stopContinuousDtmfRecognitionWithResponseInternal(options, (Context)context));
    }

    Mono<Response<Void>> stopContinuousDtmfRecognitionWithResponseInternal(ContinuousDtmfRecognitionOptions options, Context context) {
        try {
            context = context == null ? Context.NONE : context;
            ContinuousDtmfRecognitionRequestInternal requestInternal = new ContinuousDtmfRecognitionRequestInternal().setTargetParticipant(CommunicationIdentifierConverter.convert(options.getTargetParticipant())).setOperationContext(options.getOperationContext()).setOperationCallbackUri(options.getOperationCallbackUrl());
            return this.contentsInternal.stopContinuousDtmfRecognitionWithResponseAsync(this.callConnectionId, requestInternal, context);
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> hold(CommunicationIdentifier targetParticipant) {
        return this.holdWithResponse(new HoldOptions(targetParticipant)).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> hold(CommunicationIdentifier targetParticipant, PlaySource playSource) {
        return this.holdWithResponse(new HoldOptions(targetParticipant).setPlaySource(playSource)).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> holdWithResponse(HoldOptions options) {
        return FluxUtil.withContext(context -> this.holdWithResponseInternal(options, (Context)context));
    }

    Mono<Response<Void>> holdWithResponseInternal(HoldOptions options, Context context) {
        try {
            context = context == null ? Context.NONE : context;
            HoldRequest request = new HoldRequest().setTargetParticipant(CommunicationIdentifierConverter.convert(options.getTargetParticipant())).setOperationContext(options.getOperationContext()).setOperationCallbackUri(options.getOperationCallbackUrl());
            if (options.getPlaySource() != null) {
                request.setPlaySourceInfo(this.convertPlaySourceToPlaySourceInternal(options.getPlaySource()));
            }
            return this.contentsInternal.holdWithResponseAsync(this.callConnectionId, request, context);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> unhold(CommunicationIdentifier targetParticipant) {
        return this.unholdWithResponse(new UnholdOptions(targetParticipant)).then();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> unholdWithResponse(UnholdOptions options) {
        return FluxUtil.withContext(context -> this.unholdWithResponseInternal(options, (Context)context));
    }

    Mono<Response<Void>> unholdWithResponseInternal(UnholdOptions options, Context context) {
        try {
            context = context == null ? Context.NONE : context;
            UnholdRequest request = new UnholdRequest().setTargetParticipant(CommunicationIdentifierConverter.convert(options.getTargetParticipant())).setOperationContext(options.getOperationContext()).setOperationCallbackUri(options.getOperationCallbackUrl());
            return this.contentsInternal.unholdWithResponseAsync(this.callConnectionId, request, context);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> startTranscription() {
        return this.startTranscriptionWithResponse(null).then();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> startTranscriptionWithResponse(StartTranscriptionOptions options) {
        return FluxUtil.withContext(context -> this.startTranscriptionWithResponseInternal(options, (Context)context));
    }

    Mono<Response<Void>> startTranscriptionWithResponseInternal(StartTranscriptionOptions options, Context context) {
        try {
            context = context == null ? Context.NONE : context;
            StartTranscriptionRequestInternal request = new StartTranscriptionRequestInternal();
            if (options != null) {
                request.setLocale(options.getLocale());
                request.setOperationContext(options.getOperationContext());
                request.setSpeechModelEndpointId(options.getSpeechRecognitionModelEndpointId());
            }
            return this.contentsInternal.startTranscriptionWithResponseAsync(this.callConnectionId, request, context);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> stopTranscription() {
        return this.stopTranscriptionWithResponse(null).then();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> stopTranscriptionWithResponse(StopTranscriptionOptions options) {
        return FluxUtil.withContext(context -> this.stopTranscriptionWithResponseInternal(options, (Context)context));
    }

    Mono<Response<Void>> stopTranscriptionWithResponseInternal(StopTranscriptionOptions options, Context context) {
        try {
            context = context == null ? Context.NONE : context;
            StopTranscriptionRequestInternal request = new StopTranscriptionRequestInternal();
            if (options != null) {
                request.setOperationContext(options.getOperationContext());
            }
            return this.contentsInternal.stopTranscriptionWithResponseAsync(this.callConnectionId, request, context);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updateTranscription(String locale) {
        return this.updateTranscriptionWithResponse(new UpdateTranscriptionOptions().setLocale(locale)).then();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> updateTranscriptionWithResponse(UpdateTranscriptionOptions options) {
        return FluxUtil.withContext(context -> this.updateTranscriptionWithResponseInternal(options, (Context)context));
    }

    Mono<Response<Void>> updateTranscriptionWithResponseInternal(UpdateTranscriptionOptions options, Context context) {
        try {
            context = context == null ? Context.NONE : context;
            UpdateTranscriptionRequestInternal request = new UpdateTranscriptionRequestInternal();
            request.setLocale(options.getLocale());
            request.setSpeechModelEndpointId(options.getSpeechRecognitionModelEndpointId());
            request.setOperationContext(options.getOperationContext());
            return this.contentsInternal.updateTranscriptionWithResponseAsync(this.callConnectionId, request, context);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> startMediaStreaming() {
        return this.startMediaStreamingWithResponse(null).then();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> startMediaStreamingWithResponse(StartMediaStreamingOptions options) {
        return FluxUtil.withContext(context -> this.startMediaStreamingWithResponseInternal(options, (Context)context));
    }

    Mono<Response<Void>> startMediaStreamingWithResponseInternal(StartMediaStreamingOptions options, Context context) {
        try {
            context = context == null ? Context.NONE : context;
            StartMediaStreamingRequest request = new StartMediaStreamingRequest();
            if (options != null) {
                request.setOperationCallbackUri(options.getOperationCallbackUrl());
                request.setOperationContext(options.getOperationContext());
            }
            return this.contentsInternal.startMediaStreamingWithResponseAsync(this.callConnectionId, request, context);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> stopMediaStreaming() {
        return this.stopMediaStreamingWithResponse(null).then();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> stopMediaStreamingWithResponse(StopMediaStreamingOptions options) {
        return FluxUtil.withContext(context -> this.stopMediaStreamingWithResponseInternal(options, (Context)context));
    }

    Mono<Response<Void>> stopMediaStreamingWithResponseInternal(StopMediaStreamingOptions options, Context context) {
        try {
            context = context == null ? Context.NONE : context;
            StopMediaStreamingRequest request = new StopMediaStreamingRequest();
            if (options != null) {
                request.setOperationCallbackUri(options.getOperationCallbackUrl());
            }
            return this.contentsInternal.stopMediaStreamingWithResponseAsync(this.callConnectionId, request, context);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }
}

