/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation;

import com.azure.communication.callautomation.models.events.AddParticipantFailed;
import com.azure.communication.callautomation.models.events.AddParticipantSucceeded;
import com.azure.communication.callautomation.models.events.AnswerFailed;
import com.azure.communication.callautomation.models.events.CallAutomationEventBase;
import com.azure.communication.callautomation.models.events.CallConnected;
import com.azure.communication.callautomation.models.events.CallDisconnected;
import com.azure.communication.callautomation.models.events.CallTransferAccepted;
import com.azure.communication.callautomation.models.events.CallTransferFailed;
import com.azure.communication.callautomation.models.events.CancelAddParticipantFailed;
import com.azure.communication.callautomation.models.events.CancelAddParticipantSucceeded;
import com.azure.communication.callautomation.models.events.ConnectFailed;
import com.azure.communication.callautomation.models.events.ContinuousDtmfRecognitionStopped;
import com.azure.communication.callautomation.models.events.ContinuousDtmfRecognitionToneFailed;
import com.azure.communication.callautomation.models.events.ContinuousDtmfRecognitionToneReceived;
import com.azure.communication.callautomation.models.events.CreateCallFailed;
import com.azure.communication.callautomation.models.events.HoldFailed;
import com.azure.communication.callautomation.models.events.MediaStreamingFailed;
import com.azure.communication.callautomation.models.events.MediaStreamingStarted;
import com.azure.communication.callautomation.models.events.MediaStreamingStopped;
import com.azure.communication.callautomation.models.events.ParticipantsUpdated;
import com.azure.communication.callautomation.models.events.PlayCanceled;
import com.azure.communication.callautomation.models.events.PlayCompleted;
import com.azure.communication.callautomation.models.events.PlayFailed;
import com.azure.communication.callautomation.models.events.PlayStarted;
import com.azure.communication.callautomation.models.events.RecognizeCanceled;
import com.azure.communication.callautomation.models.events.RecognizeCompleted;
import com.azure.communication.callautomation.models.events.RecognizeFailed;
import com.azure.communication.callautomation.models.events.RecordingStateChanged;
import com.azure.communication.callautomation.models.events.RemoveParticipantFailed;
import com.azure.communication.callautomation.models.events.RemoveParticipantSucceeded;
import com.azure.communication.callautomation.models.events.SendDtmfTonesCompleted;
import com.azure.communication.callautomation.models.events.SendDtmfTonesFailed;
import com.azure.communication.callautomation.models.events.TranscriptionFailed;
import com.azure.communication.callautomation.models.events.TranscriptionResumed;
import com.azure.communication.callautomation.models.events.TranscriptionStarted;
import com.azure.communication.callautomation.models.events.TranscriptionStopped;
import com.azure.communication.callautomation.models.events.TranscriptionUpdated;
import com.azure.core.models.CloudEvent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonProviders;
import com.azure.json.JsonReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class CallAutomationEventParser {
    private static final ClientLogger LOGGER = new ClientLogger(CallAutomationEventParser.class);

    public static List<CallAutomationEventBase> parseEvents(String requestBody) {
        List<CallAutomationEventBase> callAutomationBaseEvents = CallAutomationEventParser.parseCloudEventList(requestBody);
        return callAutomationBaseEvents;
    }

    private static List<CallAutomationEventBase> parseCloudEventList(String requestBody) {
        try {
            List cloudEvents;
            ArrayList<CallAutomationEventBase> callAutomationBaseEvents = new ArrayList<CallAutomationEventBase>();
            try {
                cloudEvents = CloudEvent.fromString((String)requestBody);
            }
            catch (RuntimeException e) {
                return callAutomationBaseEvents;
            }
            for (CloudEvent cloudEvent : cloudEvents) {
                CallAutomationEventBase temp = CallAutomationEventParser.parseSingleCloudEvent(cloudEvent.getData().toString(), cloudEvent.getType());
                if (temp == null) continue;
                callAutomationBaseEvents.add(temp);
            }
            return callAutomationBaseEvents;
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    private static CallAutomationEventBase parseSingleCloudEvent(String data, String eventType) {
        CallConnected callConnected;
        block8: {
            JsonReader jsonReader = JsonProviders.createReader((String)data);
            try {
                CallAutomationEventBase ret = Objects.equals(eventType, "Microsoft.Communication.CallConnected") ? CallConnected.fromJson(jsonReader) : (Objects.equals(eventType, "Microsoft.Communication.CallDisconnected") ? CallDisconnected.fromJson(jsonReader) : (Objects.equals(eventType, "Microsoft.Communication.AddParticipantFailed") ? AddParticipantFailed.fromJson(jsonReader) : (Objects.equals(eventType, "Microsoft.Communication.AddParticipantSucceeded") ? AddParticipantSucceeded.fromJson(jsonReader) : (Objects.equals(eventType, "Microsoft.Communication.CallTransferAccepted") ? CallTransferAccepted.fromJson(jsonReader) : (Objects.equals(eventType, "Microsoft.Communication.CallTransferFailed") ? CallTransferFailed.fromJson(jsonReader) : (Objects.equals(eventType, "Microsoft.Communication.ParticipantsUpdated") ? ParticipantsUpdated.fromJson(jsonReader) : (Objects.equals(eventType, "Microsoft.Communication.RecordingStateChanged") ? RecordingStateChanged.fromJson(jsonReader) : (Objects.equals(eventType, "Microsoft.Communication.PlayCompleted") ? PlayCompleted.fromJson(jsonReader) : (Objects.equals(eventType, "Microsoft.Communication.PlayFailed") ? PlayFailed.fromJson(jsonReader) : (Objects.equals(eventType, "Microsoft.Communication.PlayStarted") ? PlayStarted.fromJson(jsonReader) : (Objects.equals(eventType, "Microsoft.Communication.PlayCanceled") ? PlayCanceled.fromJson(jsonReader) : (Objects.equals(eventType, "Microsoft.Communication.RecognizeCompleted") ? RecognizeCompleted.fromJson(jsonReader) : (Objects.equals(eventType, "Microsoft.Communication.RecognizeFailed") ? RecognizeFailed.fromJson(jsonReader) : (Objects.equals(eventType, "Microsoft.Communication.RecognizeCanceled") ? RecognizeCanceled.fromJson(jsonReader) : (Objects.equals(eventType, "Microsoft.Communication.RemoveParticipantFailed") ? RemoveParticipantFailed.fromJson(jsonReader) : (Objects.equals(eventType, "Microsoft.Communication.RemoveParticipantSucceeded") ? RemoveParticipantSucceeded.fromJson(jsonReader) : (Objects.equals(eventType, "Microsoft.Communication.ContinuousDtmfRecognitionToneReceived") ? ContinuousDtmfRecognitionToneReceived.fromJson(jsonReader) : (Objects.equals(eventType, "Microsoft.Communication.ContinuousDtmfRecognitionToneFailed") ? ContinuousDtmfRecognitionToneFailed.fromJson(jsonReader) : (Objects.equals(eventType, "Microsoft.Communication.ContinuousDtmfRecognitionStopped") ? ContinuousDtmfRecognitionStopped.fromJson(jsonReader) : (Objects.equals(eventType, "Microsoft.Communication.SendDtmfTonesCompleted") ? SendDtmfTonesCompleted.fromJson(jsonReader) : (Objects.equals(eventType, "Microsoft.Communication.SendDtmfTonesFailed") ? SendDtmfTonesFailed.fromJson(jsonReader) : (Objects.equals(eventType, "Microsoft.Communication.CancelAddParticipantSucceeded") ? CancelAddParticipantSucceeded.fromJson(jsonReader) : (Objects.equals(eventType, "Microsoft.Communication.CancelAddParticipantFailed") ? CancelAddParticipantFailed.fromJson(jsonReader) : (Objects.equals(eventType, "Microsoft.Communication.TranscriptionStarted") ? TranscriptionStarted.fromJson(jsonReader) : (Objects.equals(eventType, "Microsoft.Communication.TranscriptionFailed") ? TranscriptionFailed.fromJson(jsonReader) : (Objects.equals(eventType, "Microsoft.Communication.TranscriptionResumed") ? TranscriptionResumed.fromJson(jsonReader) : (Objects.equals(eventType, "Microsoft.Communication.TranscriptionStopped") ? TranscriptionStopped.fromJson(jsonReader) : (Objects.equals(eventType, "Microsoft.Communication.TranscriptionUpdated") ? TranscriptionUpdated.fromJson(jsonReader) : (Objects.equals(eventType, "Microsoft.Communication.AnswerFailed") ? AnswerFailed.fromJson(jsonReader) : (Objects.equals(eventType, "Microsoft.Communication.CreateCallFailed") ? CreateCallFailed.fromJson(jsonReader) : (Objects.equals(eventType, "Microsoft.Communication.HoldFailed") ? HoldFailed.fromJson(jsonReader) : (Objects.equals(eventType, "Microsoft.Communication.ConnectFailed") ? ConnectFailed.fromJson(jsonReader) : (Objects.equals(eventType, "Microsoft.Communication.MediaStreamingStarted") ? MediaStreamingStarted.fromJson(jsonReader) : (Objects.equals(eventType, "Microsoft.Communication.MediaStreamingStopped") ? MediaStreamingStopped.fromJson(jsonReader) : (Objects.equals(eventType, "Microsoft.Communication.MediaStreamingFailed") ? MediaStreamingFailed.fromJson(jsonReader) : null)))))))))))))))))))))))))))))))))));
                callConnected = ret;
                if (jsonReader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jsonReader != null) {
                        try {
                            jsonReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            jsonReader.close();
        }
        return callConnected;
    }
}

