/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.models;

import com.azure.communication.callautomation.implementation.accesshelpers.TranscriptionMetadataContructorProxy;
import com.azure.communication.callautomation.implementation.converters.TranscriptionMetadataConverter;
import com.azure.communication.callautomation.models.StreamingData;
import com.azure.communication.callautomation.models.StreamingDataKind;

public final class TranscriptionMetadata
extends StreamingData {
    private final String transcriptionSubscriptionId;
    private final String locale;
    private final String callConnectionId;
    private final String correlationId;
    private final String speechRecognitionModelEndpointId;

    TranscriptionMetadata(TranscriptionMetadataConverter internalData) {
        super(StreamingDataKind.TRANSCRIPTION_METADATA);
        this.transcriptionSubscriptionId = internalData.getTranscriptionSubscriptionId();
        this.locale = internalData.getLocale();
        this.callConnectionId = internalData.getCallConnectionId();
        this.correlationId = internalData.getCorrelationId();
        this.speechRecognitionModelEndpointId = internalData.getSpeechRecognitionModelEndpointId();
    }

    public String getTranscriptionSubscriptionId() {
        return this.transcriptionSubscriptionId;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getCallConnectionId() {
        return this.callConnectionId;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public String getSpeechRecognitionModelEndpointId() {
        return this.speechRecognitionModelEndpointId;
    }

    static {
        TranscriptionMetadataContructorProxy.setAccessor(new TranscriptionMetadataContructorProxy.TranscriptionMetadataContructorProxyAccessor(){

            @Override
            public TranscriptionMetadata create(TranscriptionMetadataConverter internalData) {
                return new TranscriptionMetadata(internalData);
            }
        });
    }
}

