/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.models;

import com.azure.communication.callautomation.implementation.converters.CommunicationIdentifierConverter;
import com.azure.communication.callautomation.implementation.models.CommunicationIdentifierModel;
import com.azure.communication.callautomation.models.CallMediaRecognizeOptions;
import com.azure.communication.callautomation.models.PlaySource;
import com.azure.communication.callautomation.models.RecognizeInputType;
import com.azure.communication.common.CommunicationIdentifier;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;

public class CallMediaRecognizeSpeechOptions
extends CallMediaRecognizeOptions {
    private Duration endSilenceTimeout;
    private String speechLanguage;
    private String speechRecognitionModelEndpointId;

    public Duration getEndSilenceTimeout() {
        return this.endSilenceTimeout;
    }

    @Override
    public CallMediaRecognizeSpeechOptions setRecognizeInputType(RecognizeInputType recognizeInputType) {
        super.setRecognizeInputType(recognizeInputType);
        return this;
    }

    @Override
    public CallMediaRecognizeSpeechOptions setPlayPrompt(PlaySource playPrompt) {
        super.setPlayPrompt(playPrompt);
        return this;
    }

    @Override
    public CallMediaRecognizeSpeechOptions setInterruptCallMediaOperation(Boolean interruptCallMediaOperation) {
        super.setInterruptCallMediaOperation(interruptCallMediaOperation);
        return this;
    }

    @Override
    public CallMediaRecognizeSpeechOptions setStopCurrentOperations(Boolean stopCurrentOperations) {
        super.setStopCurrentOperations(stopCurrentOperations);
        return this;
    }

    @Override
    public CallMediaRecognizeSpeechOptions setOperationContext(String operationContext) {
        super.setOperationContext(operationContext);
        return this;
    }

    @Override
    public CallMediaRecognizeSpeechOptions setInterruptPrompt(Boolean interruptPrompt) {
        super.setInterruptPrompt(interruptPrompt);
        return this;
    }

    @Override
    public CallMediaRecognizeSpeechOptions setInitialSilenceTimeout(Duration initialSilenceTimeout) {
        super.setInitialSilenceTimeout(initialSilenceTimeout);
        return this;
    }

    public CallMediaRecognizeSpeechOptions setSpeechLanguage(String speechLanguage) {
        this.speechLanguage = speechLanguage;
        return this;
    }

    public String getSpeechLanguage() {
        return this.speechLanguage;
    }

    public String getSpeechRecognitionModelEndpointId() {
        return this.speechRecognitionModelEndpointId;
    }

    public CallMediaRecognizeSpeechOptions setSpeechRecognitionModelEndpointId(String speechRecognitionModelEndpointId) {
        this.speechRecognitionModelEndpointId = speechRecognitionModelEndpointId;
        return this;
    }

    public CallMediaRecognizeSpeechOptions(CommunicationIdentifier targetParticipant, Duration endSilenceTimeout) {
        super(RecognizeInputType.SPEECH, targetParticipant);
        this.endSilenceTimeout = endSilenceTimeout;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("recognizeInputType", "speech");
        jsonWriter.writeJsonField("playPrompt", (JsonSerializable)this.getPlayPrompt());
        jsonWriter.writeArrayField("playPrompts", this.getPlayPrompts(), (writer, playPrompt) -> playPrompt.toJson(writer));
        jsonWriter.writeBooleanField("interruptCallMediaOperation", this.isInterruptCallMediaOperation());
        jsonWriter.writeBooleanField("stopCurrentOperations", this.isStopCurrentOperations());
        jsonWriter.writeStringField("operationContext", this.getOperationContext());
        jsonWriter.writeBooleanField("interruptPrompt", this.isInterruptPrompt());
        jsonWriter.writeStringField("initialSilenceTimeout", CoreUtils.durationToStringWithDays((Duration)this.getInitialSilenceTimeout()));
        jsonWriter.writeStringField("speechModelEndpointId", this.getSpeechRecognitionModelEndpointId());
        CommunicationIdentifierModel participant = CommunicationIdentifierConverter.convert(this.getTargetParticipant());
        jsonWriter.writeJsonField("targetParticipant", (JsonSerializable)participant);
        jsonWriter.writeStringField("operationCallbackUrl", this.getOperationCallbackUrl());
        jsonWriter.writeStringField("endSilenceTimeout", CoreUtils.durationToStringWithDays((Duration)this.endSilenceTimeout));
        jsonWriter.writeStringField("speechLanguage", this.speechLanguage);
        jsonWriter.writeStringField("speechRecognitionModelEndpointId", this.speechRecognitionModelEndpointId);
        return jsonWriter.writeEndObject();
    }

    public static CallMediaRecognizeSpeechOptions fromJson(JsonReader jsonReader) throws IOException {
        return (CallMediaRecognizeSpeechOptions)jsonReader.readObject(reader -> {
            Duration endSilenceTimeout = null;
            String speechLanguage = null;
            String speechRecognitionModelEndpointId = null;
            Object stopDtmfTones = null;
            String recognizeInputType = null;
            Boolean interruptCallMediaOperation = null;
            Boolean stopCurrentOperations = null;
            String operationContext = null;
            Boolean interruptPrompt = null;
            Duration initialSilenceTimeout = null;
            String speechModelEndpointId = null;
            String operationCallbackUrl = null;
            CommunicationIdentifier targetParticipant = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String value;
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("endSilenceTimeout".equals(fieldName)) {
                    value = reader.getString();
                    endSilenceTimeout = value != null ? Duration.parse(value) : null;
                    continue;
                }
                if ("speechLanguage".equals(fieldName)) {
                    speechLanguage = reader.getString();
                    continue;
                }
                if ("speechRecognitionModelEndpointId".equals(fieldName)) {
                    speechRecognitionModelEndpointId = reader.getString();
                    continue;
                }
                if ("recognizeInputType".equals(fieldName)) {
                    recognizeInputType = reader.getString();
                    continue;
                }
                if ("interruptCallMediaOperation".equals(fieldName)) {
                    interruptCallMediaOperation = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("stopCurrentOperations".equals(fieldName)) {
                    stopCurrentOperations = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("operationContext".equals(fieldName)) {
                    operationContext = reader.getString();
                    continue;
                }
                if ("interruptPrompt".equals(fieldName)) {
                    interruptPrompt = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("initialSilenceTimeout".equals(fieldName)) {
                    value = reader.getString();
                    initialSilenceTimeout = value != null ? Duration.parse(value) : null;
                    continue;
                }
                if ("speechModelEndpointId".equals(fieldName)) {
                    speechModelEndpointId = reader.getString();
                    continue;
                }
                if ("operationCallbackUrl".equals(fieldName)) {
                    operationCallbackUrl = reader.getString();
                    continue;
                }
                if ("targetParticipant".equals(fieldName)) {
                    CommunicationIdentifierModel inner = CommunicationIdentifierModel.fromJson(reader);
                    targetParticipant = CommunicationIdentifierConverter.convert(inner);
                    continue;
                }
                reader.skipChildren();
            }
            CallMediaRecognizeSpeechOptions options = new CallMediaRecognizeSpeechOptions(targetParticipant, endSilenceTimeout);
            options.speechLanguage = speechLanguage;
            options.speechRecognitionModelEndpointId = speechRecognitionModelEndpointId;
            options.setRecognizeInputType(RecognizeInputType.fromString(recognizeInputType));
            options.setInterruptCallMediaOperation(interruptCallMediaOperation);
            options.setStopCurrentOperations(stopCurrentOperations);
            options.setOperationContext(operationContext);
            options.setInterruptPrompt(interruptPrompt);
            options.setInitialSilenceTimeout(initialSilenceTimeout);
            options.setSpeechRecognitionModelEndpointId(speechModelEndpointId);
            options.setOperationCallbackUrl(operationCallbackUrl);
            return options;
        });
    }
}

