/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.models;

import com.azure.communication.callautomation.implementation.accesshelpers.AudioMetadataContructorProxy;
import com.azure.communication.callautomation.implementation.converters.AudioMetadataConverter;
import com.azure.communication.callautomation.models.AudioChannelType;
import com.azure.communication.callautomation.models.StreamingData;
import com.azure.communication.callautomation.models.StreamingDataKind;
import com.azure.core.util.logging.ClientLogger;

public final class AudioMetadata
extends StreamingData {
    private static final ClientLogger LOGGER = new ClientLogger(AudioMetadata.class);
    private final String mediaSubscriptionId;
    private final String encoding;
    private final Integer sampleRate;
    private final AudioChannelType channels;

    AudioMetadata(AudioMetadataConverter internalData) {
        super(StreamingDataKind.AUDIO_METADATA);
        this.mediaSubscriptionId = internalData.getMediaSubscriptionId();
        this.encoding = internalData.getEncoding();
        this.sampleRate = internalData.getSampleRate();
        this.channels = this.convertToChannelsEnum(internalData.getChannels());
    }

    public String getMediaSubscriptionId() {
        return this.mediaSubscriptionId;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public AudioChannelType getChannelType() {
        return this.channels;
    }

    private AudioChannelType convertToChannelsEnum(Integer channels) {
        if (1 == channels) {
            return AudioChannelType.MONO;
        }
        throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Unsupported Channels "));
    }

    static {
        AudioMetadataContructorProxy.setAccessor(new AudioMetadataContructorProxy.AudioMetadataContructorProxyAccessor(){

            @Override
            public AudioMetadata create(AudioMetadataConverter internalData) {
                return new AudioMetadata(internalData);
            }
        });
    }
}

