/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.models;

import com.azure.communication.callautomation.implementation.accesshelpers.AudioDataContructorProxy;
import com.azure.communication.callautomation.implementation.converters.AudioDataConverter;
import com.azure.communication.callautomation.models.StreamingData;
import com.azure.communication.callautomation.models.StreamingDataKind;
import com.azure.communication.common.CommunicationIdentifier;
import com.azure.core.util.BinaryData;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class AudioData
extends StreamingData {
    private final BinaryData data;
    private final OffsetDateTime timestamp;
    private final CommunicationIdentifier participant;
    private final boolean silent;

    AudioData(AudioDataConverter internalData) {
        super(StreamingDataKind.AUDIO_DATA);
        this.data = BinaryData.fromString((String)internalData.getData());
        this.timestamp = OffsetDateTime.parse(internalData.getTimestamp(), DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        this.participant = internalData.getParticipantRawID() != null && !internalData.getParticipantRawID().isEmpty() ? CommunicationIdentifier.fromRawId((String)internalData.getParticipantRawID()) : null;
        this.silent = internalData.isSilent();
    }

    AudioData(BinaryData data) {
        super(StreamingDataKind.AUDIO_DATA);
        this.data = data;
        this.timestamp = null;
        this.participant = null;
        this.silent = false;
    }

    public BinaryData getData() {
        return this.data;
    }

    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    public CommunicationIdentifier getParticipant() {
        return this.participant;
    }

    public boolean isSilent() {
        return this.silent;
    }

    static {
        AudioDataContructorProxy.setAccessor(new AudioDataContructorProxy.AudioDataContructorProxyAccessor(){

            @Override
            public AudioData create(AudioDataConverter internalData) {
                return new AudioData(internalData);
            }

            @Override
            public AudioData create(BinaryData data) {
                return new AudioData(data);
            }
        });
    }
}

