/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.implementation.models;

import com.azure.communication.callautomation.implementation.models.CommunicationIdentifierModel;
import com.azure.communication.callautomation.implementation.models.CustomCallingContext;
import com.azure.communication.callautomation.implementation.models.PhoneNumberIdentifierModel;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class TransferToParticipantRequestInternal
implements JsonSerializable<TransferToParticipantRequestInternal> {
    private CommunicationIdentifierModel targetParticipant;
    private String operationContext;
    private CommunicationIdentifierModel transferee;
    private String operationCallbackUri;
    private CustomCallingContext customCallingContext;
    private PhoneNumberIdentifierModel sourceCallerIdNumber;

    public CommunicationIdentifierModel getTargetParticipant() {
        return this.targetParticipant;
    }

    public TransferToParticipantRequestInternal setTargetParticipant(CommunicationIdentifierModel targetParticipant) {
        this.targetParticipant = targetParticipant;
        return this;
    }

    public String getOperationContext() {
        return this.operationContext;
    }

    public TransferToParticipantRequestInternal setOperationContext(String operationContext) {
        this.operationContext = operationContext;
        return this;
    }

    public CommunicationIdentifierModel getTransferee() {
        return this.transferee;
    }

    public TransferToParticipantRequestInternal setTransferee(CommunicationIdentifierModel transferee) {
        this.transferee = transferee;
        return this;
    }

    public String getOperationCallbackUri() {
        return this.operationCallbackUri;
    }

    public TransferToParticipantRequestInternal setOperationCallbackUri(String operationCallbackUri) {
        this.operationCallbackUri = operationCallbackUri;
        return this;
    }

    public CustomCallingContext getCustomCallingContext() {
        return this.customCallingContext;
    }

    public TransferToParticipantRequestInternal setCustomCallingContext(CustomCallingContext customCallingContext) {
        this.customCallingContext = customCallingContext;
        return this;
    }

    public PhoneNumberIdentifierModel getSourceCallerIdNumber() {
        return this.sourceCallerIdNumber;
    }

    public TransferToParticipantRequestInternal setSourceCallerIdNumber(PhoneNumberIdentifierModel sourceCallerIdNumber) {
        this.sourceCallerIdNumber = sourceCallerIdNumber;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("targetParticipant", (JsonSerializable)this.targetParticipant);
        jsonWriter.writeStringField("operationContext", this.operationContext);
        jsonWriter.writeJsonField("transferee", (JsonSerializable)this.transferee);
        jsonWriter.writeStringField("operationCallbackUri", this.operationCallbackUri);
        jsonWriter.writeJsonField("customCallingContext", (JsonSerializable)this.customCallingContext);
        jsonWriter.writeJsonField("sourceCallerIdNumber", (JsonSerializable)this.sourceCallerIdNumber);
        return jsonWriter.writeEndObject();
    }

    public static TransferToParticipantRequestInternal fromJson(JsonReader jsonReader) throws IOException {
        return (TransferToParticipantRequestInternal)jsonReader.readObject(reader -> {
            TransferToParticipantRequestInternal deserializedTransferToParticipantRequestInternal = new TransferToParticipantRequestInternal();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("targetParticipant".equals(fieldName)) {
                    deserializedTransferToParticipantRequestInternal.targetParticipant = CommunicationIdentifierModel.fromJson(reader);
                    continue;
                }
                if ("operationContext".equals(fieldName)) {
                    deserializedTransferToParticipantRequestInternal.operationContext = reader.getString();
                    continue;
                }
                if ("transferee".equals(fieldName)) {
                    deserializedTransferToParticipantRequestInternal.transferee = CommunicationIdentifierModel.fromJson(reader);
                    continue;
                }
                if ("operationCallbackUri".equals(fieldName)) {
                    deserializedTransferToParticipantRequestInternal.operationCallbackUri = reader.getString();
                    continue;
                }
                if ("customCallingContext".equals(fieldName)) {
                    deserializedTransferToParticipantRequestInternal.customCallingContext = CustomCallingContext.fromJson(reader);
                    continue;
                }
                if ("sourceCallerIdNumber".equals(fieldName)) {
                    deserializedTransferToParticipantRequestInternal.sourceCallerIdNumber = PhoneNumberIdentifierModel.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTransferToParticipantRequestInternal;
        });
    }
}

