/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation;

import com.azure.communication.callautomation.models.ParallelDownloadOptions;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpRange;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.ProgressListener;
import com.azure.core.util.ProgressReporter;
import com.azure.core.util.logging.ClientLogger;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.function.Function;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;
import reactor.core.scheduler.Schedulers;
import reactor.util.function.Tuple2;

class ContentDownloader {
    private final String resourceEndpoint;
    private final HttpPipeline httpPipeline;
    private final ClientLogger logger = new ClientLogger(ContentDownloader.class);

    ContentDownloader(String resourceEndpoint, HttpPipeline httpPipeline) {
        this.resourceEndpoint = resourceEndpoint;
        this.httpPipeline = httpPipeline;
    }

    Mono<Response<Void>> downloadToStreamWithResponse(String sourceUrl, OutputStream destinationStream, HttpRange httpRange, Context context) {
        return this.downloadStreamWithResponse(sourceUrl, httpRange, context).flatMap(response -> FluxUtil.writeToOutputStream((Flux)((Flux)response.getValue()), (OutputStream)destinationStream).thenReturn((Object)new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null)));
    }

    Mono<Response<Flux<ByteBuffer>>> downloadStreamWithResponse(String sourceUrl, HttpRange httpRange, Context context) {
        Mono<HttpResponse> httpResponse = this.makeDownloadRequest(sourceUrl, httpRange, context);
        return httpResponse.map(response -> {
            Flux<ByteBuffer> result = this.getFluxStream((HttpResponse)response, sourceUrl, httpRange, context);
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), result);
        });
    }

    Mono<Response<Void>> downloadToFileWithResponse(String sourceUrl, AsynchronousFileChannel destinationFile, ParallelDownloadOptions parallelDownloadOptions, Context context) {
        Function<HttpRange, Mono<Response<Flux<ByteBuffer>>>> downloadFunc = range -> this.downloadStreamWithResponse(sourceUrl, (HttpRange)range, context);
        return this.downloadFirstChunk(parallelDownloadOptions, downloadFunc).flatMap(setupTuple2 -> {
            long newCount = (Long)setupTuple2.getT1();
            int numChunks = this.calculateNumBlocks(newCount, parallelDownloadOptions.getBlockSize());
            numChunks = numChunks == 0 ? 1 : numChunks;
            Response initialResponse = (Response)setupTuple2.getT2();
            ProgressListener progressListener = parallelDownloadOptions.getProgressListener();
            ProgressReporter progressReporter = progressListener == null ? null : ProgressReporter.withProgressListener((ProgressListener)progressListener);
            return Flux.range((int)0, (int)numChunks).flatMap(chunkNum -> this.downloadChunk((Integer)chunkNum, (Response<Flux<ByteBuffer>>)initialResponse, parallelDownloadOptions, newCount, downloadFunc, response -> ContentDownloader.writeBodyToFile((Response<Flux<ByteBuffer>>)response, destinationFile, chunkNum.intValue(), parallelDownloadOptions, progressReporter == null ? null : progressReporter.createChild()).flux())).then(Mono.just((Object)new SimpleResponse(initialResponse, null)));
        });
    }

    private Flux<ByteBuffer> getFluxStream(HttpResponse httpResponse, String sourceUrl, HttpRange httpRange, Context context) {
        return FluxUtil.createRetriableDownloadFlux(() -> this.getResponseBody(httpResponse), (throwable, aLong) -> {
            HttpResponseException exception;
            if (throwable instanceof HttpResponseException && (exception = (HttpResponseException)throwable).getResponse().getStatusCode() == 416) {
                return this.makeDownloadRequest(sourceUrl, null, context).map(this::getResponseBody).flux().flatMap(flux -> flux);
            }
            HttpRange range = httpRange != null ? new HttpRange(aLong + 1L, Long.valueOf(httpRange.getLength() - aLong - 1L)) : new HttpRange(aLong + 1L);
            return this.makeDownloadRequest(sourceUrl, range, context).map(this::getResponseBody).flux().flatMap(flux -> flux);
        }, (int)4);
    }

    private Flux<ByteBuffer> getResponseBody(HttpResponse response) {
        switch (response.getStatusCode()) {
            case 200: 
            case 206: {
                return response.getBody();
            }
            case 416: {
                return FluxUtil.fluxError((ClientLogger)this.logger, (RuntimeException)new HttpResponseException(this.formatExceptionMessage(response), response));
            }
        }
        throw this.logger.logExceptionAsError((RuntimeException)new HttpResponseException(this.formatExceptionMessage(response), response));
    }

    private String formatExceptionMessage(HttpResponse httpResponse) {
        return String.format("Service Request failed!%nStatus: %s", httpResponse.getStatusCode());
    }

    private Mono<HttpResponse> makeDownloadRequest(String sourceUrl, HttpRange httpRange, Context context) {
        HttpRequest request = this.getHttpRequest(sourceUrl, httpRange);
        URL urlToSignWith = this.getUrlToSignRequestWith(sourceUrl);
        Context finalContext = context == null ? new Context((Object)"hmacSignatureURL", (Object)urlToSignWith) : context.addData((Object)"hmacSignatureURL", (Object)urlToSignWith);
        return this.httpPipeline.send(request, finalContext);
    }

    private URL getUrlToSignRequestWith(String url) {
        try {
            String path = new URL(url).getPath();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            return new URL(this.resourceEndpoint + path);
        }
        catch (MalformedURLException ex) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(ex));
        }
    }

    private HttpRequest getHttpRequest(String sourceUrl, HttpRange httpRange) {
        HttpRequest request = new HttpRequest(HttpMethod.GET, sourceUrl);
        if (null != httpRange) {
            request.setHeader("Range", httpRange.toString());
        }
        return request;
    }

    private Mono<Tuple2<Long, Response<Flux<ByteBuffer>>>> downloadFirstChunk(ParallelDownloadOptions parallelDownloadOptions, Function<HttpRange, Mono<Response<Flux<ByteBuffer>>>> downloader) {
        return downloader.apply(new HttpRange(0L, parallelDownloadOptions.getBlockSize())).subscribeOn(Schedulers.boundedElastic()).flatMap(response -> {
            long totalLength = this.extractTotalBlobLength(response.getHeaders().getValue("Content-Range"));
            return Mono.zip((Mono)Mono.just((Object)totalLength), (Mono)Mono.just((Object)response));
        });
    }

    private long extractTotalBlobLength(String contentRange) {
        return contentRange == null ? 0L : Long.parseLong(contentRange.split("/")[1]);
    }

    private int calculateNumBlocks(long dataSize, long blockLength) {
        int numBlocks = StrictMath.toIntExact(dataSize / blockLength);
        if (dataSize % blockLength != 0L) {
            ++numBlocks;
        }
        return numBlocks;
    }

    private <T> Flux<T> downloadChunk(Integer chunkNum, Response<Flux<ByteBuffer>> initialResponse, ParallelDownloadOptions parallelDownloadOptions, long newCount, Function<HttpRange, Mono<Response<Flux<ByteBuffer>>>> downloader, Function<Response<Flux<ByteBuffer>>, Flux<T>> returnTransformer) {
        if (chunkNum == 0) {
            return returnTransformer.apply(initialResponse);
        }
        long modifier = chunkNum.longValue() * parallelDownloadOptions.getBlockSize();
        long chunkSizeActual = Math.min(parallelDownloadOptions.getBlockSize(), newCount - modifier);
        HttpRange chunkRange = new HttpRange(modifier, Long.valueOf(chunkSizeActual));
        return downloader.apply(chunkRange).subscribeOn(Schedulers.boundedElastic()).flatMapMany(returnTransformer);
    }

    private static Mono<Void> writeBodyToFile(Response<Flux<ByteBuffer>> response, AsynchronousFileChannel file, long chunkNum, ParallelDownloadOptions parallelDownloadOptions, ProgressReporter progressReporter) {
        Flux<ByteBuffer> data = (Flux<ByteBuffer>)response.getValue();
        if (progressReporter != null) {
            data = ContentDownloader.addProgressReporting(data, progressReporter);
        }
        return FluxUtil.writeFile(data, (AsynchronousFileChannel)file, (long)(chunkNum * parallelDownloadOptions.getBlockSize()));
    }

    private static Flux<ByteBuffer> addProgressReporting(Flux<ByteBuffer> data, ProgressReporter progressReporter) {
        return Mono.just((Object)progressReporter).flatMapMany(reporter -> {
            reporter.reset();
            return data.doOnNext(buffer -> progressReporter.reportProgress((long)buffer.remaining()));
        });
    }

    void downloadToFileCleanup(AsynchronousFileChannel channel, Path filePath, SignalType signalType) {
        try {
            channel.close();
            if (!signalType.equals((Object)SignalType.ON_COMPLETE)) {
                Files.deleteIfExists(filePath);
                this.logger.verbose("Downloading to file failed. Cleaning up resources.");
            }
        }
        catch (IOException e) {
            throw this.logger.logExceptionAsError((RuntimeException)new UncheckedIOException(e));
        }
    }
}

