/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation;

import com.azure.communication.callautomation.CallAutomationAsyncClient;
import com.azure.communication.callautomation.CallAutomationClientBuilder;
import com.azure.communication.callautomation.CallConnection;
import com.azure.communication.callautomation.CallRecording;
import com.azure.communication.callautomation.models.AnswerCallOptions;
import com.azure.communication.callautomation.models.AnswerCallResult;
import com.azure.communication.callautomation.models.CallInvite;
import com.azure.communication.callautomation.models.CallLocator;
import com.azure.communication.callautomation.models.ConnectCallOptions;
import com.azure.communication.callautomation.models.ConnectCallResult;
import com.azure.communication.callautomation.models.CreateCallOptions;
import com.azure.communication.callautomation.models.CreateCallResult;
import com.azure.communication.callautomation.models.CreateGroupCallOptions;
import com.azure.communication.callautomation.models.RedirectCallOptions;
import com.azure.communication.callautomation.models.RejectCallOptions;
import com.azure.communication.common.CommunicationIdentifier;
import com.azure.communication.common.CommunicationUserIdentifier;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import java.util.List;

@ServiceClient(builder=CallAutomationClientBuilder.class)
public final class CallAutomationClient {
    private final CallAutomationAsyncClient callAutomationAsyncClient;

    CallAutomationClient(CallAutomationAsyncClient callAutomationAsyncClient) {
        this.callAutomationAsyncClient = callAutomationAsyncClient;
    }

    public CommunicationUserIdentifier getSourceIdentity() {
        return this.callAutomationAsyncClient.getSourceIdentity();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CreateCallResult createCall(CallInvite targetParticipant, String callbackUrl) {
        return (CreateCallResult)this.callAutomationAsyncClient.createCall(targetParticipant, callbackUrl).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CreateCallResult createGroupCall(List<CommunicationIdentifier> targetParticipants, String callbackUrl) {
        return (CreateCallResult)this.callAutomationAsyncClient.createGroupCall(targetParticipants, callbackUrl).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CreateCallResult> createCallWithResponse(CreateCallOptions createCallOptions, Context context) {
        return (Response)this.callAutomationAsyncClient.createCallWithResponseInternal(createCallOptions, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CreateCallResult> createGroupCallWithResponse(CreateGroupCallOptions createGroupCallOptions, Context context) {
        return (Response)this.callAutomationAsyncClient.createGroupCallWithResponseInternal(createGroupCallOptions, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AnswerCallResult answerCall(String incomingCallContext, String callbackUrl) {
        return (AnswerCallResult)this.callAutomationAsyncClient.answerCall(incomingCallContext, callbackUrl).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AnswerCallResult> answerCallWithResponse(AnswerCallOptions answerCallOptions, Context context) {
        return (Response)this.callAutomationAsyncClient.answerCallWithResponseInternal(answerCallOptions, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void redirectCall(String incomingCallContext, CallInvite targetParticipant) {
        this.callAutomationAsyncClient.redirectCall(incomingCallContext, targetParticipant).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> redirectCallWithResponse(RedirectCallOptions redirectCallOptions, Context context) {
        return (Response)this.callAutomationAsyncClient.redirectCallWithResponseInternal(redirectCallOptions, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void rejectCall(String incomingCallContext) {
        this.callAutomationAsyncClient.rejectCall(incomingCallContext).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> rejectCallWithResponse(RejectCallOptions rejectCallOptions, Context context) {
        return (Response)this.callAutomationAsyncClient.rejectCallWithResponseInternal(rejectCallOptions, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConnectCallResult connectCall(CallLocator callLocator, String callbackUrl) {
        return (ConnectCallResult)this.callAutomationAsyncClient.connectCall(callLocator, callbackUrl).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ConnectCallResult> connectCallWithResponse(ConnectCallOptions connectCallOptions, Context context) {
        return (Response)this.callAutomationAsyncClient.connectCallWithResponseInternal(connectCallOptions, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CallConnection getCallConnection(String callConnectionId) {
        return new CallConnection(this.callAutomationAsyncClient.getCallConnectionAsync(callConnectionId));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CallRecording getCallRecording() {
        return new CallRecording(this.callAutomationAsyncClient.getCallRecordingAsync());
    }
}

