/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.models.events;

import com.azure.communication.callautomation.models.RecordingState;
import com.azure.communication.callautomation.models.events.CallAutomationEventBase;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class RecordingStateChanged
extends CallAutomationEventBase {
    @JsonProperty(value="recordingId")
    private final String recordingId;
    @JsonProperty(value="state")
    private final RecordingState recordingState;
    @JsonIgnore
    private final OffsetDateTime startDateTime;

    @JsonCreator
    private RecordingStateChanged(@JsonProperty(value="startDateTime") String startDateTime) {
        this.startDateTime = OffsetDateTime.parse(startDateTime, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        this.recordingId = null;
        this.recordingState = null;
    }

    public String getRecordingId() {
        return this.recordingId;
    }

    public RecordingState getRecordingState() {
        return this.recordingState;
    }

    public OffsetDateTime getStartDateTime() {
        return this.startDateTime;
    }
}

