/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.implementation;

import com.azure.communication.callautomation.implementation.AzureCommunicationCallAutomationServiceImpl;
import com.azure.communication.callautomation.implementation.models.CommunicationErrorResponseException;
import com.azure.communication.callautomation.implementation.models.RecordingStateResponseInternal;
import com.azure.communication.callautomation.implementation.models.StartCallRecordingRequestInternal;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import java.time.OffsetDateTime;
import java.util.UUID;
import reactor.core.publisher.Mono;

public final class CallRecordingsImpl {
    private final CallRecordingsService service;
    private final AzureCommunicationCallAutomationServiceImpl client;

    CallRecordingsImpl(AzureCommunicationCallAutomationServiceImpl client) {
        this.service = (CallRecordingsService)RestProxy.create(CallRecordingsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RecordingStateResponseInternal>> startRecordingWithResponseAsync(StartCallRecordingRequestInternal startCallRecording, UUID repeatabilityRequestID, OffsetDateTime repeatabilityFirstSent) {
        String accept = "application/json";
        DateTimeRfc1123 repeatabilityFirstSentConverted = repeatabilityFirstSent == null ? null : new DateTimeRfc1123(repeatabilityFirstSent);
        return FluxUtil.withContext(context -> this.service.startRecording(this.client.getEndpoint(), this.client.getApiVersion(), repeatabilityRequestID, repeatabilityFirstSentConverted, startCallRecording, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RecordingStateResponseInternal>> startRecordingWithResponseAsync(StartCallRecordingRequestInternal startCallRecording, UUID repeatabilityRequestID, OffsetDateTime repeatabilityFirstSent, Context context) {
        String accept = "application/json";
        DateTimeRfc1123 repeatabilityFirstSentConverted = repeatabilityFirstSent == null ? null : new DateTimeRfc1123(repeatabilityFirstSent);
        return this.service.startRecording(this.client.getEndpoint(), this.client.getApiVersion(), repeatabilityRequestID, repeatabilityFirstSentConverted, startCallRecording, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RecordingStateResponseInternal> startRecordingAsync(StartCallRecordingRequestInternal startCallRecording, UUID repeatabilityRequestID, OffsetDateTime repeatabilityFirstSent) {
        return this.startRecordingWithResponseAsync(startCallRecording, repeatabilityRequestID, repeatabilityFirstSent).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((RecordingStateResponseInternal)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RecordingStateResponseInternal> startRecordingAsync(StartCallRecordingRequestInternal startCallRecording, UUID repeatabilityRequestID, OffsetDateTime repeatabilityFirstSent, Context context) {
        return this.startRecordingWithResponseAsync(startCallRecording, repeatabilityRequestID, repeatabilityFirstSent, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((RecordingStateResponseInternal)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RecordingStateResponseInternal startRecording(StartCallRecordingRequestInternal startCallRecording, UUID repeatabilityRequestID, OffsetDateTime repeatabilityFirstSent) {
        return (RecordingStateResponseInternal)this.startRecordingAsync(startCallRecording, repeatabilityRequestID, repeatabilityFirstSent).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RecordingStateResponseInternal> startRecordingWithResponse(StartCallRecordingRequestInternal startCallRecording, UUID repeatabilityRequestID, OffsetDateTime repeatabilityFirstSent, Context context) {
        return (Response)this.startRecordingWithResponseAsync(startCallRecording, repeatabilityRequestID, repeatabilityFirstSent, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RecordingStateResponseInternal>> getRecordingPropertiesWithResponseAsync(String recordingId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getRecordingProperties(this.client.getEndpoint(), recordingId, this.client.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RecordingStateResponseInternal>> getRecordingPropertiesWithResponseAsync(String recordingId, Context context) {
        String accept = "application/json";
        return this.service.getRecordingProperties(this.client.getEndpoint(), recordingId, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RecordingStateResponseInternal> getRecordingPropertiesAsync(String recordingId) {
        return this.getRecordingPropertiesWithResponseAsync(recordingId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((RecordingStateResponseInternal)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RecordingStateResponseInternal> getRecordingPropertiesAsync(String recordingId, Context context) {
        return this.getRecordingPropertiesWithResponseAsync(recordingId, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((RecordingStateResponseInternal)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RecordingStateResponseInternal getRecordingProperties(String recordingId) {
        return (RecordingStateResponseInternal)this.getRecordingPropertiesAsync(recordingId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RecordingStateResponseInternal> getRecordingPropertiesWithResponse(String recordingId, Context context) {
        return (Response)this.getRecordingPropertiesWithResponseAsync(recordingId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> stopRecordingWithResponseAsync(String recordingId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.stopRecording(this.client.getEndpoint(), recordingId, this.client.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> stopRecordingWithResponseAsync(String recordingId, Context context) {
        String accept = "application/json";
        return this.service.stopRecording(this.client.getEndpoint(), recordingId, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> stopRecordingAsync(String recordingId) {
        return this.stopRecordingWithResponseAsync(recordingId).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> stopRecordingAsync(String recordingId, Context context) {
        return this.stopRecordingWithResponseAsync(recordingId, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void stopRecording(String recordingId) {
        this.stopRecordingAsync(recordingId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> stopRecordingWithResponse(String recordingId, Context context) {
        return (Response)this.stopRecordingWithResponseAsync(recordingId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> pauseRecordingWithResponseAsync(String recordingId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.pauseRecording(this.client.getEndpoint(), recordingId, this.client.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> pauseRecordingWithResponseAsync(String recordingId, Context context) {
        String accept = "application/json";
        return this.service.pauseRecording(this.client.getEndpoint(), recordingId, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> pauseRecordingAsync(String recordingId) {
        return this.pauseRecordingWithResponseAsync(recordingId).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> pauseRecordingAsync(String recordingId, Context context) {
        return this.pauseRecordingWithResponseAsync(recordingId, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void pauseRecording(String recordingId) {
        this.pauseRecordingAsync(recordingId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> pauseRecordingWithResponse(String recordingId, Context context) {
        return (Response)this.pauseRecordingWithResponseAsync(recordingId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> resumeRecordingWithResponseAsync(String recordingId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.resumeRecording(this.client.getEndpoint(), recordingId, this.client.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> resumeRecordingWithResponseAsync(String recordingId, Context context) {
        String accept = "application/json";
        return this.service.resumeRecording(this.client.getEndpoint(), recordingId, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> resumeRecordingAsync(String recordingId) {
        return this.resumeRecordingWithResponseAsync(recordingId).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> resumeRecordingAsync(String recordingId, Context context) {
        return this.resumeRecordingWithResponseAsync(recordingId, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void resumeRecording(String recordingId) {
        this.resumeRecordingAsync(recordingId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> resumeRecordingWithResponse(String recordingId, Context context) {
        return (Response)this.resumeRecordingWithResponseAsync(recordingId, context).block();
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="AzureCommunicationCa")
    public static interface CallRecordingsService {
        @Post(value="/calling/recordings")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<RecordingStateResponseInternal>> startRecording(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Repeatability-Request-ID") UUID var3, @HeaderParam(value="Repeatability-First-Sent") DateTimeRfc1123 var4, @BodyParam(value="application/json") StartCallRecordingRequestInternal var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Get(value="/calling/recordings/{recordingId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<RecordingStateResponseInternal>> getRecordingProperties(@HostParam(value="endpoint") String var1, @PathParam(value="recordingId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Delete(value="/calling/recordings/{recordingId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<Void>> stopRecording(@HostParam(value="endpoint") String var1, @PathParam(value="recordingId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/calling/recordings/{recordingId}:pause")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<Void>> pauseRecording(@HostParam(value="endpoint") String var1, @PathParam(value="recordingId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/calling/recordings/{recordingId}:resume")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<Void>> resumeRecording(@HostParam(value="endpoint") String var1, @PathParam(value="recordingId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);
    }
}

