/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.implementation;

import com.azure.communication.callautomation.implementation.AzureCommunicationCallAutomationServiceImpl;
import com.azure.communication.callautomation.implementation.models.CommunicationErrorResponseException;
import com.azure.communication.callautomation.implementation.models.PlayRequest;
import com.azure.communication.callautomation.implementation.models.RecognizeRequest;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import reactor.core.publisher.Mono;

public final class CallMediasImpl {
    private final CallMediasService service;
    private final AzureCommunicationCallAutomationServiceImpl client;

    CallMediasImpl(AzureCommunicationCallAutomationServiceImpl client) {
        this.service = (CallMediasService)RestProxy.create(CallMediasService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> playWithResponseAsync(String callConnectionId, PlayRequest playRequest) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.play(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), playRequest, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> playWithResponseAsync(String callConnectionId, PlayRequest playRequest, Context context) {
        String accept = "application/json";
        return this.service.play(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), playRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> playAsync(String callConnectionId, PlayRequest playRequest) {
        return this.playWithResponseAsync(callConnectionId, playRequest).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> playAsync(String callConnectionId, PlayRequest playRequest, Context context) {
        return this.playWithResponseAsync(callConnectionId, playRequest, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void play(String callConnectionId, PlayRequest playRequest) {
        this.playAsync(callConnectionId, playRequest).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> playWithResponse(String callConnectionId, PlayRequest playRequest, Context context) {
        return (Response)this.playWithResponseAsync(callConnectionId, playRequest, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> cancelAllMediaOperationsWithResponseAsync(String callConnectionId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.cancelAllMediaOperations(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> cancelAllMediaOperationsWithResponseAsync(String callConnectionId, Context context) {
        String accept = "application/json";
        return this.service.cancelAllMediaOperations(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> cancelAllMediaOperationsAsync(String callConnectionId) {
        return this.cancelAllMediaOperationsWithResponseAsync(callConnectionId).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> cancelAllMediaOperationsAsync(String callConnectionId, Context context) {
        return this.cancelAllMediaOperationsWithResponseAsync(callConnectionId, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void cancelAllMediaOperations(String callConnectionId) {
        this.cancelAllMediaOperationsAsync(callConnectionId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> cancelAllMediaOperationsWithResponse(String callConnectionId, Context context) {
        return (Response)this.cancelAllMediaOperationsWithResponseAsync(callConnectionId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> recognizeWithResponseAsync(String callConnectionId, RecognizeRequest recognizeRequest) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.recognize(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), recognizeRequest, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> recognizeWithResponseAsync(String callConnectionId, RecognizeRequest recognizeRequest, Context context) {
        String accept = "application/json";
        return this.service.recognize(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), recognizeRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> recognizeAsync(String callConnectionId, RecognizeRequest recognizeRequest) {
        return this.recognizeWithResponseAsync(callConnectionId, recognizeRequest).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> recognizeAsync(String callConnectionId, RecognizeRequest recognizeRequest, Context context) {
        return this.recognizeWithResponseAsync(callConnectionId, recognizeRequest, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void recognize(String callConnectionId, RecognizeRequest recognizeRequest) {
        this.recognizeAsync(callConnectionId, recognizeRequest).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> recognizeWithResponse(String callConnectionId, RecognizeRequest recognizeRequest, Context context) {
        return (Response)this.recognizeWithResponseAsync(callConnectionId, recognizeRequest, context).block();
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="AzureCommunicationCa")
    public static interface CallMediasService {
        @Post(value="/calling/callConnections/{callConnectionId}:play")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<Void>> play(@HostParam(value="endpoint") String var1, @PathParam(value="callConnectionId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") PlayRequest var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/calling/callConnections/{callConnectionId}:cancelAllMediaOperations")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<Void>> cancelAllMediaOperations(@HostParam(value="endpoint") String var1, @PathParam(value="callConnectionId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/calling/callConnections/{callConnectionId}:recognize")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<Void>> recognize(@HostParam(value="endpoint") String var1, @PathParam(value="callConnectionId") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") RecognizeRequest var4, @HeaderParam(value="Accept") String var5, Context var6);
    }
}

