/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.implementation;

import com.azure.communication.callautomation.implementation.AzureCommunicationCallAutomationServiceImpl;
import com.azure.communication.callautomation.implementation.models.AddParticipantRequestInternal;
import com.azure.communication.callautomation.implementation.models.AddParticipantResponseInternal;
import com.azure.communication.callautomation.implementation.models.CallConnectionPropertiesInternal;
import com.azure.communication.callautomation.implementation.models.CallParticipantInternal;
import com.azure.communication.callautomation.implementation.models.CommunicationErrorResponseException;
import com.azure.communication.callautomation.implementation.models.GetParticipantsResponseInternal;
import com.azure.communication.callautomation.implementation.models.RemoveParticipantRequestInternal;
import com.azure.communication.callautomation.implementation.models.RemoveParticipantResponseInternal;
import com.azure.communication.callautomation.implementation.models.TransferCallResponseInternal;
import com.azure.communication.callautomation.implementation.models.TransferToParticipantRequestInternal;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import java.time.OffsetDateTime;
import java.util.UUID;
import reactor.core.publisher.Mono;

public final class CallConnectionsImpl {
    private final CallConnectionsService service;
    private final AzureCommunicationCallAutomationServiceImpl client;

    CallConnectionsImpl(AzureCommunicationCallAutomationServiceImpl client) {
        this.service = (CallConnectionsService)RestProxy.create(CallConnectionsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CallConnectionPropertiesInternal>> getCallWithResponseAsync(String callConnectionId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getCall(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CallConnectionPropertiesInternal>> getCallWithResponseAsync(String callConnectionId, Context context) {
        String accept = "application/json";
        return this.service.getCall(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CallConnectionPropertiesInternal> getCallAsync(String callConnectionId) {
        return this.getCallWithResponseAsync(callConnectionId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((CallConnectionPropertiesInternal)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CallConnectionPropertiesInternal> getCallAsync(String callConnectionId, Context context) {
        return this.getCallWithResponseAsync(callConnectionId, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((CallConnectionPropertiesInternal)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CallConnectionPropertiesInternal getCall(String callConnectionId) {
        return (CallConnectionPropertiesInternal)this.getCallAsync(callConnectionId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CallConnectionPropertiesInternal> getCallWithResponse(String callConnectionId, Context context) {
        return (Response)this.getCallWithResponseAsync(callConnectionId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> hangupCallWithResponseAsync(String callConnectionId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.hangupCall(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> hangupCallWithResponseAsync(String callConnectionId, Context context) {
        String accept = "application/json";
        return this.service.hangupCall(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> hangupCallAsync(String callConnectionId) {
        return this.hangupCallWithResponseAsync(callConnectionId).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> hangupCallAsync(String callConnectionId, Context context) {
        return this.hangupCallWithResponseAsync(callConnectionId, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void hangupCall(String callConnectionId) {
        this.hangupCallAsync(callConnectionId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> hangupCallWithResponse(String callConnectionId, Context context) {
        return (Response)this.hangupCallWithResponseAsync(callConnectionId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> terminateCallWithResponseAsync(String callConnectionId, UUID repeatabilityRequestID, OffsetDateTime repeatabilityFirstSent) {
        String accept = "application/json";
        DateTimeRfc1123 repeatabilityFirstSentConverted = repeatabilityFirstSent == null ? null : new DateTimeRfc1123(repeatabilityFirstSent);
        return FluxUtil.withContext(context -> this.service.terminateCall(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), repeatabilityRequestID, repeatabilityFirstSentConverted, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> terminateCallWithResponseAsync(String callConnectionId, UUID repeatabilityRequestID, OffsetDateTime repeatabilityFirstSent, Context context) {
        String accept = "application/json";
        DateTimeRfc1123 repeatabilityFirstSentConverted = repeatabilityFirstSent == null ? null : new DateTimeRfc1123(repeatabilityFirstSent);
        return this.service.terminateCall(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), repeatabilityRequestID, repeatabilityFirstSentConverted, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> terminateCallAsync(String callConnectionId, UUID repeatabilityRequestID, OffsetDateTime repeatabilityFirstSent) {
        return this.terminateCallWithResponseAsync(callConnectionId, repeatabilityRequestID, repeatabilityFirstSent).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> terminateCallAsync(String callConnectionId, UUID repeatabilityRequestID, OffsetDateTime repeatabilityFirstSent, Context context) {
        return this.terminateCallWithResponseAsync(callConnectionId, repeatabilityRequestID, repeatabilityFirstSent, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void terminateCall(String callConnectionId, UUID repeatabilityRequestID, OffsetDateTime repeatabilityFirstSent) {
        this.terminateCallAsync(callConnectionId, repeatabilityRequestID, repeatabilityFirstSent).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> terminateCallWithResponse(String callConnectionId, UUID repeatabilityRequestID, OffsetDateTime repeatabilityFirstSent, Context context) {
        return (Response)this.terminateCallWithResponseAsync(callConnectionId, repeatabilityRequestID, repeatabilityFirstSent, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<TransferCallResponseInternal>> transferToParticipantWithResponseAsync(String callConnectionId, TransferToParticipantRequestInternal transferToParticipantRequest, UUID repeatabilityRequestID, OffsetDateTime repeatabilityFirstSent) {
        String accept = "application/json";
        DateTimeRfc1123 repeatabilityFirstSentConverted = repeatabilityFirstSent == null ? null : new DateTimeRfc1123(repeatabilityFirstSent);
        return FluxUtil.withContext(context -> this.service.transferToParticipant(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), repeatabilityRequestID, repeatabilityFirstSentConverted, transferToParticipantRequest, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<TransferCallResponseInternal>> transferToParticipantWithResponseAsync(String callConnectionId, TransferToParticipantRequestInternal transferToParticipantRequest, UUID repeatabilityRequestID, OffsetDateTime repeatabilityFirstSent, Context context) {
        String accept = "application/json";
        DateTimeRfc1123 repeatabilityFirstSentConverted = repeatabilityFirstSent == null ? null : new DateTimeRfc1123(repeatabilityFirstSent);
        return this.service.transferToParticipant(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), repeatabilityRequestID, repeatabilityFirstSentConverted, transferToParticipantRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TransferCallResponseInternal> transferToParticipantAsync(String callConnectionId, TransferToParticipantRequestInternal transferToParticipantRequest, UUID repeatabilityRequestID, OffsetDateTime repeatabilityFirstSent) {
        return this.transferToParticipantWithResponseAsync(callConnectionId, transferToParticipantRequest, repeatabilityRequestID, repeatabilityFirstSent).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((TransferCallResponseInternal)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TransferCallResponseInternal> transferToParticipantAsync(String callConnectionId, TransferToParticipantRequestInternal transferToParticipantRequest, UUID repeatabilityRequestID, OffsetDateTime repeatabilityFirstSent, Context context) {
        return this.transferToParticipantWithResponseAsync(callConnectionId, transferToParticipantRequest, repeatabilityRequestID, repeatabilityFirstSent, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((TransferCallResponseInternal)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TransferCallResponseInternal transferToParticipant(String callConnectionId, TransferToParticipantRequestInternal transferToParticipantRequest, UUID repeatabilityRequestID, OffsetDateTime repeatabilityFirstSent) {
        return (TransferCallResponseInternal)this.transferToParticipantAsync(callConnectionId, transferToParticipantRequest, repeatabilityRequestID, repeatabilityFirstSent).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TransferCallResponseInternal> transferToParticipantWithResponse(String callConnectionId, TransferToParticipantRequestInternal transferToParticipantRequest, UUID repeatabilityRequestID, OffsetDateTime repeatabilityFirstSent, Context context) {
        return (Response)this.transferToParticipantWithResponseAsync(callConnectionId, transferToParticipantRequest, repeatabilityRequestID, repeatabilityFirstSent, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<CallParticipantInternal>> getParticipantsSinglePageAsync(String callConnectionId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getParticipants(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetParticipantsResponseInternal)res.getValue()).getValue(), ((GetParticipantsResponseInternal)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<CallParticipantInternal>> getParticipantsSinglePageAsync(String callConnectionId, Context context) {
        String accept = "application/json";
        return this.service.getParticipants(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetParticipantsResponseInternal)res.getValue()).getValue(), ((GetParticipantsResponseInternal)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<CallParticipantInternal> getParticipantsAsync(String callConnectionId) {
        return new PagedFlux(() -> this.getParticipantsSinglePageAsync(callConnectionId), nextLink -> this.getParticipantsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<CallParticipantInternal> getParticipantsAsync(String callConnectionId, Context context) {
        return new PagedFlux(() -> this.getParticipantsSinglePageAsync(callConnectionId, context), nextLink -> this.getParticipantsNextSinglePageAsync((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CallParticipantInternal> getParticipants(String callConnectionId) {
        return new PagedIterable(this.getParticipantsAsync(callConnectionId));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CallParticipantInternal> getParticipants(String callConnectionId, Context context) {
        return new PagedIterable(this.getParticipantsAsync(callConnectionId, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AddParticipantResponseInternal>> addParticipantWithResponseAsync(String callConnectionId, AddParticipantRequestInternal addParticipantRequest, UUID repeatabilityRequestID, OffsetDateTime repeatabilityFirstSent) {
        String accept = "application/json";
        DateTimeRfc1123 repeatabilityFirstSentConverted = repeatabilityFirstSent == null ? null : new DateTimeRfc1123(repeatabilityFirstSent);
        return FluxUtil.withContext(context -> this.service.addParticipant(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), repeatabilityRequestID, repeatabilityFirstSentConverted, addParticipantRequest, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AddParticipantResponseInternal>> addParticipantWithResponseAsync(String callConnectionId, AddParticipantRequestInternal addParticipantRequest, UUID repeatabilityRequestID, OffsetDateTime repeatabilityFirstSent, Context context) {
        String accept = "application/json";
        DateTimeRfc1123 repeatabilityFirstSentConverted = repeatabilityFirstSent == null ? null : new DateTimeRfc1123(repeatabilityFirstSent);
        return this.service.addParticipant(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), repeatabilityRequestID, repeatabilityFirstSentConverted, addParticipantRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AddParticipantResponseInternal> addParticipantAsync(String callConnectionId, AddParticipantRequestInternal addParticipantRequest, UUID repeatabilityRequestID, OffsetDateTime repeatabilityFirstSent) {
        return this.addParticipantWithResponseAsync(callConnectionId, addParticipantRequest, repeatabilityRequestID, repeatabilityFirstSent).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((AddParticipantResponseInternal)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AddParticipantResponseInternal> addParticipantAsync(String callConnectionId, AddParticipantRequestInternal addParticipantRequest, UUID repeatabilityRequestID, OffsetDateTime repeatabilityFirstSent, Context context) {
        return this.addParticipantWithResponseAsync(callConnectionId, addParticipantRequest, repeatabilityRequestID, repeatabilityFirstSent, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((AddParticipantResponseInternal)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AddParticipantResponseInternal addParticipant(String callConnectionId, AddParticipantRequestInternal addParticipantRequest, UUID repeatabilityRequestID, OffsetDateTime repeatabilityFirstSent) {
        return (AddParticipantResponseInternal)this.addParticipantAsync(callConnectionId, addParticipantRequest, repeatabilityRequestID, repeatabilityFirstSent).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AddParticipantResponseInternal> addParticipantWithResponse(String callConnectionId, AddParticipantRequestInternal addParticipantRequest, UUID repeatabilityRequestID, OffsetDateTime repeatabilityFirstSent, Context context) {
        return (Response)this.addParticipantWithResponseAsync(callConnectionId, addParticipantRequest, repeatabilityRequestID, repeatabilityFirstSent, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RemoveParticipantResponseInternal>> removeParticipantWithResponseAsync(String callConnectionId, RemoveParticipantRequestInternal removeParticipantRequest, UUID repeatabilityRequestID, OffsetDateTime repeatabilityFirstSent) {
        String accept = "application/json";
        DateTimeRfc1123 repeatabilityFirstSentConverted = repeatabilityFirstSent == null ? null : new DateTimeRfc1123(repeatabilityFirstSent);
        return FluxUtil.withContext(context -> this.service.removeParticipant(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), repeatabilityRequestID, repeatabilityFirstSentConverted, removeParticipantRequest, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RemoveParticipantResponseInternal>> removeParticipantWithResponseAsync(String callConnectionId, RemoveParticipantRequestInternal removeParticipantRequest, UUID repeatabilityRequestID, OffsetDateTime repeatabilityFirstSent, Context context) {
        String accept = "application/json";
        DateTimeRfc1123 repeatabilityFirstSentConverted = repeatabilityFirstSent == null ? null : new DateTimeRfc1123(repeatabilityFirstSent);
        return this.service.removeParticipant(this.client.getEndpoint(), callConnectionId, this.client.getApiVersion(), repeatabilityRequestID, repeatabilityFirstSentConverted, removeParticipantRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RemoveParticipantResponseInternal> removeParticipantAsync(String callConnectionId, RemoveParticipantRequestInternal removeParticipantRequest, UUID repeatabilityRequestID, OffsetDateTime repeatabilityFirstSent) {
        return this.removeParticipantWithResponseAsync(callConnectionId, removeParticipantRequest, repeatabilityRequestID, repeatabilityFirstSent).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((RemoveParticipantResponseInternal)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RemoveParticipantResponseInternal> removeParticipantAsync(String callConnectionId, RemoveParticipantRequestInternal removeParticipantRequest, UUID repeatabilityRequestID, OffsetDateTime repeatabilityFirstSent, Context context) {
        return this.removeParticipantWithResponseAsync(callConnectionId, removeParticipantRequest, repeatabilityRequestID, repeatabilityFirstSent, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((RemoveParticipantResponseInternal)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RemoveParticipantResponseInternal removeParticipant(String callConnectionId, RemoveParticipantRequestInternal removeParticipantRequest, UUID repeatabilityRequestID, OffsetDateTime repeatabilityFirstSent) {
        return (RemoveParticipantResponseInternal)this.removeParticipantAsync(callConnectionId, removeParticipantRequest, repeatabilityRequestID, repeatabilityFirstSent).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RemoveParticipantResponseInternal> removeParticipantWithResponse(String callConnectionId, RemoveParticipantRequestInternal removeParticipantRequest, UUID repeatabilityRequestID, OffsetDateTime repeatabilityFirstSent, Context context) {
        return (Response)this.removeParticipantWithResponseAsync(callConnectionId, removeParticipantRequest, repeatabilityRequestID, repeatabilityFirstSent, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CallParticipantInternal>> getParticipantWithResponseAsync(String callConnectionId, String participantRawId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getParticipant(this.client.getEndpoint(), callConnectionId, participantRawId, this.client.getApiVersion(), "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CallParticipantInternal>> getParticipantWithResponseAsync(String callConnectionId, String participantRawId, Context context) {
        String accept = "application/json";
        return this.service.getParticipant(this.client.getEndpoint(), callConnectionId, participantRawId, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CallParticipantInternal> getParticipantAsync(String callConnectionId, String participantRawId) {
        return this.getParticipantWithResponseAsync(callConnectionId, participantRawId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((CallParticipantInternal)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CallParticipantInternal> getParticipantAsync(String callConnectionId, String participantRawId, Context context) {
        return this.getParticipantWithResponseAsync(callConnectionId, participantRawId, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((CallParticipantInternal)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CallParticipantInternal getParticipant(String callConnectionId, String participantRawId) {
        return (CallParticipantInternal)this.getParticipantAsync(callConnectionId, participantRawId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CallParticipantInternal> getParticipantWithResponse(String callConnectionId, String participantRawId, Context context) {
        return (Response)this.getParticipantWithResponseAsync(callConnectionId, participantRawId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<CallParticipantInternal>> getParticipantsNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getParticipantsNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetParticipantsResponseInternal)res.getValue()).getValue(), ((GetParticipantsResponseInternal)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<CallParticipantInternal>> getParticipantsNextSinglePageAsync(String nextLink, Context context) {
        String accept = "application/json";
        return this.service.getParticipantsNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GetParticipantsResponseInternal)res.getValue()).getValue(), ((GetParticipantsResponseInternal)res.getValue()).getNextLink(), null));
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="AzureCommunicationCa")
    public static interface CallConnectionsService {
        @Get(value="/calling/callConnections/{callConnectionId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<CallConnectionPropertiesInternal>> getCall(@HostParam(value="endpoint") String var1, @PathParam(value="callConnectionId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Delete(value="/calling/callConnections/{callConnectionId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<Void>> hangupCall(@HostParam(value="endpoint") String var1, @PathParam(value="callConnectionId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/calling/callConnections/{callConnectionId}:terminate")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<Void>> terminateCall(@HostParam(value="endpoint") String var1, @PathParam(value="callConnectionId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Repeatability-Request-ID") UUID var4, @HeaderParam(value="Repeatability-First-Sent") DateTimeRfc1123 var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Post(value="/calling/callConnections/{callConnectionId}:transferToParticipant")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<TransferCallResponseInternal>> transferToParticipant(@HostParam(value="endpoint") String var1, @PathParam(value="callConnectionId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Repeatability-Request-ID") UUID var4, @HeaderParam(value="Repeatability-First-Sent") DateTimeRfc1123 var5, @BodyParam(value="application/json") TransferToParticipantRequestInternal var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/calling/callConnections/{callConnectionId}/participants")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<GetParticipantsResponseInternal>> getParticipants(@HostParam(value="endpoint") String var1, @PathParam(value="callConnectionId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/calling/callConnections/{callConnectionId}/participants:add")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<AddParticipantResponseInternal>> addParticipant(@HostParam(value="endpoint") String var1, @PathParam(value="callConnectionId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Repeatability-Request-ID") UUID var4, @HeaderParam(value="Repeatability-First-Sent") DateTimeRfc1123 var5, @BodyParam(value="application/json") AddParticipantRequestInternal var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Post(value="/calling/callConnections/{callConnectionId}/participants:remove")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<RemoveParticipantResponseInternal>> removeParticipant(@HostParam(value="endpoint") String var1, @PathParam(value="callConnectionId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Repeatability-Request-ID") UUID var4, @HeaderParam(value="Repeatability-First-Sent") DateTimeRfc1123 var5, @BodyParam(value="application/json") RemoveParticipantRequestInternal var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/calling/callConnections/{callConnectionId}/participants/{participantRawId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<CallParticipantInternal>> getParticipant(@HostParam(value="endpoint") String var1, @PathParam(value="callConnectionId") String var2, @PathParam(value="participantRawId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<GetParticipantsResponseInternal>> getParticipantsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

