/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.implementation;

import com.azure.communication.callautomation.implementation.CallConnectionsImpl;
import com.azure.communication.callautomation.implementation.CallMediasImpl;
import com.azure.communication.callautomation.implementation.CallRecordingsImpl;
import com.azure.communication.callautomation.implementation.models.AnswerCallRequestInternal;
import com.azure.communication.callautomation.implementation.models.CallConnectionPropertiesInternal;
import com.azure.communication.callautomation.implementation.models.CommunicationErrorResponseException;
import com.azure.communication.callautomation.implementation.models.CreateCallRequestInternal;
import com.azure.communication.callautomation.implementation.models.RedirectCallRequestInternal;
import com.azure.communication.callautomation.implementation.models.RejectCallRequestInternal;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import java.time.OffsetDateTime;
import java.util.UUID;
import reactor.core.publisher.Mono;

public final class AzureCommunicationCallAutomationServiceImpl {
    private final AzureCommunicationCallAutomationServiceService service;
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final CallConnectionsImpl callConnections;
    private final CallMediasImpl callMedias;
    private final CallRecordingsImpl callRecordings;

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public CallConnectionsImpl getCallConnections() {
        return this.callConnections;
    }

    public CallMediasImpl getCallMedias() {
        return this.callMedias;
    }

    public CallRecordingsImpl getCallRecordings() {
        return this.callRecordings;
    }

    AzureCommunicationCallAutomationServiceImpl(String endpoint, String apiVersion) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), endpoint, apiVersion);
    }

    AzureCommunicationCallAutomationServiceImpl(HttpPipeline httpPipeline, String endpoint, String apiVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), endpoint, apiVersion);
    }

    AzureCommunicationCallAutomationServiceImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String endpoint, String apiVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.endpoint = endpoint;
        this.apiVersion = apiVersion;
        this.callConnections = new CallConnectionsImpl(this);
        this.callMedias = new CallMediasImpl(this);
        this.callRecordings = new CallRecordingsImpl(this);
        this.service = (AzureCommunicationCallAutomationServiceService)RestProxy.create(AzureCommunicationCallAutomationServiceService.class, (HttpPipeline)this.httpPipeline, (SerializerAdapter)this.getSerializerAdapter());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CallConnectionPropertiesInternal>> createCallWithResponseAsync(CreateCallRequestInternal createCallRequest, UUID repeatabilityRequestID, OffsetDateTime repeatabilityFirstSent) {
        String accept = "application/json";
        DateTimeRfc1123 repeatabilityFirstSentConverted = repeatabilityFirstSent == null ? null : new DateTimeRfc1123(repeatabilityFirstSent);
        return FluxUtil.withContext(context -> this.service.createCall(this.getEndpoint(), this.getApiVersion(), repeatabilityRequestID, repeatabilityFirstSentConverted, createCallRequest, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CallConnectionPropertiesInternal>> createCallWithResponseAsync(CreateCallRequestInternal createCallRequest, UUID repeatabilityRequestID, OffsetDateTime repeatabilityFirstSent, Context context) {
        String accept = "application/json";
        DateTimeRfc1123 repeatabilityFirstSentConverted = repeatabilityFirstSent == null ? null : new DateTimeRfc1123(repeatabilityFirstSent);
        return this.service.createCall(this.getEndpoint(), this.getApiVersion(), repeatabilityRequestID, repeatabilityFirstSentConverted, createCallRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CallConnectionPropertiesInternal> createCallAsync(CreateCallRequestInternal createCallRequest, UUID repeatabilityRequestID, OffsetDateTime repeatabilityFirstSent) {
        return this.createCallWithResponseAsync(createCallRequest, repeatabilityRequestID, repeatabilityFirstSent).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((CallConnectionPropertiesInternal)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CallConnectionPropertiesInternal> createCallAsync(CreateCallRequestInternal createCallRequest, UUID repeatabilityRequestID, OffsetDateTime repeatabilityFirstSent, Context context) {
        return this.createCallWithResponseAsync(createCallRequest, repeatabilityRequestID, repeatabilityFirstSent, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((CallConnectionPropertiesInternal)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CallConnectionPropertiesInternal createCall(CreateCallRequestInternal createCallRequest, UUID repeatabilityRequestID, OffsetDateTime repeatabilityFirstSent) {
        return (CallConnectionPropertiesInternal)this.createCallAsync(createCallRequest, repeatabilityRequestID, repeatabilityFirstSent).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CallConnectionPropertiesInternal> createCallWithResponse(CreateCallRequestInternal createCallRequest, UUID repeatabilityRequestID, OffsetDateTime repeatabilityFirstSent, Context context) {
        return (Response)this.createCallWithResponseAsync(createCallRequest, repeatabilityRequestID, repeatabilityFirstSent, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CallConnectionPropertiesInternal>> answerCallWithResponseAsync(AnswerCallRequestInternal answerCallRequest, UUID repeatabilityRequestID, OffsetDateTime repeatabilityFirstSent) {
        String accept = "application/json";
        DateTimeRfc1123 repeatabilityFirstSentConverted = repeatabilityFirstSent == null ? null : new DateTimeRfc1123(repeatabilityFirstSent);
        return FluxUtil.withContext(context -> this.service.answerCall(this.getEndpoint(), this.getApiVersion(), repeatabilityRequestID, repeatabilityFirstSentConverted, answerCallRequest, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CallConnectionPropertiesInternal>> answerCallWithResponseAsync(AnswerCallRequestInternal answerCallRequest, UUID repeatabilityRequestID, OffsetDateTime repeatabilityFirstSent, Context context) {
        String accept = "application/json";
        DateTimeRfc1123 repeatabilityFirstSentConverted = repeatabilityFirstSent == null ? null : new DateTimeRfc1123(repeatabilityFirstSent);
        return this.service.answerCall(this.getEndpoint(), this.getApiVersion(), repeatabilityRequestID, repeatabilityFirstSentConverted, answerCallRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CallConnectionPropertiesInternal> answerCallAsync(AnswerCallRequestInternal answerCallRequest, UUID repeatabilityRequestID, OffsetDateTime repeatabilityFirstSent) {
        return this.answerCallWithResponseAsync(answerCallRequest, repeatabilityRequestID, repeatabilityFirstSent).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((CallConnectionPropertiesInternal)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CallConnectionPropertiesInternal> answerCallAsync(AnswerCallRequestInternal answerCallRequest, UUID repeatabilityRequestID, OffsetDateTime repeatabilityFirstSent, Context context) {
        return this.answerCallWithResponseAsync(answerCallRequest, repeatabilityRequestID, repeatabilityFirstSent, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((CallConnectionPropertiesInternal)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CallConnectionPropertiesInternal answerCall(AnswerCallRequestInternal answerCallRequest, UUID repeatabilityRequestID, OffsetDateTime repeatabilityFirstSent) {
        return (CallConnectionPropertiesInternal)this.answerCallAsync(answerCallRequest, repeatabilityRequestID, repeatabilityFirstSent).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CallConnectionPropertiesInternal> answerCallWithResponse(AnswerCallRequestInternal answerCallRequest, UUID repeatabilityRequestID, OffsetDateTime repeatabilityFirstSent, Context context) {
        return (Response)this.answerCallWithResponseAsync(answerCallRequest, repeatabilityRequestID, repeatabilityFirstSent, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> redirectCallWithResponseAsync(RedirectCallRequestInternal redirectCallRequest, UUID repeatabilityRequestID, OffsetDateTime repeatabilityFirstSent) {
        String accept = "application/json";
        DateTimeRfc1123 repeatabilityFirstSentConverted = repeatabilityFirstSent == null ? null : new DateTimeRfc1123(repeatabilityFirstSent);
        return FluxUtil.withContext(context -> this.service.redirectCall(this.getEndpoint(), this.getApiVersion(), repeatabilityRequestID, repeatabilityFirstSentConverted, redirectCallRequest, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> redirectCallWithResponseAsync(RedirectCallRequestInternal redirectCallRequest, UUID repeatabilityRequestID, OffsetDateTime repeatabilityFirstSent, Context context) {
        String accept = "application/json";
        DateTimeRfc1123 repeatabilityFirstSentConverted = repeatabilityFirstSent == null ? null : new DateTimeRfc1123(repeatabilityFirstSent);
        return this.service.redirectCall(this.getEndpoint(), this.getApiVersion(), repeatabilityRequestID, repeatabilityFirstSentConverted, redirectCallRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> redirectCallAsync(RedirectCallRequestInternal redirectCallRequest, UUID repeatabilityRequestID, OffsetDateTime repeatabilityFirstSent) {
        return this.redirectCallWithResponseAsync(redirectCallRequest, repeatabilityRequestID, repeatabilityFirstSent).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> redirectCallAsync(RedirectCallRequestInternal redirectCallRequest, UUID repeatabilityRequestID, OffsetDateTime repeatabilityFirstSent, Context context) {
        return this.redirectCallWithResponseAsync(redirectCallRequest, repeatabilityRequestID, repeatabilityFirstSent, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void redirectCall(RedirectCallRequestInternal redirectCallRequest, UUID repeatabilityRequestID, OffsetDateTime repeatabilityFirstSent) {
        this.redirectCallAsync(redirectCallRequest, repeatabilityRequestID, repeatabilityFirstSent).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> redirectCallWithResponse(RedirectCallRequestInternal redirectCallRequest, UUID repeatabilityRequestID, OffsetDateTime repeatabilityFirstSent, Context context) {
        return (Response)this.redirectCallWithResponseAsync(redirectCallRequest, repeatabilityRequestID, repeatabilityFirstSent, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> rejectCallWithResponseAsync(RejectCallRequestInternal rejectCallRequest, UUID repeatabilityRequestID, OffsetDateTime repeatabilityFirstSent) {
        String accept = "application/json";
        DateTimeRfc1123 repeatabilityFirstSentConverted = repeatabilityFirstSent == null ? null : new DateTimeRfc1123(repeatabilityFirstSent);
        return FluxUtil.withContext(context -> this.service.rejectCall(this.getEndpoint(), this.getApiVersion(), repeatabilityRequestID, repeatabilityFirstSentConverted, rejectCallRequest, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> rejectCallWithResponseAsync(RejectCallRequestInternal rejectCallRequest, UUID repeatabilityRequestID, OffsetDateTime repeatabilityFirstSent, Context context) {
        String accept = "application/json";
        DateTimeRfc1123 repeatabilityFirstSentConverted = repeatabilityFirstSent == null ? null : new DateTimeRfc1123(repeatabilityFirstSent);
        return this.service.rejectCall(this.getEndpoint(), this.getApiVersion(), repeatabilityRequestID, repeatabilityFirstSentConverted, rejectCallRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> rejectCallAsync(RejectCallRequestInternal rejectCallRequest, UUID repeatabilityRequestID, OffsetDateTime repeatabilityFirstSent) {
        return this.rejectCallWithResponseAsync(rejectCallRequest, repeatabilityRequestID, repeatabilityFirstSent).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> rejectCallAsync(RejectCallRequestInternal rejectCallRequest, UUID repeatabilityRequestID, OffsetDateTime repeatabilityFirstSent, Context context) {
        return this.rejectCallWithResponseAsync(rejectCallRequest, repeatabilityRequestID, repeatabilityFirstSent, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void rejectCall(RejectCallRequestInternal rejectCallRequest, UUID repeatabilityRequestID, OffsetDateTime repeatabilityFirstSent) {
        this.rejectCallAsync(rejectCallRequest, repeatabilityRequestID, repeatabilityFirstSent).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> rejectCallWithResponse(RejectCallRequestInternal rejectCallRequest, UUID repeatabilityRequestID, OffsetDateTime repeatabilityFirstSent, Context context) {
        return (Response)this.rejectCallWithResponseAsync(rejectCallRequest, repeatabilityRequestID, repeatabilityFirstSent, context).block();
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="AzureCommunicationCa")
    public static interface AzureCommunicationCallAutomationServiceService {
        @Post(value="/calling/callConnections")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<CallConnectionPropertiesInternal>> createCall(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Repeatability-Request-ID") UUID var3, @HeaderParam(value="Repeatability-First-Sent") DateTimeRfc1123 var4, @BodyParam(value="application/json") CreateCallRequestInternal var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Post(value="/calling/callConnections:answer")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<CallConnectionPropertiesInternal>> answerCall(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Repeatability-Request-ID") UUID var3, @HeaderParam(value="Repeatability-First-Sent") DateTimeRfc1123 var4, @BodyParam(value="application/json") AnswerCallRequestInternal var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Post(value="/calling/callConnections:redirect")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<Void>> redirectCall(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Repeatability-Request-ID") UUID var3, @HeaderParam(value="Repeatability-First-Sent") DateTimeRfc1123 var4, @BodyParam(value="application/json") RedirectCallRequestInternal var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Post(value="/calling/callConnections:reject")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<Void>> rejectCall(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Repeatability-Request-ID") UUID var3, @HeaderParam(value="Repeatability-First-Sent") DateTimeRfc1123 var4, @BodyParam(value="application/json") RejectCallRequestInternal var5, @HeaderParam(value="Accept") String var6, Context var7);
    }
}

