/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation;

import com.azure.communication.callautomation.ContentDownloader;
import com.azure.communication.callautomation.implementation.CallRecordingsImpl;
import com.azure.communication.callautomation.implementation.accesshelpers.RecordingStateResponseConstructorProxy;
import com.azure.communication.callautomation.implementation.converters.CommunicationIdentifierConverter;
import com.azure.communication.callautomation.implementation.models.CallLocatorInternal;
import com.azure.communication.callautomation.implementation.models.CallLocatorKindInternal;
import com.azure.communication.callautomation.implementation.models.ChannelAffinityInternal;
import com.azure.communication.callautomation.implementation.models.CommunicationIdentifierModel;
import com.azure.communication.callautomation.implementation.models.RecordingChannelInternal;
import com.azure.communication.callautomation.implementation.models.RecordingContentInternal;
import com.azure.communication.callautomation.implementation.models.RecordingFormatInternal;
import com.azure.communication.callautomation.implementation.models.RecordingStateResponseInternal;
import com.azure.communication.callautomation.implementation.models.StartCallRecordingRequestInternal;
import com.azure.communication.callautomation.models.CallLocator;
import com.azure.communication.callautomation.models.CallLocatorKind;
import com.azure.communication.callautomation.models.ChannelAffinity;
import com.azure.communication.callautomation.models.DownloadToFileOptions;
import com.azure.communication.callautomation.models.GroupCallLocator;
import com.azure.communication.callautomation.models.ParallelDownloadOptions;
import com.azure.communication.callautomation.models.RecordingStateResult;
import com.azure.communication.callautomation.models.ServerCallLocator;
import com.azure.communication.callautomation.models.StartRecordingOptions;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpRange;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.InvalidParameterException;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;

public final class CallRecordingAsync {
    private final CallRecordingsImpl callRecordingsInternal;
    private final ClientLogger logger;
    private final ContentDownloader contentDownloader;
    private final HttpPipeline httpPipelineInternal;
    private final String resourceUrl;

    CallRecordingAsync(CallRecordingsImpl callRecordingsInternal, ContentDownloader contentDownloader, HttpPipeline httpPipelineInternal, String resourceUrl) {
        this.callRecordingsInternal = callRecordingsInternal;
        this.contentDownloader = contentDownloader;
        this.httpPipelineInternal = httpPipelineInternal;
        this.resourceUrl = resourceUrl;
        this.logger = new ClientLogger(CallRecordingAsync.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RecordingStateResult> start(StartRecordingOptions options) {
        return this.startWithResponse(options).flatMap(response -> Mono.just((Object)((RecordingStateResult)response.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RecordingStateResult>> startWithResponse(StartRecordingOptions options) {
        Objects.requireNonNull(options, "'options' cannot be null.");
        return this.startWithResponseInternal(options, null);
    }

    Mono<Response<RecordingStateResult>> startWithResponseInternal(StartRecordingOptions options, Context context) {
        try {
            StartCallRecordingRequestInternal request = this.getStartCallRecordingRequest(options);
            return FluxUtil.withContext(contextValue -> {
                contextValue = context == null ? contextValue : context;
                return this.callRecordingsInternal.startRecordingWithResponseAsync(request, UUID.randomUUID(), OffsetDateTime.now(), (Context)contextValue).map(response -> new SimpleResponse(response, (Object)RecordingStateResponseConstructorProxy.create((RecordingStateResponseInternal)response.getValue())));
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private StartCallRecordingRequestInternal getStartCallRecordingRequest(StartRecordingOptions options) {
        CallLocator callLocator = options.getCallLocator();
        CallLocatorInternal callLocatorInternal = new CallLocatorInternal().setKind(CallLocatorKindInternal.fromString(callLocator.getKind().toString()));
        if (callLocator.getKind() == CallLocatorKind.GROUP_CALL_LOCATOR) {
            callLocatorInternal.setGroupCallId(((GroupCallLocator)callLocator).getGroupCallId());
        } else if (callLocator.getKind() == CallLocatorKind.SERVER_CALL_LOCATOR) {
            callLocatorInternal.setServerCallId(((ServerCallLocator)callLocator).getServerCallId());
        } else {
            throw this.logger.logExceptionAsError((RuntimeException)new InvalidParameterException("callLocator has invalid kind."));
        }
        StartCallRecordingRequestInternal request = new StartCallRecordingRequestInternal().setCallLocator(callLocatorInternal);
        if (options.getRecordingContent() != null) {
            request.setRecordingContentType(RecordingContentInternal.fromString(options.getRecordingContent().toString()));
        }
        if (options.getRecordingFormat() != null) {
            request.setRecordingFormatType(RecordingFormatInternal.fromString(options.getRecordingFormat().toString()));
        }
        if (options.getRecordingChannel() != null) {
            request.setRecordingChannelType(RecordingChannelInternal.fromString(options.getRecordingChannel().toString()));
        }
        if (options.getRecordingStateCallbackUrl() != null) {
            request.setRecordingStateCallbackUri(options.getRecordingStateCallbackUrl());
        }
        if (options.getAudioChannelParticipantOrdering() != null) {
            List<CommunicationIdentifierModel> audioChannelParticipantOrdering = options.getAudioChannelParticipantOrdering().stream().map(CommunicationIdentifierConverter::convert).collect(Collectors.toList());
            request.setAudioChannelParticipantOrdering(audioChannelParticipantOrdering);
        }
        if (options.getChannelAffinity() != null) {
            List<ChannelAffinityInternal> channelAffinityInternals = options.getChannelAffinity().stream().map(this::getChannelAffinityInternal).collect(Collectors.toList());
            request.setChannelAffinity(channelAffinityInternals);
        }
        return request;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> stop(String recordingId) {
        return this.stopWithResponse(recordingId).then();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> stopWithResponse(String recordingId) {
        return this.stopWithResponseInternal(recordingId, null);
    }

    Mono<Response<Void>> stopWithResponseInternal(String recordingId, Context context) {
        try {
            return FluxUtil.withContext(contextValue -> {
                contextValue = context == null ? contextValue : context;
                return this.callRecordingsInternal.stopRecordingWithResponseAsync(recordingId, (Context)contextValue);
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> pause(String recordingId) {
        return this.pauseWithResponse(recordingId).then();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> pauseWithResponse(String recordingId) {
        return this.pauseWithResponseInternal(recordingId, null);
    }

    Mono<Response<Void>> pauseWithResponseInternal(String recordingId, Context context) {
        try {
            return FluxUtil.withContext(contextValue -> {
                contextValue = context == null ? contextValue : context;
                return this.callRecordingsInternal.pauseRecordingWithResponseAsync(recordingId, (Context)contextValue);
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> resume(String recordingId) {
        return this.resumeWithResponse(recordingId).then();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> resumeWithResponse(String recordingId) {
        return this.resumeWithResponseInternal(recordingId, null);
    }

    Mono<Response<Void>> resumeWithResponseInternal(String recordingId, Context context) {
        try {
            return FluxUtil.withContext(contextValue -> {
                contextValue = context == null ? contextValue : context;
                return this.callRecordingsInternal.resumeRecordingWithResponseAsync(recordingId, (Context)contextValue);
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RecordingStateResult> getState(String recordingId) {
        return this.getStateWithResponse(recordingId).flatMap(response -> Mono.just((Object)((RecordingStateResult)response.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RecordingStateResult>> getStateWithResponse(String recordingId) {
        return this.getStateWithResponseInternal(recordingId, null);
    }

    Mono<Response<RecordingStateResult>> getStateWithResponseInternal(String recordingId, Context context) {
        try {
            return FluxUtil.withContext(contextValue -> {
                contextValue = context == null ? contextValue : context;
                return this.callRecordingsInternal.getRecordingPropertiesWithResponseAsync(recordingId, (Context)contextValue).map(response -> new SimpleResponse(response, (Object)RecordingStateResponseConstructorProxy.create((RecordingStateResponseInternal)response.getValue())));
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public Flux<ByteBuffer> downloadStream(String sourceUrl) {
        return this.downloadStreamWithResponse(sourceUrl, null).map(Response::getValue).flux().flatMap(flux -> flux);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> downloadStreamWithResponse(String sourceUrl, HttpRange range) {
        return this.downloadStreamWithResponseInternal(sourceUrl, range, null);
    }

    Mono<Response<Flux<ByteBuffer>>> downloadStreamWithResponseInternal(String sourceUrl, HttpRange range, Context context) {
        try {
            Objects.requireNonNull(sourceUrl, "'sourceUrl' cannot be null");
            return FluxUtil.withContext(contextValue -> {
                contextValue = context == null ? contextValue : context;
                return this.contentDownloader.downloadStreamWithResponse(sourceUrl, range, (Context)contextValue);
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BinaryData> downloadContent(String sourceUrl) {
        return this.downloadStreamWithResponse(sourceUrl, null).flatMap(response -> BinaryData.fromFlux((Flux)((Flux)response.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> downloadContentWithResponse(String sourceUrl, HttpRange range) {
        return this.downloadContentWithResponseInternal(sourceUrl, range, null);
    }

    Mono<Response<BinaryData>> downloadContentWithResponseInternal(String sourceUrl, HttpRange range, Context context) {
        return FluxUtil.withContext(contextValue -> {
            contextValue = context == null ? contextValue : context;
            return this.downloadStreamWithResponseInternal(sourceUrl, range, (Context)contextValue).flatMap(response -> BinaryData.fromFlux((Flux)((Flux)response.getValue())).map(data -> new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), data)));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> downloadTo(String sourceUrl, Path destinationPath) {
        try {
            DownloadToFileOptions options = new DownloadToFileOptions();
            return this.downloadTo(sourceUrl, destinationPath, options).then();
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> downloadTo(String sourceUrl, Path destinationPath, DownloadToFileOptions options) {
        return this.downloadToInternal(sourceUrl, destinationPath, options, null);
    }

    Mono<Void> downloadToInternal(String sourceUrl, Path destinationPath, DownloadToFileOptions options, Context context) {
        Objects.requireNonNull(sourceUrl, "'sourceUrl' cannot be null");
        Objects.requireNonNull(destinationPath, "'destinationPath' cannot be null");
        HashSet<StandardOpenOption> openOptions = new HashSet<StandardOpenOption>();
        if (options.isOverwrite()) {
            openOptions.add(StandardOpenOption.CREATE);
        } else {
            openOptions.add(StandardOpenOption.CREATE_NEW);
        }
        openOptions.add(StandardOpenOption.WRITE);
        try {
            AsynchronousFileChannel file = AsynchronousFileChannel.open(destinationPath, openOptions, null, new FileAttribute[0]);
            return FluxUtil.withContext(contextValue -> {
                contextValue = context == null ? contextValue : context;
                return this.downloadTo(sourceUrl, destinationPath, file, options, (Context)contextValue);
            });
        }
        catch (IOException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new RuntimeException(ex));
        }
    }

    Mono<Void> downloadTo(String sourceUrl, OutputStream destinationStream, HttpRange httpRange, Context context) {
        return this.contentDownloader.downloadToStreamWithResponse(sourceUrl, destinationStream, httpRange, context).then();
    }

    Mono<Void> downloadTo(String sourceUrl, Path destinationPath, AsynchronousFileChannel fileChannel, DownloadToFileOptions options, Context context) {
        ParallelDownloadOptions finalParallelDownloadOptions = options.getParallelDownloadOptions() == null ? new ParallelDownloadOptions() : options.getParallelDownloadOptions();
        return Mono.just((Object)fileChannel).flatMap(c -> this.contentDownloader.downloadToFileWithResponse(sourceUrl, (AsynchronousFileChannel)c, finalParallelDownloadOptions, context)).doFinally(signalType -> this.contentDownloader.downloadToFileCleanup(fileChannel, destinationPath, (SignalType)signalType)).then();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> delete(String deleteUrl) {
        try {
            return this.deleteWithResponseInternal(deleteUrl, null).then();
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponse(String deleteUrl) {
        return this.deleteWithResponseInternal(deleteUrl, null);
    }

    Mono<Response<Void>> deleteWithResponseInternal(String deleteUrl, Context context) {
        HttpRequest request = new HttpRequest(HttpMethod.DELETE, deleteUrl);
        URL urlToSignWith = this.getUrlToSignRequestWith(deleteUrl);
        try {
            return FluxUtil.withContext(contextValue -> {
                contextValue = context == null ? contextValue : context;
                contextValue = contextValue.addData((Object)"hmacSignatureURL", (Object)urlToSignWith);
                return this.httpPipelineInternal.send(request, contextValue).map(response -> new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null));
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private URL getUrlToSignRequestWith(String url) {
        try {
            String path = new URL(url).getPath();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            return new URL(this.resourceUrl + path);
        }
        catch (MalformedURLException ex) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(ex));
        }
    }

    private ChannelAffinityInternal getChannelAffinityInternal(ChannelAffinity channelAffinity) {
        ChannelAffinityInternal channelAffinityInternal = new ChannelAffinityInternal();
        CommunicationIdentifierModel communicationIdentifierModel = CommunicationIdentifierConverter.convert(channelAffinity.getParticipant());
        channelAffinityInternal.setParticipant(communicationIdentifierModel);
        if (channelAffinity.getChannel() != null) {
            channelAffinityInternal.setChannel(channelAffinity.getChannel());
        }
        return channelAffinityInternal;
    }
}

