/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation;

import com.azure.communication.callautomation.implementation.CallMediasImpl;
import com.azure.communication.callautomation.implementation.converters.CommunicationIdentifierConverter;
import com.azure.communication.callautomation.implementation.models.DtmfOptionsInternal;
import com.azure.communication.callautomation.implementation.models.DtmfToneInternal;
import com.azure.communication.callautomation.implementation.models.FileSourceInternal;
import com.azure.communication.callautomation.implementation.models.PlayOptionsInternal;
import com.azure.communication.callautomation.implementation.models.PlayRequest;
import com.azure.communication.callautomation.implementation.models.PlaySourceInternal;
import com.azure.communication.callautomation.implementation.models.PlaySourceTypeInternal;
import com.azure.communication.callautomation.implementation.models.RecognizeInputTypeInternal;
import com.azure.communication.callautomation.implementation.models.RecognizeOptionsInternal;
import com.azure.communication.callautomation.implementation.models.RecognizeRequest;
import com.azure.communication.callautomation.models.CallMediaRecognizeDtmfOptions;
import com.azure.communication.callautomation.models.CallMediaRecognizeOptions;
import com.azure.communication.callautomation.models.DtmfTone;
import com.azure.communication.callautomation.models.FileSource;
import com.azure.communication.callautomation.models.PlayOptions;
import com.azure.communication.callautomation.models.PlaySource;
import com.azure.communication.callautomation.models.PlayToAllOptions;
import com.azure.communication.common.CommunicationIdentifier;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public final class CallMediaAsync {
    private final CallMediasImpl contentsInternal;
    private final String callConnectionId;
    private final ClientLogger logger;

    CallMediaAsync(String callConnectionId, CallMediasImpl contentsInternal) {
        this.callConnectionId = callConnectionId;
        this.contentsInternal = contentsInternal;
        this.logger = new ClientLogger(CallMediaAsync.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> play(List<PlaySource> playSources, List<CommunicationIdentifier> playTo) {
        PlayOptions options = new PlayOptions(playSources, playTo);
        return this.playWithResponse(options).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> play(PlaySource playSource, List<CommunicationIdentifier> playTo) {
        PlayOptions options = new PlayOptions(playSource, playTo);
        return this.playWithResponse(options).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> playToAll(List<PlaySource> playSources) {
        PlayToAllOptions options = new PlayToAllOptions(playSources);
        return this.playToAllWithResponse(options).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> playToAll(PlaySource playSource) {
        PlayToAllOptions options = new PlayToAllOptions(playSource);
        return this.playToAllWithResponse(options).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> playWithResponse(PlayOptions options) {
        return this.playWithResponseInternal(options, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> playToAllWithResponse(PlayToAllOptions options) {
        return this.playToAllWithResponseInternal(options, null);
    }

    public Mono<Void> startRecognizing(CallMediaRecognizeOptions recognizeOptions) {
        return this.startRecognizingWithResponse(recognizeOptions).then();
    }

    public Mono<Response<Void>> startRecognizingWithResponse(CallMediaRecognizeOptions recognizeOptions) {
        return FluxUtil.withContext(context -> this.recognizeWithResponseInternal(recognizeOptions, (Context)context));
    }

    Mono<Response<Void>> recognizeWithResponseInternal(CallMediaRecognizeOptions recognizeOptions, Context context) {
        try {
            Context context2 = context = context == null ? Context.NONE : context;
            if (recognizeOptions instanceof CallMediaRecognizeDtmfOptions) {
                RecognizeRequest recognizeRequest = this.getRecognizeRequestFromDtmfConfiguration(recognizeOptions);
                return this.contentsInternal.recognizeWithResponseAsync(this.callConnectionId, recognizeRequest, context);
            }
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new UnsupportedOperationException(recognizeOptions.getClass().getName()));
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> cancelAllMediaOperations() {
        return this.cancelAllMediaOperationsWithResponse().then();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> cancelAllMediaOperationsWithResponse() {
        return this.cancelAllMediaOperationsWithResponseInternal(null);
    }

    Mono<Response<Void>> cancelAllMediaOperationsWithResponseInternal(Context context) {
        try {
            return FluxUtil.withContext(contextValue -> {
                contextValue = context == null ? contextValue : context;
                return this.contentsInternal.cancelAllMediaOperationsWithResponseAsync(this.callConnectionId, (Context)contextValue);
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> playWithResponseInternal(PlayOptions options, Context context) {
        try {
            return FluxUtil.withContext(contextValue -> {
                contextValue = context == null ? contextValue : context;
                PlayRequest request = this.getPlayRequest(options);
                return this.contentsInternal.playWithResponseAsync(this.callConnectionId, request, (Context)contextValue);
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> playToAllWithResponseInternal(PlayToAllOptions options, Context context) {
        try {
            PlayOptions playOptions = new PlayOptions(options.getPlaySources(), Collections.emptyList());
            playOptions.setLoop(options.isLoop());
            playOptions.setOperationContext(options.getOperationContext());
            return this.playWithResponseInternal(playOptions, context);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    PlayRequest getPlayRequest(PlayOptions options) {
        ArrayList<PlaySourceInternal> playSourcesInternal = new ArrayList<PlaySourceInternal>();
        for (PlaySource source : options.getPlaySources()) {
            PlaySourceInternal playSourceInternal = null;
            if (source instanceof FileSource) {
                playSourceInternal = this.getPlaySourceInternalFromFileSource((FileSource)source);
            }
            if (playSourceInternal != null && playSourceInternal.getKind() != null) {
                playSourcesInternal.add(playSourceInternal);
                continue;
            }
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(source.getClass().getCanonicalName()));
        }
        if (!playSourcesInternal.isEmpty()) {
            PlayRequest request = new PlayRequest().setPlaySources(playSourcesInternal).setPlayTo(options.getPlayTo().stream().map(CommunicationIdentifierConverter::convert).collect(Collectors.toList()));
            request.setPlayOptions(new PlayOptionsInternal().setLoop(options.isLoop()));
            request.setOperationContext(options.getOperationContext());
            return request;
        }
        throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(options.getPlaySources().getClass().getCanonicalName()));
    }

    private PlaySourceInternal getPlaySourceInternalFromFileSource(FileSource playSource) {
        FileSourceInternal fileSourceInternal = new FileSourceInternal().setUri(playSource.getUrl());
        PlaySourceInternal playSourceInternal = new PlaySourceInternal().setKind(PlaySourceTypeInternal.FILE).setFile(fileSourceInternal).setPlaySourceCacheId(playSource.getPlaySourceCacheId());
        return playSourceInternal;
    }

    private PlaySourceInternal convertPlaySourceToPlaySourceInternal(PlaySource playSource) {
        PlaySourceInternal playSourceInternal = new PlaySourceInternal();
        if (playSource instanceof FileSource) {
            playSourceInternal = this.getPlaySourceInternalFromFileSource((FileSource)playSource);
        }
        return playSourceInternal;
    }

    private DtmfToneInternal convertDtmfToneInternal(DtmfTone dtmfTone) {
        return DtmfToneInternal.fromString(dtmfTone.toString());
    }

    private RecognizeRequest getRecognizeRequestFromDtmfConfiguration(CallMediaRecognizeOptions recognizeOptions) {
        CallMediaRecognizeDtmfOptions dtmfRecognizeOptions = (CallMediaRecognizeDtmfOptions)recognizeOptions;
        DtmfOptionsInternal dtmfOptionsInternal = new DtmfOptionsInternal();
        dtmfOptionsInternal.setInterToneTimeoutInSeconds((int)dtmfRecognizeOptions.getInterToneTimeout().getSeconds());
        if (dtmfRecognizeOptions.getMaxTonesToCollect() != null) {
            dtmfOptionsInternal.setMaxTonesToCollect(dtmfRecognizeOptions.getMaxTonesToCollect());
        }
        if (dtmfRecognizeOptions.getStopTones() != null) {
            List<DtmfToneInternal> dtmfTones = dtmfRecognizeOptions.getStopTones().stream().map(this::convertDtmfToneInternal).collect(Collectors.toList());
            dtmfOptionsInternal.setStopTones(dtmfTones);
        }
        RecognizeOptionsInternal recognizeOptionsInternal = new RecognizeOptionsInternal().setDtmfOptions(dtmfOptionsInternal).setInterruptPrompt(recognizeOptions.isInterruptPrompt()).setTargetParticipant(CommunicationIdentifierConverter.convert(recognizeOptions.getTargetParticipant()));
        recognizeOptionsInternal.setInitialSilenceTimeoutInSeconds((int)recognizeOptions.getInitialSilenceTimeout().getSeconds());
        PlaySourceInternal playSourceInternal = this.getPlaySourceInternalFromRecognizeOptions(recognizeOptions);
        RecognizeRequest recognizeRequest = new RecognizeRequest().setRecognizeInputType(RecognizeInputTypeInternal.fromString(recognizeOptions.getRecognizeInputType().toString())).setInterruptCallMediaOperation(recognizeOptions.isInterruptCallMediaOperation()).setPlayPrompt(playSourceInternal).setRecognizeOptions(recognizeOptionsInternal).setOperationContext(recognizeOptions.getOperationContext());
        return recognizeRequest;
    }

    private PlaySourceInternal getPlaySourceInternalFromRecognizeOptions(CallMediaRecognizeOptions recognizeOptions) {
        PlaySourceInternal playSourceInternal = null;
        if (recognizeOptions.getPlayPrompt() != null) {
            PlaySource playSource = recognizeOptions.getPlayPrompt();
            playSourceInternal = this.convertPlaySourceToPlaySourceInternal(playSource);
        }
        return playSourceInternal;
    }
}

