/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation;

import com.azure.communication.callautomation.CallMediaAsync;
import com.azure.communication.callautomation.implementation.CallConnectionsImpl;
import com.azure.communication.callautomation.implementation.CallMediasImpl;
import com.azure.communication.callautomation.implementation.accesshelpers.AddParticipantResponseConstructorProxy;
import com.azure.communication.callautomation.implementation.accesshelpers.CallConnectionPropertiesConstructorProxy;
import com.azure.communication.callautomation.implementation.accesshelpers.RemoveParticipantResponseConstructorProxy;
import com.azure.communication.callautomation.implementation.accesshelpers.TransferCallResponseConstructorProxy;
import com.azure.communication.callautomation.implementation.converters.CallParticipantConverter;
import com.azure.communication.callautomation.implementation.converters.CommunicationIdentifierConverter;
import com.azure.communication.callautomation.implementation.converters.PhoneNumberIdentifierConverter;
import com.azure.communication.callautomation.implementation.models.AddParticipantRequestInternal;
import com.azure.communication.callautomation.implementation.models.AddParticipantResponseInternal;
import com.azure.communication.callautomation.implementation.models.CallConnectionPropertiesInternal;
import com.azure.communication.callautomation.implementation.models.CallParticipantInternal;
import com.azure.communication.callautomation.implementation.models.RemoveParticipantRequestInternal;
import com.azure.communication.callautomation.implementation.models.RemoveParticipantResponseInternal;
import com.azure.communication.callautomation.implementation.models.TransferCallResponseInternal;
import com.azure.communication.callautomation.implementation.models.TransferToParticipantRequestInternal;
import com.azure.communication.callautomation.models.AddParticipantOptions;
import com.azure.communication.callautomation.models.AddParticipantResult;
import com.azure.communication.callautomation.models.CallConnectionProperties;
import com.azure.communication.callautomation.models.CallInvite;
import com.azure.communication.callautomation.models.CallParticipant;
import com.azure.communication.callautomation.models.RemoveParticipantOptions;
import com.azure.communication.callautomation.models.RemoveParticipantResult;
import com.azure.communication.callautomation.models.TransferCallResult;
import com.azure.communication.callautomation.models.TransferCallToParticipantOptions;
import com.azure.communication.common.CommunicationIdentifier;
import com.azure.communication.common.CommunicationUserIdentifier;
import com.azure.communication.common.MicrosoftTeamsUserIdentifier;
import com.azure.communication.common.PhoneNumberIdentifier;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import java.net.URISyntaxException;
import java.time.OffsetDateTime;
import java.util.UUID;
import reactor.core.publisher.Mono;

public final class CallConnectionAsync {
    private final String callConnectionId;
    private final CallConnectionsImpl callConnectionInternal;
    private final CallMediasImpl callMediasInternal;
    private final ClientLogger logger;

    CallConnectionAsync(String callConnectionId, CallConnectionsImpl callConnectionInternal, CallMediasImpl contentsInternal) {
        this.callConnectionId = callConnectionId;
        this.callConnectionInternal = callConnectionInternal;
        this.callMediasInternal = contentsInternal;
        this.logger = new ClientLogger(CallConnectionAsync.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CallConnectionProperties> getCallProperties() {
        return this.getCallPropertiesWithResponse().flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CallConnectionProperties>> getCallPropertiesWithResponse() {
        return FluxUtil.withContext(this::getCallPropertiesWithResponseInternal);
    }

    Mono<Response<CallConnectionProperties>> getCallPropertiesWithResponseInternal(Context context) {
        try {
            context = context == null ? Context.NONE : context;
            return this.callConnectionInternal.getCallWithResponseAsync(this.callConnectionId, context).map(response -> {
                try {
                    return new SimpleResponse(response, (Object)CallConnectionPropertiesConstructorProxy.create((CallConnectionPropertiesInternal)response.getValue()));
                }
                catch (URISyntaxException e) {
                    throw this.logger.logExceptionAsError(new RuntimeException(e));
                }
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> hangUp(boolean isForEveryone) {
        return this.hangUpWithResponse(isForEveryone).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> hangUpWithResponse(boolean isForEveryone) {
        return FluxUtil.withContext(context -> this.hangUpWithResponseInternal(isForEveryone, (Context)context));
    }

    Mono<Response<Void>> hangUpWithResponseInternal(boolean isForEveryone, Context context) {
        try {
            context = context == null ? Context.NONE : context;
            return isForEveryone ? this.callConnectionInternal.terminateCallWithResponseAsync(this.callConnectionId, UUID.randomUUID(), OffsetDateTime.now(), context) : this.callConnectionInternal.hangupCallWithResponseAsync(this.callConnectionId, context);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CallParticipant> getParticipant(CommunicationIdentifier targetParticipant) {
        return this.getParticipantWithResponse(targetParticipant).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CallParticipant>> getParticipantWithResponse(CommunicationIdentifier targetParticipant) {
        return FluxUtil.withContext(context -> this.getParticipantWithResponseInternal(targetParticipant, (Context)context));
    }

    Mono<Response<CallParticipant>> getParticipantWithResponseInternal(CommunicationIdentifier targetParticipant, Context context) {
        try {
            context = context == null ? Context.NONE : context;
            String participantMri = targetParticipant.getRawId();
            return this.callConnectionInternal.getParticipantWithResponseAsync(this.callConnectionId, participantMri, context).map(response -> new SimpleResponse(response, (Object)CallParticipantConverter.convert((CallParticipantInternal)response.getValue())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<CallParticipant> listParticipants() {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.callConnectionInternal.getParticipantsSinglePageAsync(this.callConnectionId, (Context)context)), nextLink -> FluxUtil.withContext(context -> this.callConnectionInternal.getParticipantsNextSinglePageAsync((String)nextLink, (Context)context))).mapPage(CallParticipantConverter::convert);
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    PagedFlux<CallParticipant> listParticipantsWithContext(Context context) {
        try {
            Context serviceContext = context == null ? Context.NONE : context;
            return this.callConnectionInternal.getParticipantsAsync(this.callConnectionId, serviceContext).mapPage(CallParticipantConverter::convert);
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TransferCallResult> transferCallToParticipant(CommunicationIdentifier targetParticipant) {
        if (targetParticipant instanceof CommunicationUserIdentifier) {
            return this.transferCallToParticipantWithResponse(new TransferCallToParticipantOptions((CommunicationIdentifier)((CommunicationUserIdentifier)targetParticipant))).flatMap(FluxUtil::toMono);
        }
        if (targetParticipant instanceof PhoneNumberIdentifier) {
            return this.transferCallToParticipantWithResponse(new TransferCallToParticipantOptions((CommunicationIdentifier)((PhoneNumberIdentifier)targetParticipant))).flatMap(FluxUtil::toMono);
        }
        if (targetParticipant instanceof MicrosoftTeamsUserIdentifier) {
            return this.transferCallToParticipantWithResponse(new TransferCallToParticipantOptions((CommunicationIdentifier)((MicrosoftTeamsUserIdentifier)targetParticipant))).flatMap(FluxUtil::toMono);
        }
        throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("targetParticipant type is invalid."));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<TransferCallResult>> transferCallToParticipantWithResponse(TransferCallToParticipantOptions transferCallToParticipantOptions) {
        return FluxUtil.withContext(context -> this.transferCallToParticipantWithResponseInternal(transferCallToParticipantOptions, (Context)context));
    }

    Mono<Response<TransferCallResult>> transferCallToParticipantWithResponseInternal(TransferCallToParticipantOptions transferCallToParticipantOptions, Context context) {
        try {
            context = context == null ? Context.NONE : context;
            TransferToParticipantRequestInternal request = new TransferToParticipantRequestInternal().setTargetParticipant(CommunicationIdentifierConverter.convert(transferCallToParticipantOptions.getTargetParticipant())).setOperationContext(transferCallToParticipantOptions.getOperationContext());
            return this.callConnectionInternal.transferToParticipantWithResponseAsync(this.callConnectionId, request, UUID.randomUUID(), OffsetDateTime.now(), context).map(response -> new SimpleResponse(response, (Object)TransferCallResponseConstructorProxy.create((TransferCallResponseInternal)response.getValue())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AddParticipantResult> addParticipant(CallInvite participant) {
        return this.addParticipantWithResponse(new AddParticipantOptions(participant)).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AddParticipantResult>> addParticipantWithResponse(AddParticipantOptions addParticipantOptions) {
        return FluxUtil.withContext(context -> this.addParticipantWithResponseInternal(addParticipantOptions, (Context)context));
    }

    Mono<Response<AddParticipantResult>> addParticipantWithResponseInternal(AddParticipantOptions addParticipantOptions, Context context) {
        try {
            AddParticipantRequestInternal request = new AddParticipantRequestInternal().setParticipantToAdd(CommunicationIdentifierConverter.convert(addParticipantOptions.getTargetParticipant().getTargetParticipant())).setSourceDisplayName(addParticipantOptions.getTargetParticipant().getSourceDisplayName()).setSourceCallerIdNumber(PhoneNumberIdentifierConverter.convert(addParticipantOptions.getTargetParticipant().getSourceCallerIdNumber())).setOperationContext(addParticipantOptions.getOperationContext());
            if (addParticipantOptions.getInvitationTimeout() != null) {
                request.setInvitationTimeoutInSeconds((int)addParticipantOptions.getInvitationTimeout().getSeconds());
            }
            return this.callConnectionInternal.addParticipantWithResponseAsync(this.callConnectionId, request, UUID.randomUUID(), OffsetDateTime.now(), context).map(response -> new SimpleResponse(response, (Object)AddParticipantResponseConstructorProxy.create((AddParticipantResponseInternal)response.getValue())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RemoveParticipantResult> removeParticipant(CommunicationIdentifier participantToRemove) {
        return this.removeParticipantWithResponse(new RemoveParticipantOptions(participantToRemove)).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RemoveParticipantResult>> removeParticipantWithResponse(RemoveParticipantOptions removeParticipantOptions) {
        return FluxUtil.withContext(context -> this.removeParticipantWithResponseInternal(removeParticipantOptions, (Context)context));
    }

    Mono<Response<RemoveParticipantResult>> removeParticipantWithResponseInternal(RemoveParticipantOptions removeParticipantOptions, Context context) {
        try {
            context = context == null ? Context.NONE : context;
            RemoveParticipantRequestInternal request = new RemoveParticipantRequestInternal().setParticipantToRemove(CommunicationIdentifierConverter.convert(removeParticipantOptions.getParticipant())).setOperationContext(removeParticipantOptions.getOperationContext());
            return this.callConnectionInternal.removeParticipantWithResponseAsync(this.callConnectionId, request, UUID.randomUUID(), OffsetDateTime.now(), context).map(response -> new SimpleResponse(response, (Object)RemoveParticipantResponseConstructorProxy.create((RemoveParticipantResponseInternal)response.getValue())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CallMediaAsync getCallMediaAsync() {
        return new CallMediaAsync(this.callConnectionId, this.callMediasInternal);
    }
}

