/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation;

import com.azure.communication.callautomation.CallAutomationClientBuilder;
import com.azure.communication.callautomation.CallConnection;
import com.azure.communication.callautomation.CallConnectionAsync;
import com.azure.communication.callautomation.CallRecordingAsync;
import com.azure.communication.callautomation.ContentDownloader;
import com.azure.communication.callautomation.implementation.AzureCommunicationCallAutomationServiceImpl;
import com.azure.communication.callautomation.implementation.CallConnectionsImpl;
import com.azure.communication.callautomation.implementation.CallMediasImpl;
import com.azure.communication.callautomation.implementation.CallRecordingsImpl;
import com.azure.communication.callautomation.implementation.accesshelpers.CallConnectionPropertiesConstructorProxy;
import com.azure.communication.callautomation.implementation.converters.CommunicationIdentifierConverter;
import com.azure.communication.callautomation.implementation.converters.CommunicationUserIdentifierConverter;
import com.azure.communication.callautomation.implementation.converters.PhoneNumberIdentifierConverter;
import com.azure.communication.callautomation.implementation.models.AnswerCallRequestInternal;
import com.azure.communication.callautomation.implementation.models.CallConnectionPropertiesInternal;
import com.azure.communication.callautomation.implementation.models.CallRejectReasonInternal;
import com.azure.communication.callautomation.implementation.models.CommunicationIdentifierModel;
import com.azure.communication.callautomation.implementation.models.CommunicationUserIdentifierModel;
import com.azure.communication.callautomation.implementation.models.CreateCallRequestInternal;
import com.azure.communication.callautomation.implementation.models.RedirectCallRequestInternal;
import com.azure.communication.callautomation.implementation.models.RejectCallRequestInternal;
import com.azure.communication.callautomation.models.AnswerCallOptions;
import com.azure.communication.callautomation.models.AnswerCallResult;
import com.azure.communication.callautomation.models.CallInvite;
import com.azure.communication.callautomation.models.CreateCallOptions;
import com.azure.communication.callautomation.models.CreateCallResult;
import com.azure.communication.callautomation.models.CreateGroupCallOptions;
import com.azure.communication.callautomation.models.RedirectCallOptions;
import com.azure.communication.callautomation.models.RejectCallOptions;
import com.azure.communication.common.CommunicationIdentifier;
import com.azure.communication.common.CommunicationUserIdentifier;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import java.net.URISyntaxException;
import java.time.OffsetDateTime;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

@ServiceClient(builder=CallAutomationClientBuilder.class, isAsync=true)
public final class CallAutomationAsyncClient {
    private final CallConnectionsImpl callConnectionsInternal;
    private final AzureCommunicationCallAutomationServiceImpl azureCommunicationCallAutomationServiceInternal;
    private final CallRecordingsImpl callRecordingsInternal;
    private final CallMediasImpl callMediasInternal;
    private final ClientLogger logger;
    private final ContentDownloader contentDownloader;
    private final HttpPipeline httpPipelineInternal;
    private final String resourceUrl;
    private final CommunicationUserIdentifierModel sourceIdentity;

    CallAutomationAsyncClient(AzureCommunicationCallAutomationServiceImpl callServiceClient, CommunicationUserIdentifier sourceIdentity) {
        this.callConnectionsInternal = callServiceClient.getCallConnections();
        this.azureCommunicationCallAutomationServiceInternal = callServiceClient;
        this.callRecordingsInternal = callServiceClient.getCallRecordings();
        this.callMediasInternal = callServiceClient.getCallMedias();
        this.logger = new ClientLogger(CallAutomationAsyncClient.class);
        this.contentDownloader = new ContentDownloader(callServiceClient.getEndpoint(), callServiceClient.getHttpPipeline());
        this.httpPipelineInternal = callServiceClient.getHttpPipeline();
        this.resourceUrl = callServiceClient.getEndpoint();
        this.sourceIdentity = sourceIdentity == null ? null : CommunicationUserIdentifierConverter.convert(sourceIdentity);
    }

    public CommunicationUserIdentifier getSourceIdentity() {
        return this.sourceIdentity == null ? null : CommunicationUserIdentifierConverter.convert(this.sourceIdentity);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CreateCallResult> createCall(CallInvite targetParticipant, String callbackUrl) {
        CreateCallOptions createCallOptions = new CreateCallOptions(targetParticipant, callbackUrl);
        return this.createCallWithResponse(createCallOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CreateCallResult> createGroupCall(List<CommunicationIdentifier> targetParticipants, String callbackUrl) {
        CreateGroupCallOptions createGroupCallOptions = new CreateGroupCallOptions(targetParticipants, callbackUrl);
        return this.createGroupCallWithResponse(createGroupCallOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CreateCallResult>> createCallWithResponse(CreateCallOptions createCallOptions) {
        return FluxUtil.withContext(context -> this.createCallWithResponseInternal(createCallOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CreateCallResult>> createGroupCallWithResponse(CreateGroupCallOptions createGroupCallOptions) {
        return FluxUtil.withContext(context -> this.createGroupCallWithResponseInternal(createGroupCallOptions, (Context)context));
    }

    Mono<Response<CreateCallResult>> createCallWithResponseInternal(CreateCallOptions createCallOptions, Context context) {
        try {
            context = context == null ? Context.NONE : context;
            CreateCallRequestInternal request = this.getCreateCallRequestInternal(createCallOptions);
            return this.azureCommunicationCallAutomationServiceInternal.createCallWithResponseAsync(request, UUID.randomUUID(), OffsetDateTime.now(), context).map(response -> {
                try {
                    CallConnectionAsync callConnectionAsync = this.getCallConnectionAsync(((CallConnectionPropertiesInternal)response.getValue()).getCallConnectionId());
                    return new SimpleResponse(response, (Object)new CreateCallResult(CallConnectionPropertiesConstructorProxy.create((CallConnectionPropertiesInternal)response.getValue()), new CallConnection(callConnectionAsync), callConnectionAsync));
                }
                catch (URISyntaxException e) {
                    throw this.logger.logExceptionAsError(new RuntimeException(e));
                }
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<CreateCallResult>> createGroupCallWithResponseInternal(CreateGroupCallOptions createGroupCallOptions, Context context) {
        try {
            context = context == null ? Context.NONE : context;
            CreateCallRequestInternal request = this.getCreateCallRequestInternal(createGroupCallOptions);
            return this.azureCommunicationCallAutomationServiceInternal.createCallWithResponseAsync(request, UUID.randomUUID(), OffsetDateTime.now(), context).map(response -> {
                try {
                    CallConnectionAsync callConnectionAsync = this.getCallConnectionAsync(((CallConnectionPropertiesInternal)response.getValue()).getCallConnectionId());
                    return new SimpleResponse(response, (Object)new CreateCallResult(CallConnectionPropertiesConstructorProxy.create((CallConnectionPropertiesInternal)response.getValue()), new CallConnection(callConnectionAsync), callConnectionAsync));
                }
                catch (URISyntaxException e) {
                    throw this.logger.logExceptionAsError(new RuntimeException(e));
                }
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private CreateCallRequestInternal getCreateCallRequestInternal(CreateCallOptions createCallOptions) {
        LinkedList<CommunicationIdentifierModel> targetsModel = new LinkedList<CommunicationIdentifierModel>();
        targetsModel.add(CommunicationIdentifierConverter.convert(createCallOptions.getCallInvite().getTargetParticipant()));
        CreateCallRequestInternal request = new CreateCallRequestInternal().setSourceCallerIdNumber(PhoneNumberIdentifierConverter.convert(createCallOptions.getCallInvite().getSourceCallerIdNumber())).setSourceDisplayName(createCallOptions.getCallInvite().getSourceDisplayName()).setSource(this.sourceIdentity).setTargets(targetsModel).setCallbackUri(createCallOptions.getCallbackUrl()).setOperationContext(createCallOptions.getOperationContext());
        return request;
    }

    private CreateCallRequestInternal getCreateCallRequestInternal(CreateGroupCallOptions createCallGroupOptions) {
        List<CommunicationIdentifierModel> targetsModel = createCallGroupOptions.getTargetParticipants().stream().map(CommunicationIdentifierConverter::convert).collect(Collectors.toList());
        CreateCallRequestInternal request = new CreateCallRequestInternal().setSourceCallerIdNumber(PhoneNumberIdentifierConverter.convert(createCallGroupOptions.getSourceCallIdNumber())).setSourceDisplayName(createCallGroupOptions.getSourceDisplayName()).setSource(this.sourceIdentity).setTargets(targetsModel).setCallbackUri(createCallGroupOptions.getCallbackUrl()).setOperationContext(createCallGroupOptions.getOperationContext());
        return request;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AnswerCallResult> answerCall(String incomingCallContext, String callbackUrl) {
        return this.answerCallWithResponse(new AnswerCallOptions(incomingCallContext, callbackUrl)).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AnswerCallResult>> answerCallWithResponse(AnswerCallOptions answerCallOptions) {
        return FluxUtil.withContext(context -> this.answerCallWithResponseInternal(answerCallOptions, (Context)context));
    }

    Mono<Response<AnswerCallResult>> answerCallWithResponseInternal(AnswerCallOptions answerCallOptions, Context context) {
        try {
            context = context == null ? Context.NONE : context;
            AnswerCallRequestInternal request = new AnswerCallRequestInternal().setIncomingCallContext(answerCallOptions.getIncomingCallContext()).setCallbackUri(answerCallOptions.getCallbackUrl()).setAnsweredBy(this.sourceIdentity).setOperationContext(answerCallOptions.getOperationContext());
            return this.azureCommunicationCallAutomationServiceInternal.answerCallWithResponseAsync(request, UUID.randomUUID(), OffsetDateTime.now(), context).map(response -> {
                try {
                    CallConnectionAsync callConnectionAsync = this.getCallConnectionAsync(((CallConnectionPropertiesInternal)response.getValue()).getCallConnectionId());
                    return new SimpleResponse(response, (Object)new AnswerCallResult(CallConnectionPropertiesConstructorProxy.create((CallConnectionPropertiesInternal)response.getValue()), new CallConnection(callConnectionAsync), callConnectionAsync));
                }
                catch (URISyntaxException e) {
                    throw this.logger.logExceptionAsError(new RuntimeException(e));
                }
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> redirectCall(String incomingCallContext, CallInvite targetParticipant) {
        RedirectCallOptions redirectCallOptions = new RedirectCallOptions(incomingCallContext, targetParticipant);
        return this.redirectCallWithResponse(redirectCallOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> redirectCallWithResponse(RedirectCallOptions redirectCallOptions) {
        return FluxUtil.withContext(context -> this.redirectCallWithResponseInternal(redirectCallOptions, (Context)context));
    }

    Mono<Response<Void>> redirectCallWithResponseInternal(RedirectCallOptions redirectCallOptions, Context context) {
        try {
            context = context == null ? Context.NONE : context;
            RedirectCallRequestInternal request = new RedirectCallRequestInternal().setIncomingCallContext(redirectCallOptions.getIncomingCallContext()).setTarget(CommunicationIdentifierConverter.convert(redirectCallOptions.getTargetParticipant().getTargetParticipant()));
            return this.azureCommunicationCallAutomationServiceInternal.redirectCallWithResponseAsync(request, UUID.randomUUID(), OffsetDateTime.now(), context);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> rejectCall(String incomingCallContext) {
        RejectCallOptions rejectCallOptions = new RejectCallOptions(incomingCallContext);
        return this.rejectCallWithResponse(rejectCallOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> rejectCallWithResponse(RejectCallOptions rejectCallOptions) {
        return FluxUtil.withContext(context -> this.rejectCallWithResponseInternal(rejectCallOptions, (Context)context));
    }

    Mono<Response<Void>> rejectCallWithResponseInternal(RejectCallOptions rejectCallOptions, Context context) {
        try {
            context = context == null ? Context.NONE : context;
            RejectCallRequestInternal request = new RejectCallRequestInternal().setIncomingCallContext(rejectCallOptions.getIncomingCallContext());
            if (rejectCallOptions.getCallRejectReason() != null) {
                request.setCallRejectReason(CallRejectReasonInternal.fromString(rejectCallOptions.getCallRejectReason().toString()));
            }
            return this.azureCommunicationCallAutomationServiceInternal.rejectCallWithResponseAsync(request, UUID.randomUUID(), OffsetDateTime.now(), context);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public CallConnectionAsync getCallConnectionAsync(String callConnectionId) {
        return new CallConnectionAsync(callConnectionId, this.callConnectionsInternal, this.callMediasInternal);
    }

    public CallRecordingAsync getCallRecordingAsync() {
        return new CallRecordingAsync(this.callRecordingsInternal, this.contentDownloader, this.httpPipelineInternal, this.resourceUrl);
    }
}

