// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Represents a structured collection of result details for content filtering.
 */
@Immutable
public final class ContentFilterDetailedResults implements JsonSerializable<ContentFilterDetailedResults> {

    /*
     * A value indicating whether or not the content has been filtered.
     */
    @Generated
    private final boolean filtered;

    /*
     * The collection of detailed blocklist result information.
     */
    @Generated
    private final List<ContentFilterBlocklistIdResult> details;

    /**
     * Creates an instance of ContentFilterDetailedResults class.
     *
     * @param filtered the filtered value to set.
     * @param details the details value to set.
     */
    @Generated
    private ContentFilterDetailedResults(boolean filtered, List<ContentFilterBlocklistIdResult> details) {
        this.filtered = filtered;
        this.details = details;
    }

    /**
     * Get the filtered property: A value indicating whether or not the content has been filtered.
     *
     * @return the filtered value.
     */
    @Generated
    public boolean isFiltered() {
        return this.filtered;
    }

    /**
     * Get the details property: The collection of detailed blocklist result information.
     *
     * @return the details value.
     */
    @Generated
    public List<ContentFilterBlocklistIdResult> getDetails() {
        return this.details;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("filtered", this.filtered);
        jsonWriter.writeArrayField("details", this.details, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ContentFilterDetailedResults from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ContentFilterDetailedResults if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ContentFilterDetailedResults.
     */
    @Generated
    public static ContentFilterDetailedResults fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean filtered = false;
            List<ContentFilterBlocklistIdResult> details = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("filtered".equals(fieldName)) {
                    filtered = reader.getBoolean();
                } else if ("details".equals(fieldName)) {
                    details = reader.readArray(reader1 -> ContentFilterBlocklistIdResult.fromJson(reader1));
                } else {
                    reader.skipChildren();
                }
            }
            return new ContentFilterDetailedResults(filtered, details);
        });
    }
}
