// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents the outcome of an evaluation against a custom blocklist as performed by content filtering.
 */
@Immutable
public final class ContentFilterBlocklistIdResult implements JsonSerializable<ContentFilterBlocklistIdResult> {

    /*
     * The ID of the custom blocklist evaluated.
     */
    @Generated
    private final String id;

    /*
     * A value indicating whether or not the content has been filtered.
     */
    @Generated
    private final boolean filtered;

    /**
     * Get the id property: The ID of the custom blocklist evaluated.
     *
     * @return the id value.
     */
    @Generated
    public String getId() {
        return this.id;
    }

    /**
     * Get the filtered property: A value indicating whether or not the content has been filtered.
     *
     * @return the filtered value.
     */
    @Generated
    public boolean isFiltered() {
        return this.filtered;
    }

    /**
     * Creates an instance of ContentFilterBlocklistIdResult class.
     *
     * @param filtered the filtered value to set.
     * @param id the id value to set.
     */
    @Generated
    private ContentFilterBlocklistIdResult(boolean filtered, String id) {
        this.filtered = filtered;
        this.id = id;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("filtered", this.filtered);
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ContentFilterBlocklistIdResult from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ContentFilterBlocklistIdResult if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ContentFilterBlocklistIdResult.
     */
    @Generated
    public static ContentFilterBlocklistIdResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean filtered = false;
            String id = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("filtered".equals(fieldName)) {
                    filtered = reader.getBoolean();
                } else if ("id".equals(fieldName)) {
                    id = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            return new ContentFilterBlocklistIdResult(filtered, id);
        });
    }
}
