// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Map;

/**
 * The Batch object.
 */
@Immutable
public final class Batch implements JsonSerializable<Batch> {

    /*
     * The id assigned to the Batch.
     */
    @Generated
    private final String id;

    /*
     * The object type, which is always `batch`.
     */
    @Generated
    private final String object = "batch";

    /*
     * The OpenAI API endpoint used by the batch.
     */
    @Generated
    private String endpoint;

    /*
     * The list of Batch errors.
     */
    @Generated
    private BatchErrorList errors;

    /*
     * The ID of the input file for the batch.
     */
    @Generated
    private final String inputFileId;

    /*
     * The time frame within which the batch should be processed.
     */
    @Generated
    private String completionWindow;

    /*
     * The current status of the batch.
     */
    @Generated
    private BatchStatus status;

    /*
     * The ID of the file containing the outputs of successfully executed requests.
     */
    @Generated
    private String outputFileId;

    /*
     * The ID of the file containing the outputs of requests with errors.
     */
    @Generated
    private String errorFileId;

    /*
     * The Unix timestamp (in seconds) for when the batch was created.
     */
    @Generated
    private Long createdAt;

    /*
     * The Unix timestamp (in seconds) for when the batch started processing.
     */
    @Generated
    private Long inProgressAt;

    /*
     * The Unix timestamp (in seconds) for when the batch will expire.
     */
    @Generated
    private Long expiresAt;

    /*
     * The Unix timestamp (in seconds) for when the batch started finalizing.
     */
    @Generated
    private Long finalizingAt;

    /*
     * The Unix timestamp (in seconds) for when the batch was completed.
     */
    @Generated
    private Long completedAt;

    /*
     * The Unix timestamp (in seconds) for when the batch failed.
     */
    @Generated
    private Long failedAt;

    /*
     * The Unix timestamp (in seconds) for when the batch expired.
     */
    @Generated
    private Long expiredAt;

    /*
     * The Unix timestamp (in seconds) for when the batch started cancelling.
     */
    @Generated
    private Long cancellingAt;

    /*
     * The Unix timestamp (in seconds) for when the batch was cancelled.
     */
    @Generated
    private Long cancelledAt;

    /*
     * The request counts for different statuses within the batch.
     */
    @Generated
    private BatchRequestCounts requestCounts;

    /*
     * A set of key-value pairs that can be attached to the batch. This can be useful for storing additional information
     * about the batch in a structured format.
     */
    @Generated
    private Map<String, String> metadata;

    /**
     * Get the id property: The id assigned to the Batch.
     *
     * @return the id value.
     */
    @Generated
    public String getId() {
        return this.id;
    }

    /**
     * Get the object property: The object type, which is always `batch`.
     *
     * @return the object value.
     */
    @Generated
    public String getObject() {
        return this.object;
    }

    /**
     * Get the endpoint property: The OpenAI API endpoint used by the batch.
     *
     * @return the endpoint value.
     */
    @Generated
    public String getEndpoint() {
        return this.endpoint;
    }

    /**
     * Get the errors property: The list of Batch errors.
     *
     * @return the errors value.
     */
    @Generated
    public BatchErrorList getErrors() {
        return this.errors;
    }

    /**
     * Get the inputFileId property: The ID of the input file for the batch.
     *
     * @return the inputFileId value.
     */
    @Generated
    public String getInputFileId() {
        return this.inputFileId;
    }

    /**
     * Get the completionWindow property: The time frame within which the batch should be processed.
     *
     * @return the completionWindow value.
     */
    @Generated
    public String getCompletionWindow() {
        return this.completionWindow;
    }

    /**
     * Get the status property: The current status of the batch.
     *
     * @return the status value.
     */
    @Generated
    public BatchStatus getStatus() {
        return this.status;
    }

    /**
     * Get the outputFileId property: The ID of the file containing the outputs of successfully executed requests.
     *
     * @return the outputFileId value.
     */
    @Generated
    public String getOutputFileId() {
        return this.outputFileId;
    }

    /**
     * Get the errorFileId property: The ID of the file containing the outputs of requests with errors.
     *
     * @return the errorFileId value.
     */
    @Generated
    public String getErrorFileId() {
        return this.errorFileId;
    }

    /**
     * Get the createdAt property: The Unix timestamp (in seconds) for when the batch was created.
     *
     * @return the createdAt value.
     */
    @Generated
    public OffsetDateTime getCreatedAt() {
        if (this.createdAt == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.createdAt), ZoneOffset.UTC);
    }

    /**
     * Get the inProgressAt property: The Unix timestamp (in seconds) for when the batch started processing.
     *
     * @return the inProgressAt value.
     */
    @Generated
    public OffsetDateTime getInProgressAt() {
        if (this.inProgressAt == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.inProgressAt), ZoneOffset.UTC);
    }

    /**
     * Get the expiresAt property: The Unix timestamp (in seconds) for when the batch will expire.
     *
     * @return the expiresAt value.
     */
    @Generated
    public OffsetDateTime getExpiresAt() {
        if (this.expiresAt == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.expiresAt), ZoneOffset.UTC);
    }

    /**
     * Get the finalizingAt property: The Unix timestamp (in seconds) for when the batch started finalizing.
     *
     * @return the finalizingAt value.
     */
    @Generated
    public OffsetDateTime getFinalizingAt() {
        if (this.finalizingAt == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.finalizingAt), ZoneOffset.UTC);
    }

    /**
     * Get the completedAt property: The Unix timestamp (in seconds) for when the batch was completed.
     *
     * @return the completedAt value.
     */
    @Generated
    public OffsetDateTime getCompletedAt() {
        if (this.completedAt == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.completedAt), ZoneOffset.UTC);
    }

    /**
     * Get the failedAt property: The Unix timestamp (in seconds) for when the batch failed.
     *
     * @return the failedAt value.
     */
    @Generated
    public OffsetDateTime getFailedAt() {
        if (this.failedAt == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.failedAt), ZoneOffset.UTC);
    }

    /**
     * Get the expiredAt property: The Unix timestamp (in seconds) for when the batch expired.
     *
     * @return the expiredAt value.
     */
    @Generated
    public OffsetDateTime getExpiredAt() {
        if (this.expiredAt == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.expiredAt), ZoneOffset.UTC);
    }

    /**
     * Get the cancellingAt property: The Unix timestamp (in seconds) for when the batch started cancelling.
     *
     * @return the cancellingAt value.
     */
    @Generated
    public OffsetDateTime getCancellingAt() {
        if (this.cancellingAt == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.cancellingAt), ZoneOffset.UTC);
    }

    /**
     * Get the cancelledAt property: The Unix timestamp (in seconds) for when the batch was cancelled.
     *
     * @return the cancelledAt value.
     */
    @Generated
    public OffsetDateTime getCancelledAt() {
        if (this.cancelledAt == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.cancelledAt), ZoneOffset.UTC);
    }

    /**
     * Get the requestCounts property: The request counts for different statuses within the batch.
     *
     * @return the requestCounts value.
     */
    @Generated
    public BatchRequestCounts getRequestCounts() {
        return this.requestCounts;
    }

    /**
     * Get the metadata property: A set of key-value pairs that can be attached to the batch. This can be useful for
     * storing additional information about the batch in a structured format.
     *
     * @return the metadata value.
     */
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("object", this.object);
        jsonWriter.writeStringField("input_file_id", this.inputFileId);
        jsonWriter.writeStringField("endpoint", this.endpoint);
        jsonWriter.writeJsonField("errors", this.errors);
        jsonWriter.writeStringField("completion_window", this.completionWindow);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("output_file_id", this.outputFileId);
        jsonWriter.writeStringField("error_file_id", this.errorFileId);
        jsonWriter.writeNumberField("created_at", this.createdAt);
        jsonWriter.writeNumberField("in_progress_at", this.inProgressAt);
        jsonWriter.writeNumberField("expires_at", this.expiresAt);
        jsonWriter.writeNumberField("finalizing_at", this.finalizingAt);
        jsonWriter.writeNumberField("completed_at", this.completedAt);
        jsonWriter.writeNumberField("failed_at", this.failedAt);
        jsonWriter.writeNumberField("expired_at", this.expiredAt);
        jsonWriter.writeNumberField("cancelling_at", this.cancellingAt);
        jsonWriter.writeNumberField("cancelled_at", this.cancelledAt);
        jsonWriter.writeJsonField("request_counts", this.requestCounts);
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Batch from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of Batch if the JsonReader was pointing to an instance of it, or null if it was pointing to
     * JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the Batch.
     */
    @Generated
    public static Batch fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String id = null;
            String inputFileId = null;
            String endpoint = null;
            BatchErrorList errors = null;
            String completionWindow = null;
            BatchStatus status = null;
            String outputFileId = null;
            String errorFileId = null;
            Long createdAt = null;
            Long inProgressAt = null;
            Long expiresAt = null;
            Long finalizingAt = null;
            Long completedAt = null;
            Long failedAt = null;
            Long expiredAt = null;
            Long cancellingAt = null;
            Long cancelledAt = null;
            BatchRequestCounts requestCounts = null;
            Map<String, String> metadata = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                } else if ("input_file_id".equals(fieldName)) {
                    inputFileId = reader.getString();
                } else if ("endpoint".equals(fieldName)) {
                    endpoint = reader.getString();
                } else if ("errors".equals(fieldName)) {
                    errors = BatchErrorList.fromJson(reader);
                } else if ("completion_window".equals(fieldName)) {
                    completionWindow = reader.getString();
                } else if ("status".equals(fieldName)) {
                    status = BatchStatus.fromString(reader.getString());
                } else if ("output_file_id".equals(fieldName)) {
                    outputFileId = reader.getString();
                } else if ("error_file_id".equals(fieldName)) {
                    errorFileId = reader.getString();
                } else if ("created_at".equals(fieldName)) {
                    createdAt = reader.getNullable(JsonReader::getLong);
                } else if ("in_progress_at".equals(fieldName)) {
                    inProgressAt = reader.getNullable(JsonReader::getLong);
                } else if ("expires_at".equals(fieldName)) {
                    expiresAt = reader.getNullable(JsonReader::getLong);
                } else if ("finalizing_at".equals(fieldName)) {
                    finalizingAt = reader.getNullable(JsonReader::getLong);
                } else if ("completed_at".equals(fieldName)) {
                    completedAt = reader.getNullable(JsonReader::getLong);
                } else if ("failed_at".equals(fieldName)) {
                    failedAt = reader.getNullable(JsonReader::getLong);
                } else if ("expired_at".equals(fieldName)) {
                    expiredAt = reader.getNullable(JsonReader::getLong);
                } else if ("cancelling_at".equals(fieldName)) {
                    cancellingAt = reader.getNullable(JsonReader::getLong);
                } else if ("cancelled_at".equals(fieldName)) {
                    cancelledAt = reader.getNullable(JsonReader::getLong);
                } else if ("request_counts".equals(fieldName)) {
                    requestCounts = BatchRequestCounts.fromJson(reader);
                } else if ("metadata".equals(fieldName)) {
                    metadata = reader.readMap(reader1 -> reader1.getString());
                } else {
                    reader.skipChildren();
                }
            }
            Batch deserializedBatch = new Batch(id, inputFileId);
            deserializedBatch.endpoint = endpoint;
            deserializedBatch.errors = errors;
            deserializedBatch.completionWindow = completionWindow;
            deserializedBatch.status = status;
            deserializedBatch.outputFileId = outputFileId;
            deserializedBatch.errorFileId = errorFileId;
            deserializedBatch.createdAt = createdAt;
            deserializedBatch.inProgressAt = inProgressAt;
            deserializedBatch.expiresAt = expiresAt;
            deserializedBatch.finalizingAt = finalizingAt;
            deserializedBatch.completedAt = completedAt;
            deserializedBatch.failedAt = failedAt;
            deserializedBatch.expiredAt = expiredAt;
            deserializedBatch.cancellingAt = cancellingAt;
            deserializedBatch.cancelledAt = cancelledAt;
            deserializedBatch.requestCounts = requestCounts;
            deserializedBatch.metadata = metadata;
            return deserializedBatch;
        });
    }

    /**
     * Creates an instance of Batch class.
     *
     * @param id the id value to set.
     * @param inputFileId the inputFileId value to set.
     */
    @Generated
    private Batch(String id, String inputFileId) {
        this.id = id;
        this.inputFileId = inputFileId;
    }
}
